(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21818,        681]
NotebookOptionsPosition[     16720,        547]
NotebookOutlinePosition[     19182,        596]
CellTagsIndexPosition[     19139,        593]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graphics Objects", "GuideTitle",
 CellID->31351],

Cell[TextData[{
 "At the core of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s graphics language are geometrical objects, represented succinctly and \
efficiently by simple symbolic constructs\[LongDash]to which all of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful symbolic programming capabilities can immediately be applied. "
}], "GuideAbstract",
 CellID->831266689],

Cell[TextData[{
 Cell[TextData[ButtonBox["Point",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Point"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a point or list of points in 2D or 3D"
}], "GuideText",
 CellID->25759],

Cell[TextData[{
 Cell[TextData[ButtonBox["PointSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PointSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsolutePointSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotMarkers",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotMarkers"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30189],

Cell["\t", "GuideDelimiter",
 CellID->30422],

Cell[TextData[{
 Cell[TextData[ButtonBox["Line",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Line"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a line joining a sequence of points in 2D or 3D"
}], "GuideText",
 CellID->27666],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thick",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Thick"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thin",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Thin"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thickness",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thickness"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteThickness",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8486],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dashed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dashed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dotted",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dotted"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DotDashed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DotDashed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dashing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dashing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteDashing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3455],

Cell["\t", "GuideDelimiter",
 CellID->2028],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "an arrow from one point to another"
}], "GuideText",
 CellID->29614],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrowheads",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrowheads"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thickness",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thickness"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dashing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dashing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4860],

Cell["\t", "GuideDelimiter",
 CellID->29253],

Cell[TextData[{
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a polygon in 2D or 3D"
}], "GuideText",
 CellID->11777],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FaceForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FaceForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexColors",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexColors"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Polygons"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31348],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a polygonal mesh or other graphics complex"
}], "GuideText",
 CellID->12503],

Cell["\t", "GuideDelimiter",
 CellID->10861],

Cell[TextData[{
 Cell[TextData[ButtonBox["Disk",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Disk"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Circle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Circle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "filled 2D disk, open 2D circle, ellipse or arc"
}], "GuideText",
 CellID->22431],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rectangle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rectangle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "2D filled rectangle"
}], "GuideText",
 CellID->29082],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thickness",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thickness"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dashing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dashing"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12455],

Cell["\t", "GuideDelimiter",
 CellID->14197],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sphere",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sphere"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D sphere"
}], "GuideText",
 CellID->22106],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cuboid",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cuboid"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D cuboidal box (rectangular parallelepiped)"
}], "GuideText",
 CellID->8752],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cylinder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Cylinder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D cylinder around a line between two points"
}], "GuideText",
 CellID->15821],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Specularity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Specularity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Glow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Glow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dotted",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dotted"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->17296],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "geometry and properties of regular polyhedra"
}], "GuideText",
 CellID->176067152],

Cell["\t", "GuideDelimiter",
 CellID->15947],

Cell[TextData[{
 Cell[TextData[ButtonBox["Raster",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Raster"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "2D image raster"
}], "GuideText",
 CellID->27124],

Cell["\t", "GuideDelimiter",
 CellID->18318],

Cell[TextData[{
 Cell[TextData[ButtonBox["Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Text"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "arbitrary text or other expressions in 2D or 3D"
}], "GuideText",
 CellID->9135],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " arbitrary objects in 2D or 3D inset into a larger graphic"
}], "GuideText",
 CellID->11376]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1774],

Cell[TextData[ButtonBox["Insetting Objects in Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InsettingObjectsInGraphics"]], "GuideTutorial",
 CellID->96742094],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "GuideTutorial",
 CellID->69550799],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "GuideTutorial",
 CellID->563936823],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "GuideTutorial",
 CellID->912269080],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->28810171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12074],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "GuideMoreAbout",
 CellID->9253],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "GuideMoreAbout",
 CellID->6922],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "GuideMoreAbout",
 CellID->322657298]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 40.1088808}", "context" -> "", 
    "keywords" -> {
     "2D polygon", "3D polygon", "3D sphere", "Archimedean polyhedra", 
      "Archimidean polyhedra", "arc of circle", "arrow head", "arrowhead", 
      "ball", "cell array", "circle", "circular arc", "cube", "cuboid", 
      "cylinder", "disk", "double arrow", "edges", "ellipse", 
      "elliptical arc", "elliptical disk", "facet", "filled circle", 
      "filled ellipse", "formulae in 3D graphics", "formulae in graphics", 
      "formulae in notebooks", "graphics arrow", "graphics complex", 
      "graphics primitives", "graphics rectangle", "image array", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "lines", "line segments", "oval", 
      "Platonic solids", "point", "polygonal line", "polyhedra", "polyline", 
      "polytope", "polytopes", "raster graphics", "rectangle", 
      "rectangular parallelepiped", "regular polyhedra", "single arrow", 
      "sphere", "square", "styling of edges", "styling of lines", 
      "styling of points", "surface data", "surface graphics", "surface mesh",
       "surface polygons", "surface triangulation", "text in 3D graphics", 
      "text in graphics", "textual form in 3D graphics", 
      "textual form in graphics", "vector", "volume element", "voxel"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "At the core of Mathematica's graphics language are geometrical objects, \
represented succinctly and efficiently by simple symbolic constructs--to \
which all of Mathematica's powerful symbolic programming capabilities can \
immediately be applied. ", "synonyms" -> {}, "title" -> "Graphics Objects", 
    "type" -> "Guide", "uri" -> "guide/GraphicsObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->31351],
Cell[676, 28, 400, 10, 70, "GuideAbstract",
 CellID->831266689],
Cell[1079, 40, 256, 9, 70, "GuideText",
 CellID->25759],
Cell[1338, 51, 979, 26, 70, "InlineGuideFunctionListing",
 CellID->30189],
Cell[2320, 79, 44, 1, 70, "GuideDelimiter",
 CellID->30422],
Cell[2367, 82, 264, 9, 70, "GuideText",
 CellID->27666],
Cell[2634, 93, 1103, 29, 70, "InlineGuideFunctionListing",
 CellID->8486],
Cell[3740, 124, 1456, 38, 70, "InlineGuideFunctionListing",
 CellID->3455],
Cell[5199, 164, 43, 1, 70, "GuideDelimiter",
 CellID->2028],
Cell[5245, 167, 398, 12, 70, "GuideText",
 CellID->29614],
Cell[5646, 181, 956, 26, 70, "InlineGuideFunctionListing",
 CellID->4860],
Cell[6605, 209, 44, 1, 70, "GuideDelimiter",
 CellID->29253],
Cell[6652, 212, 244, 9, 70, "GuideText",
 CellID->11777],
Cell[6899, 223, 1517, 41, 70, "InlineGuideFunctionListing",
 CellID->31348],
Cell[8419, 266, 426, 12, 70, "GuideText",
 CellID->12503],
Cell[8848, 280, 44, 1, 70, "GuideDelimiter",
 CellID->10861],
Cell[8895, 283, 386, 13, 70, "GuideText",
 CellID->22431],
Cell[9284, 298, 246, 9, 70, "GuideText",
 CellID->29082],
Cell[9533, 309, 1159, 32, 70, "InlineGuideFunctionListing",
 CellID->12455],
Cell[10695, 343, 44, 1, 70, "GuideDelimiter",
 CellID->14197],
Cell[10742, 346, 375, 12, 70, "GuideText",
 CellID->22106],
Cell[11120, 360, 264, 9, 70, "GuideText",
 CellID->8752],
Cell[11387, 371, 414, 12, 70, "GuideText",
 CellID->15821],
Cell[11804, 385, 1796, 47, 70, "InlineGuideFunctionListing",
 CellID->17296],
Cell[13603, 434, 430, 12, 70, "GuideText",
 CellID->176067152],
Cell[14036, 448, 44, 1, 70, "GuideDelimiter",
 CellID->15947],
Cell[14083, 451, 236, 9, 70, "GuideText",
 CellID->27124],
Cell[14322, 462, 44, 1, 70, "GuideDelimiter",
 CellID->18318],
Cell[14369, 465, 263, 9, 70, "GuideText",
 CellID->9135],
Cell[14635, 476, 416, 11, 70, "GuideText",
 CellID->11376]
}, Open  ]],
Cell[CellGroupData[{
Cell[15088, 492, 57, 1, 70, "GuideTutorialsSection",
 CellID->1774],
Cell[15148, 495, 173, 3, 70, "GuideTutorial",
 CellID->96742094],
Cell[15324, 500, 200, 4, 70, "GuideTutorial",
 CellID->69550799],
Cell[15527, 506, 201, 4, 70, "GuideTutorial",
 CellID->563936823],
Cell[15731, 512, 166, 3, 70, "GuideTutorial",
 CellID->912269080],
Cell[15900, 517, 160, 3, 70, "GuideTutorial",
 CellID->28810171]
}, Open  ]],
Cell[CellGroupData[{
Cell[16097, 525, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12074],
Cell[16159, 528, 162, 3, 70, "GuideMoreAbout",
 CellID->9253],
Cell[16324, 533, 149, 3, 70, "GuideMoreAbout",
 CellID->6922],
Cell[16476, 538, 202, 4, 70, "GuideMoreAbout",
 CellID->322657298]
}, Open  ]],
Cell[16693, 545, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

