(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10020,        319]
NotebookOptionsPosition[      6513,        227]
NotebookOutlinePosition[      8664,        272]
CellTagsIndexPosition[      8621,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graphics Transformations", "GuideTitle",
 CellID->29022],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rotate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rotate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rotate an object around any point (use ",
 Cell[TextData[ButtonBox["Degree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 " to specify degrees)"
}], "GuideText",
 CellID->21388],

Cell[TextData[{
 Cell[TextData[ButtonBox["Translate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Translate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "translate an object by a certain vector displacement"
}], "GuideText",
 CellID->7355],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scale",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Scale"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " scale graphical objects (but not text)"
}], "GuideText",
 CellID->13289],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbolic Geometric Transforms \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeometricTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->679655872],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShearingTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->290797115],

Cell[TextData[{
 Cell[TextData[ButtonBox["GeometricTransformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply a symbolic transformation function to an object"
}], "GuideText",
 CellID->159927903],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "inset one graphic inside another"
}], "GuideText",
 CellID->13093],

Cell["\t", "GuideDelimiter",
 CellID->118222449],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scaled",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scaled"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "use scaled coordinates"
}], "GuideText",
 CellID->8217],

Cell["\t", "GuideDelimiter",
 CellID->494313373],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rasterize graphics or other output to get a bitmap or an array of colors"
}], "GuideText",
 CellID->10761],

Cell[TextData[{
 Cell[TextData[ButtonBox["Magnify",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Magnify"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "magnify any output"
}], "GuideText",
 CellID->10987]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->9501],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "GuideTutorial",
 CellID->912269080],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->28810171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15665],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "GuideMoreAboutSub",
 CellID->19095]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Transformations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 42.4839416}", "context" -> "", 
    "keywords" -> {
     "affine transform", "affine transformation", "angle", "angle measure", 
      "angle measurement", "angular measure", "arc", "arcdegree", "degree", 
      "degree of arc", "geometric transform", "geometric transformation", 
      "geometric transforms", "graphics transformations", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "plane angle", "radian", "rotate graphics", 
      "rotation matrix", "rotation transform", "scale graphics", 
      "scaling matrix", "scaling transform", "shearing transform", 
      "transforming graphics", "translate graphics", "translation matrix", 
      "translation transform", "transvection", "zoom"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rotate -- rotate an object around any point (use Degree to specify \
degrees), Translate -- translate an object by a certain vector displacement, \
Scale -- scale graphical objects (but not text), GeometricTransformation -- \
apply a symbolic transformation function to an object, Inset -- inset one \
graphic inside another, Scaled -- use scaled coordinates, Rasterize -- \
rasterize graphics or other output to get a bitmap or an array of colors, \
Magnify -- magnify any output", "synonyms" -> {}, "title" -> 
    "Graphics Transformations", "type" -> "Guide", "uri" -> 
    "guide/GraphicsTransformations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->29022],
Cell[684, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[743, 31, 546, 16, 70, "GuideText",
 CellID->21388],
Cell[1292, 49, 423, 12, 70, "GuideText",
 CellID->7355],
Cell[1718, 63, 397, 11, 70, "GuideText",
 CellID->13289],
Cell[CellGroupData[{
Cell[2140, 78, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->679655872],
Cell[2381, 86, 1305, 32, 70, "InlineGuideFunctionListing",
 CellID->290797115],
Cell[3689, 120, 457, 12, 70, "GuideText",
 CellID->159927903],
Cell[4149, 134, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4200, 137, 396, 12, 70, "GuideText",
 CellID->13093],
Cell[4599, 151, 48, 1, 70, "GuideDelimiter",
 CellID->118222449],
Cell[4650, 154, 242, 9, 70, "GuideText",
 CellID->8217],
Cell[4895, 165, 48, 1, 70, "GuideDelimiter",
 CellID->494313373],
Cell[4946, 168, 444, 12, 70, "GuideText",
 CellID->10761],
Cell[5393, 182, 386, 12, 70, "GuideText",
 CellID->10987]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5828, 200, 57, 1, 70, "GuideTutorialsSection",
 CellID->9501],
Cell[5888, 203, 166, 3, 70, "GuideTutorial",
 CellID->912269080],
Cell[6057, 208, 160, 3, 70, "GuideTutorial",
 CellID->28810171]
}, Open  ]],
Cell[CellGroupData[{
Cell[6254, 216, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15665],
Cell[6316, 219, 155, 3, 70, "GuideMoreAboutSub",
 CellID->19095]
}, Open  ]],
Cell[6486, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

