(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10731,        325]
NotebookOptionsPosition[      6838,        226]
NotebookOutlinePosition[      9332,        276]
CellTagsIndexPosition[      9289,        273]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Hypergeometric Functions", "GuideTitle",
 CellID->26653],

Cell[TextData[{
 "Hundreds of thousands of mathematical results derived at Wolfram Research \
give ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " unprecedented strength in the transformation and simplification of \
hypergeometric functions",
 ". ",
 "This allows hypergeometric functions for the first time to take their place \
as a practical nexus between many special functions\[LongDash]and makes \
possible a major new level of algorithmic calculus."
}], "GuideAbstract",
 CellID->654192969],

Cell[CellGroupData[{

Cell["Ordinary & Generalized Hypergeometric Functions", \
"GuideFunctionsSubsection",
 CellID->7720],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hypergeometric2F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricPFQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeijerG",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MeijerG"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26835]
}, Open  ]],

Cell[CellGroupData[{

Cell["Confluent Hypergeometric Functions", "GuideFunctionsSubsection",
 CellID->25680],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hypergeometric1F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricU",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WhittakerM",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WhittakerM"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WhittakerW",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WhittakerW"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParabolicCylinderD",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric0F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8976]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regularized Hypergeometric Functions", "GuideFunctionsSubsection",
 CellID->18455],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hypergeometric2F1Regularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricPFQRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric1F1Regularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric1F1Regularized"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric0F1Regularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric0F1Regularized"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5725]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Hypergeometric Functions", "GuideFunctionsSubsection",
 CellID->4071],

Cell[TextData[Cell[TextData[ButtonBox["AppellF1",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/AppellF1"]], "InlineFunctionSans"]], \
"InlineGuideFunctionListing",
 CellID->24808]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->13559],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->17832],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->7905],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "GuideMoreAbout",
 CellID->10440]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1999164945],

Cell[TextData[{
 ButtonBox["Demonstrations related to Hypergeometric Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22hypergeometric+functions%22+content%3AAppellF1+OR+Hypergeometric0F1+OR+\
Hypergeometric0F1Regularized+OR+Hypergeometric1F1+OR+\
Hypergeometric1F1Regularized+OR+Hypergeometric2F1+OR+\
Hypergeometric2F1Regularized+OR+HypergeometricPFQ+OR+\
HypergeometricPFQRegularized+OR+HypergeometricU+OR+MeijerG+OR+\
ParabolicCylinderD+OR+WhittakerM+OR+WhittakerW"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->170939073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 48.8278540}", "context" -> "", 
    "keywords" -> {
     "0F0", "0F1", "0F1 regularized", "1F0", "1F1", "1F1 regularized", "1F2", 
      "2F1", "2F1 regularized", "2F2", "2F3", "3F2", "4F3", "5F4", "6F5", 
      "Appell hypergeometric function", 
      "Barnes extended hypergeometric function", "Bateman functions", 
      "confluent hypergeometric function", "Coulomb wave function", 
      "Cunningham function", "Gauss hypergeometric function", "Gauss series", 
      "generalized hypergeometric function", "G-function", "hypergeom", 
      "hypergeometric 0F1", "hypergeometric0 f1 regularized", 
      "hypergeometric 1F1", "hypergeometric1 f1 regularized", 
      "hypergeometric 2F1", "hypergeometric2 f1 regularized", 
      "hypergeometric function", "hypergeometric function 0F1", 
      "hypergeometric functions", "hypergeometric regularized", 
      "Kummer function", "Kummer series", "Meijer G", "Meijer G-function", 
      "Meijer's G-function", "multivariate hypergeometric function", 
      "parabolic cylinder", "parabolic cylinder functions", "pfq", 
      "Poisson-Charlier polynomials", "regularized hypergeometric function", 
      "Riemann P function", "Whittaker functions"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Hundreds of thousands of mathematical results derived at Wolfram \
Research give Mathematica unprecedented strength in the transformation and \
simplification of hypergeometric functions. This allows hypergeometric \
functions for the first time to take their place as a practical nexus between \
many special functions--and makes possible a major new level of algorithmic \
calculus.", "synonyms" -> {}, "title" -> "Hypergeometric Functions", "type" -> 
    "Guide", "uri" -> "guide/HypergeometricFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->26653],
Cell[684, 28, 504, 12, 70, "GuideAbstract",
 CellID->654192969],
Cell[CellGroupData[{
Cell[1213, 44, 100, 2, 70, "GuideFunctionsSubsection",
 CellID->7720],
Cell[1316, 48, 634, 17, 70, "InlineGuideFunctionListing",
 CellID->26835]
}, Open  ]],
Cell[CellGroupData[{
Cell[1987, 70, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->25680],
Cell[2076, 73, 1736, 44, 70, "InlineGuideFunctionListing",
 CellID->8976]
}, Open  ]],
Cell[CellGroupData[{
Cell[3849, 122, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->18455],
Cell[3940, 125, 979, 27, 70, "InlineGuideFunctionListing",
 CellID->5725]
}, Open  ]],
Cell[CellGroupData[{
Cell[4956, 157, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->4071],
Cell[5047, 160, 182, 5, 70, "InlineGuideFunctionListing",
 CellID->24808]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5278, 171, 58, 1, 70, "GuideTutorialsSection",
 CellID->13559],
Cell[5339, 174, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[5524, 182, 59, 1, 70, "GuideMoreAboutSection",
 CellID->17832],
Cell[5586, 185, 145, 3, 70, "GuideMoreAbout",
 CellID->7905],
Cell[5734, 190, 156, 3, 70, "GuideMoreAbout",
 CellID->10440]
}, Open  ]],
Cell[CellGroupData[{
Cell[5927, 198, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1999164945],
Cell[6000, 201, 796, 20, 70, "GuideRelatedLinks",
 CellID->170939073]
}, Open  ]],
Cell[6811, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

