(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15403,        481]
NotebookOptionsPosition[     10114,        352]
NotebookOutlinePosition[     13337,        412]
CellTagsIndexPosition[     13294,        409]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Image Processing", "GuideTitle",
 CellID->16225],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import image data, giving raster data, vector data, etc."
}], "GuideText",
 CellID->18762],

Cell[TextData[{
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " export static or dynamic image data with many options"
}], "GuideText",
 CellID->25043],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TIFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PNG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SVG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SVG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"DICOM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DICOM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->742],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphic or expression to raster form"
}], "GuideText",
 CellID->333177291],

Cell["\t", "GuideDelimiter",
 CellID->21],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display an array of data, using an arbitrary color map"
}], "GuideText",
 CellID->17922],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorRules"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Clip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unitize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unitize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReliefPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReliefPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->24512],

Cell["\t", "GuideDelimiter",
 CellID->9248],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListConvolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListConvolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convolve with a kernel"
}], "GuideText",
 CellID->26018],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply any cellular automaton rule"
}], "GuideText",
 CellID->27368],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fourier"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FourierDCT",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDCT"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FourierDST",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDST"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply discrete Fourier transforms"
}], "GuideText",
 CellID->750392529],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Pick",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pick"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pick out elements based on a template"
}], "GuideText",
 CellID->668099377],

Cell[TextData[{
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Partition"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "partition into blocks"
}], "GuideText",
 CellID->322993109],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten out sub-blocks"
}], "GuideText",
 CellID->30769795],

Cell["\t", "GuideDelimiter",
 CellID->549582115],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " map any function onto pixels"
}], "GuideText",
 CellID->17650]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->13290],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->13290082],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->310182235],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "GuideTutorial",\

 CellID->663467418]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->3169],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "GuideMoreAbout",
 CellID->21895],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "GuideMoreAbout",
 CellID->5303],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "GuideMoreAboutSub",
 CellID->21979],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->929199252],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->436089653],

Cell[TextData[{
 ButtonBox["Demonstrations related to Image Processing",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22image+processing%22+content%3AArrayPlot+OR+CellularAutomaton+OR+\
ColorFunction+OR+ColorRules+OR+Export+OR+Fourier+OR+FourierDCT+OR+FourierDST+\
OR+Import+OR+ListConvolve+OR+Pick+OR+Rasterize+OR+ReliefPlot"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->471860845]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Image Processing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 49.2809906}", "context" -> "", 
    "keywords" -> {
     "array plot", "bas-relief", "biomedical image format", 
      "bitmap graphics formats", "BMP", "capturing images", "cartography", 
      "color function", "color lookup table", "color map", "colormap", 
      "color palette", "color rules", "color spectrum", "DICOM", "DIF format",
       "digital elevation data", "drawing format", "draw programs", 
      "DXF format", "embossing", "encapsulated PostScript", "EPS", "EPSF", 
      "EPSI", "EPSTIFF", "FIR filters", "FITS format", 
      "Flexible Image Transport System", "geometry data", "GIF", "GIS data", 
      "Harwell-Boeing format", "HDF", "hierarchical Data Format", 
      "image capture", "image processing", "images", "image transform", 
      "interchange format", "JFIF", "JPEG", "lithography", 
      "lithography format", "Macintosh PICT", "mapping", "masking", 
      "matrix market format", "matrix structure plot", "medical imaging", 
      "MGF graphics format", "paint programs", "PBM graphics format", "PCX", 
      "PGM graphics format", "PICT", "pictures", "pixmap graphics format", 
      "PNG", "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "power spectrum", "PPM graphics format", 
      "processing images", "radiology formats", "raster conversion", 
      "rasters", "relief plot", "relief shading", "scalable vector graphics", 
      "SDTS importing", "solid object modeling", "spectrum", 
      "stereo-lithography", "stereolithography format", "SVG", 
      "three-dimensional graphics", "TIFF", "Windows metafile format", "WMF", 
      "XBitmap format", "X Windows graphics format"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Import -- import image data, giving raster data, vector data, etc., \
Export -- export static or dynamic image data with many options, Rasterize -- \
convert any Mathematica graphic or expression to raster form, ArrayPlot -- \
display an array of data, using an arbitrary color map, ListConvolve -- \
convolve with a kernel, CellularAutomaton -- apply any cellular automaton \
rule, Fourier, FourierDCT, FourierDST -- apply discrete Fourier transforms, \
Pick -- pick out elements based on a template, Partition -- partition into \
blocks, ArrayFlatten -- flatten out sub-blocks, Map -- map any function onto \
pixels", "synonyms" -> {}, "title" -> "Image Processing", "type" -> "Guide", 
    "uri" -> "guide/ImageProcessing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->16225],
Cell[676, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[735, 31, 272, 8, 70, "GuideText",
 CellID->18762],
Cell[1010, 41, 269, 8, 70, "GuideText",
 CellID->25043],
Cell[1282, 51, 1663, 47, 70, "InlineGuideFunctionListing",
 CellID->742],
Cell[2948, 100, 479, 15, 70, "GuideText",
 CellID->333177291],
Cell[3430, 117, 41, 1, 70, "GuideDelimiter",
 CellID->21],
Cell[3474, 120, 276, 8, 70, "GuideText",
 CellID->17922],
Cell[3753, 130, 1375, 38, 70, "InlineGuideFunctionListing",
 CellID->24512],
Cell[5131, 170, 43, 1, 70, "GuideDelimiter",
 CellID->9248],
Cell[5177, 173, 250, 8, 70, "GuideText",
 CellID->26018],
Cell[5430, 183, 271, 8, 70, "GuideText",
 CellID->27368],
Cell[5704, 193, 807, 22, 70, "GuideText",
 CellID->750392529],
Cell[6514, 217, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[6565, 220, 258, 9, 70, "GuideText",
 CellID->668099377],
Cell[6826, 231, 252, 9, 70, "GuideText",
 CellID->322993109],
Cell[7081, 242, 403, 12, 70, "GuideText",
 CellID->30769795],
Cell[7487, 256, 48, 1, 70, "GuideDelimiter",
 CellID->549582115],
Cell[7538, 259, 238, 8, 70, "GuideText",
 CellID->17650]
}, Open  ]],
Cell[CellGroupData[{
Cell[7813, 272, 58, 1, 70, "GuideTutorialsSection",
 CellID->13290],
Cell[7874, 275, 173, 3, 70, "GuideTutorial",
 CellID->13290082],
Cell[8050, 280, 174, 3, 70, "GuideTutorial",
 CellID->310182235],
Cell[8227, 285, 177, 4, 70, "GuideTutorial",
 CellID->663467418]
}, Open  ]],
Cell[CellGroupData[{
Cell[8441, 294, 58, 1, 70, "GuideMoreAboutSection",
 CellID->3169],
Cell[8502, 297, 125, 3, 70, "GuideMoreAbout",
 CellID->21895],
Cell[8630, 302, 150, 3, 70, "GuideMoreAbout",
 CellID->5303],
Cell[8783, 307, 149, 3, 70, "GuideMoreAboutSub",
 CellID->21979],
Cell[8935, 312, 193, 4, 70, "GuideMoreAbout",
 CellID->929199252],
Cell[9131, 318, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[CellGroupData[{
Cell[9355, 327, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->436089653],
Cell[9427, 330, 645, 17, 70, "GuideRelatedLinks",
 CellID->471860845]
}, Open  ]],
Cell[10087, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

