(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11877,        352]
NotebookOptionsPosition[      6730,        236]
NotebookOutlinePosition[     10309,        301]
CellTagsIndexPosition[     10266,        298]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Importing & Exporting in Notebooks", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The symbolic architecture of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks allows immediate interoperability with a wide range of document, \
web, graphics and other formats. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically performs Copy/Paste and Open/Save conversions, as well as \
providing full programmatic access to hundreds of import/export formats."
}], "GuideAbstract",
 CellID->436695273],

Cell[TextData[{
 StyleBox[ButtonBox["Copy As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CopyAs"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " copy from a notebook in formatted form, plain text form (",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["C", "KeyEvent"],
 "), etc."
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 StyleBox[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Print"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " print to a printer, or a PDF file"
}], "GuideText",
 CellID->11818309],

Cell[TextData[{
 StyleBox[ButtonBox["Print Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintSelection"], "MenuName"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["P", "KeyEvent"],
 ") \[LongDash] print a selection from within a notebook"
}], "GuideText",
 CellID->25284692],

Cell[TextData[{
 StyleBox[ButtonBox["Send To",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SendTo"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " send a notebook as email"
}], "GuideText",
 CellID->565567686],

Cell["\t", "GuideDelimiter",
 CellID->775881043],

Cell[TextData[{
 StyleBox[ButtonBox["Save As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Save"], "MenuName"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["S", "KeyEvent"],
 ") \[LongDash] save a whole notebook in HTML, PDF or many other formats"
}], "GuideText",
 CellID->66484547],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox[
     RowBox[{"Save", " ", "Selection", " ", "As"}], "MenuName"],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/menuitem/SaveSelectionAs"], "MenuName"]], 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " save an individual graphic or other selection in any standard format"
}], "GuideText",
 CellID->218374102],

Cell["\t", "GuideDelimiter",
 CellID->20947592],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " programmatically import, export individual expressions"
}], "GuideText",
 CellID->417844928],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XHTMLMathML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"RTF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RTF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TeX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TeX"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->359929542]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->415146110],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->191929661],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->535839085],

Cell[TextData[ButtonBox["Notebooks as Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebooksAsDocuments"]], "GuideTutorial",
 CellID->46208142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Web Deployment",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Importing & Exporting in Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 50.6560258}", "context" -> "", 
    "keywords" -> {
     "AIFF format", "animations", "arrays", "astronomical data", "audio", 
      "AU format", "AutoCAD format", "AVI", "biomedical image format", 
      "bitmap graphics formats", "bits", "BMP", "CAD", "capturing images", 
      "comma-separated values", "computer-aided design", "conversions", 
      "converting", "CSV format", "data", "ddf format", "desktop publishing", 
      "DICOM", "DIF format", "drawing format", "draw programs", "DXF format", 
      "Encapsulated PostScript", "EPS", "EPSF", "EPSI", "EPSTIFF", 
      "excel format", "Excel format", "exporting graphics", 
      "exporting sounds", "ExpressionML", "external data", "files", 
      "FITS format", "Flexible Image Transport System", "foreign data", "ftp",
       "geometry data", "GIF", "GIS data", "Harwell-Boeing format", "HDF", 
      "Hierarchical Data Format", "http", "image capture", "image processing",
       "images", "interchange format", "JFIF", "JPEG", "lines of text", 
      "lists", "lithography", "lithography format", "Lotus 1-2-3 format", 
      "Macintosh PICT", "MAT format", "matrices", "Matrix Market format", 
      "medical imaging", "metafile format", "Metafile format", 
      "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "MPS", "MTX format", "mu law format", 
      "NotebookML", "output", "paint programs", "PBM graphics format", "PCX", 
      "PGM graphics format", "PICT", "pictures", "pixmap graphics format", 
      "PNG", "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "PPM graphics format", "processing images", 
      "radiology formats", "raster conversion", "rasters", "reading", 
      "scalable vector graphics", "SDTS importing", "SND format", 
      "solid object modeling", "sounds", "spreadsheets", "stereolithography", 
      "stereolithography format", "STL format", "strings", "SVG", 
      "SymbolicXML", "tab-delimited data", "tables", "tabular data", 
      "terrain data", "three-dimensional graphics", "TIFF", "TSV format", 
      "URLs", "WAV format", "web", "web import", "Windows metafile format", 
      "WMF", "words", "writing", "XBitmap format", "XLS format", "XML", 
      "X Windows graphics format"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The symbolic architecture of Mathematica notebooks allows immediate \
interoperability with a wide range of document, web, graphics and other \
formats. Mathematica automatically performs Copy/Paste and Open/Save \
conversions, as well as providing full programmatic access to hundreds of \
import/export formats.", "synonyms" -> {}, "title" -> 
    "Importing & Exporting in Notebooks", "type" -> "Guide", "uri" -> 
    "guide/ImportingAndExportingInNotebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 76, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[698, 28, 455, 11, 70, "GuideAbstract",
 CellID->436695273],
Cell[1156, 41, 448, 14, 70, "GuideText",
 CellID->203374175],
Cell[1607, 57, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1658, 60, 243, 8, 70, "GuideText",
 CellID->11818309],
Cell[1904, 70, 407, 12, 70, "GuideText",
 CellID->25284692],
Cell[2314, 84, 238, 8, 70, "GuideText",
 CellID->565567686],
Cell[2555, 94, 48, 1, 70, "GuideDelimiter",
 CellID->775881043],
Cell[2606, 97, 405, 12, 70, "GuideText",
 CellID->66484547],
Cell[3014, 111, 412, 13, 70, "GuideText",
 CellID->218374102],
Cell[3429, 126, 47, 1, 70, "GuideDelimiter",
 CellID->20947592],
Cell[3479, 129, 397, 12, 70, "GuideText",
 CellID->417844928],
Cell[3879, 143, 1252, 35, 70, "InlineGuideFunctionListing",
 CellID->359929542]
}, Open  ]],
Cell[CellGroupData[{
Cell[5168, 183, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5233, 186, 172, 3, 70, "GuideTutorial",
 CellID->415146110],
Cell[5408, 191, 174, 3, 70, "GuideTutorial",
 CellID->191929661],
Cell[5585, 196, 174, 3, 70, "GuideTutorial",
 CellID->535839085],
Cell[5762, 201, 160, 3, 70, "GuideTutorial",
 CellID->46208142]
}, Open  ]],
Cell[CellGroupData[{
Cell[5959, 209, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6024, 212, 160, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6187, 217, 144, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[6334, 222, 158, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[6495, 227, 193, 4, 70, "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],
Cell[6703, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

