(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14397,        476]
NotebookOptionsPosition[      9988,        361]
NotebookOutlinePosition[     12475,        411]
CellTagsIndexPosition[     12432,        408]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Inequalities", "GuideTitle",
 CellID->2669],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a large number of original algorithms to provide automatic systemwide \
support for inequalities and inequality constraints. Whereas equations can \
often be solved in terms of numbers, even representing solution sets for \
inequalities is only made possible by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic capabilities.  "
}], "GuideAbstract",
 CellID->83897363],

Cell[TextData[{
 Cell[TextData[ButtonBox["Less",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Greater",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LessEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GreaterEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unequal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TestingExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3545],

Cell[TextData[{
 Cell[TextData[ButtonBox["Boole",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Boole"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert from inequalities to 0, 1 values"
}], "GuideText",
 CellID->13597],

Cell[TextData[{
 Cell[TextData[ButtonBox["Piecewise",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Piecewise"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general piecewise function"
}], "GuideText",
 CellID->14218],

Cell["\t", "GuideDelimiter",
 CellID->8838],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "search for particular solutions to inequalities"
}], "GuideText",
 CellID->14844],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce systems of inequalities to explicit nested form"
}], "GuideText",
 CellID->7372],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "integrate over regions defined by inequalities"
}], "GuideText",
 CellID->21028],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot regions defined by inequalities"
}], "GuideText",
 CellID->29264],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Optimization"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "optimization over regions ",
 ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Optimization"]
}], "GuideText",
 CellID->28801],

Cell["\t", "GuideDelimiter",
 CellID->14723],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for constraining 2D or 3D plots to a region"
}], "GuideText",
 CellID->13490],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find inequalities corresponding to named polyhedra"
}], "GuideText",
 CellID->132488558],

Cell["\t", "GuideDelimiter",
 CellID->7604],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out composite inequalities"
}], "GuideText",
 CellID->31601],

Cell[TextData[{
 Cell[TextData[ButtonBox["PiecewiseExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out piecewise functions"
}], "GuideText",
 CellID->24227]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->11197],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/Inequalities-SymbolicMathematics"]], "GuideTutorial",
 CellID->565021816],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "GuideTutorial",
 CellID->907686659],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/RelationalAndLogicalOperators"]], "GuideTutorial",
 CellID->177085099],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "GuideTutorial",
 CellID->132875066]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->20363],

Cell[TextData[ButtonBox["Logic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAbout",
 CellID->29301],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->746326493],

Cell[TextData[ButtonBox["Assumptions & Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "GuideMoreAboutSub",
 CellID->7721]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1887426002],

Cell[TextData[{
 ButtonBox["Demonstrations related to Inequalities",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22inequalities%22+content%3ABoole+OR+Equal+OR+FindInstance+OR+FindMinimum+OR+\
Greater+OR+GreaterEqual+OR+Integrate+OR+Less+OR+LessEqual+OR+LogicalExpand+OR+\
Minimize+OR+NIntegrate+OR+NMinimize+OR+Piecewise+OR+PiecewiseExpand+OR+\
PolyhedronData+OR+Reduce+OR+RegionFunction+OR+RegionPlot+OR+RegionPlot3D+OR+\
Unequal"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->35696256]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inequalities - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 55.3905220}", "context" -> "", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", "biconditional", 
      "Boolean algebra", "Boolean expansion", "Boolean expressions", 
      "Boolean satisfiability", "Boolean tests", "comparison", "conditionals",
       "convex programming", "equal", "equality testing", "equations", 
      "equivalence", "greater", "greater equal", "indicator function", 
      "inequalities", "inequality", "inequation", "infeasible constraints", 
      "integer equations", "integer linear programming", 
      "integer programming", "less", "less equal", "less or equal", 
      "less than", "linear equations", "linear fractional programming", 
      "linear inequalities", "linear programming", "logical expand", "LP", 
      "mathematical equivalence", "mensuration", "minimization", 
      "modular equations", "not-equal", "not equal", 
      "polynomial inequalities", "polynomial programming", 
      "quadratic programming", "ramp function", "reducing inequalities", 
      "regions", "saturation function", "sawtooth function", 
      "sectionally defined functions", "semi-algebraic sets", 
      "strict inequality", "strictly less than", "strong inequality", 
      "testing equality", "two-level logic", "unequal", "weak inequality"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica uses a large number of original algorithms to provide \
automatic systemwide support for inequalities and inequality constraints. \
Whereas equations can often be solved in terms of numbers, even representing \
solution sets for inequalities is only made possible by Mathematica's \
symbolic capabilities. ", "synonyms" -> {}, "title" -> "Inequalities", "type" -> 
    "Guide", "uri" -> "guide/Inequalities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 49, 1, 70, "GuideTitle",
 CellID->2669],
Cell[671, 28, 457, 11, 70, "GuideAbstract",
 CellID->83897363],
Cell[1131, 41, 2072, 71, 70, "InlineGuideFunctionListing",
 CellID->3545],
Cell[3206, 114, 259, 9, 70, "GuideText",
 CellID->13597],
Cell[3468, 125, 253, 9, 70, "GuideText",
 CellID->14218],
Cell[3724, 136, 43, 1, 70, "GuideDelimiter",
 CellID->8838],
Cell[3770, 139, 280, 9, 70, "GuideText",
 CellID->14844],
Cell[4053, 150, 274, 9, 70, "GuideText",
 CellID->7372],
Cell[4330, 161, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4381, 164, 404, 13, 70, "GuideText",
 CellID->21028],
Cell[4788, 179, 690, 19, 70, "GuideText",
 CellID->29264],
Cell[5481, 200, 738, 24, 70, "GuideText",
 CellID->28801],
Cell[6222, 226, 44, 1, 70, "GuideDelimiter",
 CellID->14723],
Cell[6269, 229, 432, 12, 70, "GuideText",
 CellID->13490],
Cell[6704, 243, 431, 11, 70, "GuideText",
 CellID->132488558],
Cell[7138, 256, 43, 1, 70, "GuideDelimiter",
 CellID->7604],
Cell[7184, 259, 268, 9, 70, "GuideText",
 CellID->31601],
Cell[7455, 270, 269, 9, 70, "GuideText",
 CellID->24227]
}, Open  ]],
Cell[CellGroupData[{
Cell[7761, 284, 58, 1, 70, "GuideTutorialsSection",
 CellID->11197],
Cell[7822, 287, 166, 4, 70, "GuideTutorial",
 CellID->565021816],
Cell[7991, 293, 196, 4, 70, "GuideTutorial",
 CellID->907686659],
Cell[8190, 299, 183, 4, 70, "GuideTutorial",
 CellID->177085099],
Cell[8376, 305, 156, 3, 70, "GuideTutorial",
 CellID->132875066]
}, Open  ]],
Cell[CellGroupData[{
Cell[8569, 313, 59, 1, 70, "GuideMoreAboutSection",
 CellID->20363],
Cell[8631, 316, 140, 3, 70, "GuideMoreAbout",
 CellID->29301],
Cell[8774, 321, 152, 3, 70, "GuideMoreAbout",
 CellID->746326493],
Cell[8929, 326, 157, 3, 70, "GuideMoreAboutSub",
 CellID->7721]
}, Open  ]],
Cell[CellGroupData[{
Cell[9123, 334, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1887426002],
Cell[9196, 337, 750, 19, 70, "GuideRelatedLinks",
 CellID->35696256]
}, Open  ]],
Cell[9961, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

