(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13170,        463]
NotebookOptionsPosition[      9710,        366]
NotebookOutlinePosition[     11278,        402]
CellTagsIndexPosition[     11235,        399]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 "Installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system provides a convenient way to call functions in external C and other \
programs. With a ",
 Cell[TextData[{
  ButtonBox[".",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"],
  ButtonBox["tm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"]
 }], "InlineFunctionSans"],
 " template specifying ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions corresponding to each C function, you build a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-installable binary using ",
 Cell[TextData[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"]], "InlineFunctionSans"],
 " or ",
 Cell[TextData[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"]], "InlineFunctionSans"],
 ". You can exchange not only C-like data types such as integers, reals, \
arrays and strings, but also arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Install"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "load a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " installable executable to call from your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Uninstall",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Uninstall"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "close down a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " executable, removing its ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions  "
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkPatterns",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkPatterns"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find functions available in a running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program"
}], "GuideText",
 CellID->630752640],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox[".",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"],
  ButtonBox["tm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " template file for connecting C and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions"
}], "GuideText",
 CellID->556748565],

Cell[TextData[{
 Cell[TextData[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " preprocess ",
 StyleBox[ButtonBox[".tm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/file.tm"], "InlineCode"],
 " files to generate compile C programs (Windows)"
}], "GuideText",
 CellID->281455231],

Cell[TextData[{
 Cell[TextData[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "complete command-line script for building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs (Unix, Mac OS X)"
}], "GuideText",
 CellID->1080338888],

Cell["\t", "GuideDelimiterSubsection",
 CellID->102409081],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["C Language Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCLanguageFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->571418465],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLMain()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMain"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " special version of ",
 StyleBox["main()", "InlineCode"],
 " for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " installable C programs"
}], "GuideText",
 CellID->1727589360],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLEvaluate()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEvaluate"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLEvaluateString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEvaluateString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "call back from C into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "GuideText",
 CellID->1110022948],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetFunction"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "exchange arbitrary structures"
}], "GuideText",
 CellID->116890092]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["-Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "GuideTutorial",
 CellID->1381566544],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Two\[Hyphen]Way Communication with External Programs \
",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]], "GuideTutorial",\

 CellID->806871991],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "GuideTutorial",
 CellID->32584230],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Java Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["C# & .NET Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/guide/DotNETInterface"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Installable MathLink Programs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 56.2186682}", "context" -> "", 
    "keywords" -> {
     "add external function", "extend functions", 
      "information about Mathlink program", "install external program", 
      "link patterns", "Mathlink program usage", "running external programs"},
     "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "The Mathematica system provides a convenient way to call functions in \
external C and other programs. With a .tm template specifying Mathematica \
functions corresponding to each C function, you build a MathLink-installable \
binary using mprep or mcc. You can exchange not only C-like data types such \
as integers, reals, arrays and strings, but also arbitrary Mathematica \
expressions. ", "synonyms" -> {}, "title" -> "Installable MathLink Programs", 
    "type" -> "Guide", "uri" -> "guide/InstallableMathLinkPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 129, 6, 70, "GuideTitle",
 CellID->942062912],
Cell[751, 33, 1071, 34, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1825, 69, 389, 15, 70, "GuideText",
 CellID->203374175],
Cell[2217, 86, 388, 15, 70, "GuideText",
 CellID->1463276848],
Cell[2608, 103, 334, 12, 70, "GuideText",
 CellID->630752640],
Cell[2945, 117, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2996, 120, 412, 16, 70, "GuideText",
 CellID->556748565],
Cell[3411, 138, 394, 12, 70, "GuideText",
 CellID->281455231],
Cell[3808, 152, 347, 12, 70, "GuideText",
 CellID->1080338888],
Cell[4158, 166, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->102409081],
Cell[CellGroupData[{
Cell[4241, 171, 234, 5, 70, "GuideFunctionsSubsection",
 CellID->571418465],
Cell[4478, 178, 363, 13, 70, "GuideText",
 CellID->1727589360],
Cell[4844, 193, 462, 16, 70, "GuideText",
 CellID->1110022948],
Cell[5309, 211, 558, 18, 70, "GuideText",
 CellID->116890092]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5916, 235, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5981, 238, 489, 14, 70, "GuideTutorial",
 CellID->1381566544],
Cell[6473, 254, 400, 11, 70, "GuideTutorial",
 CellID->1885805579],
Cell[6876, 267, 218, 6, 70, "GuideTutorial",
 CellID->806871991],
Cell[7097, 275, 419, 12, 70, "GuideTutorial",
 CellID->32584230],
Cell[7519, 289, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[7857, 300, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[8191, 311, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8558, 325, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8623, 328, 154, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8780, 333, 162, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[8945, 338, 263, 9, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[9211, 349, 457, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[9683, 364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

