(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15694,        474]
NotebookOptionsPosition[     11769,        368]
NotebookOutlinePosition[     13773,        411]
CellTagsIndexPosition[     13730,        408]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Interactive Manipulation", "GuideTitle",
 CellID->3855],

Cell[TextData[{
 "The single function ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " gives immediate access to a huge range of powerful interactive \
capabilities. For any expression with symbolic parameters, ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " automatically creates an interface for manipulating the parameters. ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " supports not only mouse and keyboard manipulation, but also gamepads and \
other devices."
}], "GuideAbstract",
 CellID->6734],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interactively manipulate any expression, graphic or other object"
}], "GuideText",
 CellID->8184],

Cell["\t", "GuideDelimiter",
 CellID->7075],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "animate any graphic or expression"
}], "GuideText",
 CellID->28382],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "animate a list of graphics or expressions"
}], "GuideText",
 CellID->14119],

Cell["\t", "GuideDelimiterSubsection",
 CellID->332797383],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Options & Styling \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->221896270],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControlPlacement",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlPlacement"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControlType",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlType"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SaveDefinitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OptionsAndStylingForInteractiveManipulation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->280786996],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotRange"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Text"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OptionsAndStylingForInteractiveManipulation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->481072718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Control Types \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ControlObjects"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->210621126],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make one or more 2D variables be controlled by locators inside a graphic"
}], "GuideText",
 CellID->537449039],

Cell[TextData[{
 Cell[TextData[ButtonBox["Trigger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Trigger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set up a \"trigger\" that starts a variable changing with time"
}], "GuideText",
 CellID->348222262],

Cell[TextData[{
 Cell[TextData[ButtonBox["Slider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetterBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SetterBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Animator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InputField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InputField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlObjects"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->471968789],

Cell["\t", "GuideDelimiter",
 CellID->25971697],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["drag", "PointerEvent"],
 ", ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " move a slider progressively more slowly"
}], "GuideText",
 CellID->464942386],

Cell["\t", "GuideDelimiter",
 CellID->625529955],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerManipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "manipulate only with an external controller (e.g. gamepad)"
}], "GuideText",
 CellID->1061898372]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->6741],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "GuideTutorial",
 CellID->29812],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "GuideTutorial",\

 CellID->19375]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12779],

Cell[TextData[ButtonBox["Viewers & Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "GuideMoreAbout",
 CellID->12279],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "GuideMoreAbout",
 CellID->18283],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAbout",
 CellID->20667],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "GuideMoreAboutSub",
 CellID->16525797],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"]], "GuideMoreAboutSub",
 CellID->24118]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interactive Manipulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 58.5937290}", "context" -> "", 
    "keywords" -> {
     "animate sequence of expressions", "applets", "click-interactive panels",
       "control active", "controller manipulate", "control placement", 
      "controls", "control type", "direct manipulation", 
      "graphical user interface", "grip", "handle", "input bar", "input box", 
      "input field", "interactive panels", "interface builder", "joystick", 
      "knob", "list animate", "list of frames", "make movie", 
      "mouse interactive", "movable thumb", "popup menu", "scrollbar", 
      "setter bar", "setter control", "single selection control", "slider", 
      "thumb", "user interfaces", "zoom in plot", "direct manipulation", 
      "gamepads", "GUI", "interface", "sliders"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The single function Manipulate gives immediate access to a huge range of \
powerful interactive capabilities. For any expression with symbolic \
parameters, Manipulate automatically creates an interface for manipulating \
the parameters. Manipulate supports not only mouse and keyboard manipulation, \
but also gamepads and other devices.", "synonyms" -> {}, "title" -> 
    "Interactive Manipulation", "type" -> "Guide", "uri" -> 
    "guide/InteractiveManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->3855],
Cell[683, 28, 1181, 26, 70, "GuideAbstract",
 CellID->6734],
Cell[1867, 56, 437, 12, 70, "GuideText",
 CellID->8184],
Cell[2307, 70, 43, 1, 70, "GuideDelimiter",
 CellID->7075],
Cell[2353, 73, 401, 12, 70, "GuideText",
 CellID->28382],
Cell[2757, 87, 417, 12, 70, "GuideText",
 CellID->14119],
Cell[3177, 101, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->332797383],
Cell[CellGroupData[{
Cell[3260, 106, 248, 5, 70, "GuideFunctionsSubsection",
 CellID->221896270],
Cell[3511, 113, 1318, 33, 70, "InlineGuideFunctionListing",
 CellID->280786996],
Cell[4832, 148, 1553, 42, 70, "InlineGuideFunctionListing",
 CellID->481072718]
}, Open  ]],
Cell[CellGroupData[{
Cell[6422, 195, 215, 5, 70, "GuideFunctionsSubsection",
 CellID->210621126],
Cell[6640, 202, 444, 12, 70, "GuideText",
 CellID->537449039],
Cell[7087, 216, 289, 9, 70, "GuideText",
 CellID->348222262],
Cell[7379, 227, 1960, 50, 70, "InlineGuideFunctionListing",
 CellID->471968789],
Cell[9342, 279, 47, 1, 70, "GuideDelimiter",
 CellID->25971697],
Cell[9392, 282, 422, 14, 70, "GuideText",
 CellID->464942386],
Cell[9817, 298, 48, 1, 70, "GuideDelimiter",
 CellID->625529955],
Cell[9868, 301, 457, 12, 70, "GuideText",
 CellID->1061898372]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10374, 319, 57, 1, 70, "GuideTutorialsSection",
 CellID->6741],
Cell[10434, 322, 159, 3, 70, "GuideTutorial",
 CellID->29812],
Cell[10596, 327, 175, 4, 70, "GuideTutorial",
 CellID->19375]
}, Open  ]],
Cell[CellGroupData[{
Cell[10808, 336, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12779],
Cell[10870, 339, 153, 3, 70, "GuideMoreAbout",
 CellID->12279],
Cell[11026, 344, 171, 3, 70, "GuideMoreAbout",
 CellID->18283],
Cell[11200, 349, 169, 3, 70, "GuideMoreAbout",
 CellID->20667],
Cell[11372, 354, 170, 3, 70, "GuideMoreAboutSub",
 CellID->16525797],
Cell[11545, 359, 182, 4, 70, "GuideMoreAboutSub",
 CellID->24118]
}, Open  ]],
Cell[11742, 366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

