(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34601,       1067]
NotebookOptionsPosition[     30230,        955]
NotebookOutlinePosition[     32545,       1002]
CellTagsIndexPosition[     32502,        999]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["International Character Sets", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports full Unicode throughout\[LongDash]in strings, symbols, graphics \
and external operations\[LongDash]allowing immediate streamlined use of all \
standard international character sets, integrated with native text entry. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Extended Latin Characters", "GuideFunctionsSubsection",
 CellID->192946210],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[AGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AGrave"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[AAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[AHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AHat"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ATilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ATilde"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ACup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ACup"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ADoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ADoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ABar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ABar"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ARing"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[AE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AE"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CHacek]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CHacek"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CCedilla]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CCedilla"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EGrave"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EHat"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ECup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ECup"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EDoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EBar"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[IGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IGrave"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[IAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[IHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IHat"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ICup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ICup"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[IDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IDoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[Eth]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Eth"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[LSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LSlash"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[NTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NTilde"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[OGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OGrave"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[OAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[OHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OHat"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[OTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OTilde"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ODoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ODoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ODoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ODoubleAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[OSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OSlash"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[SHacek]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SHacek"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[UGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UGrave"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[UAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[UHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UHat"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[UDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UDoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[UDoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UDoubleAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[YAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/YAcute"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[YDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/YDoubleDot"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[Thorn]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Thorn"]], "InlineCharacterDisplay"]
}], "InlineGuideFunctionListing",
 CellID->195951733],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[CapitalAGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAGrave"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalAAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalAHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAHat"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalATilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalATilde"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalACup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalACup"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalADoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalADoubleDot"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalABar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalABar"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalARing"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalAE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAE"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalCAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalCAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalCHacek]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalCHacek"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalCCedilla]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalCCedilla"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEGrave"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEHat"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalECup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalECup"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEDoubleDot"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEBar"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalIGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalIGrave"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalIAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalIAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalIHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalIHat"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalICup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalICup"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalIDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalIDoubleDot"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEth]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEth"]], "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalLSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalLSlash"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalNTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalNTilde"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalOGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOGrave"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalOAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalOHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOHat"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalOTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOTilde"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalODoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalODoubleDot"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalODoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalODoubleAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalOSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalOSlash"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalSHacek]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalSHacek"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalUGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUGrave"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalUAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalUHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUHat"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalUDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUDoubleDot"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalUDoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUDoubleAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalYAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalYAcute"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalThorn]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalThorn"]], 
  "InlineCharacterDisplay"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[SZ]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SZ"]], "InlineCharacterDisplay"]
}], "InlineGuideFunctionListing",
 CellID->704305182],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[EAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EAcute"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]e'\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EGrave]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EGrave"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]e`\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EDoubleDot"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]e\"\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[EHat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EHat"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]e^\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ECup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ECup"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]eu\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "GuideText",
 CellID->532254445],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[EAcute]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/EAcute"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[EGrave]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/EGrave"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[EDoubleDot]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/EDoubleDot"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[EHat]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/EHat"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ECup]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ECup"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->165098716],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[OSlash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/OSlash"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]o/\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[AE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AE"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ae\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CapitalEAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEAcute"]], 
  "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]E'\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[SZ]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SZ"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sz\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[Thorn]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Thorn"]], "InlineCharacterDisplay"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]thn\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "GuideText",
 CellID->345179925],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[OSlash]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/OSlash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[AE]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/AE"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CapitalEAcute]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CapitalEAcute"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[SZ]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/SZ"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[Thorn]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Thorn"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->421623149],

Cell["\t", "GuideDelimiterSubsection",
 CellID->35077929]
}, Open  ]],

Cell[CellGroupData[{

Cell["Entering All Characters", "GuideFunctionsSubsection",
 CellID->174203534],

Cell[TextData[{
 StyleBox["\\[", "InlineCode"],
 StyleBox["Name", "TI"],
 StyleBox["]", "InlineCode"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["nnn", "TI"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " named character"
}], "GuideText",
 CellID->343127962],

Cell[TextData[{
 StyleBox["\\", "InlineCode"],
 StyleBox["nn", "TI"],
 ", ",
 StyleBox["\\:", "InlineCode"],
 StyleBox["nnnn", "TI"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " enter octal or Unicode forms"
}], "GuideText",
 CellID->234333375],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " show characters with full names"
}], "GuideText",
 CellID->454895198]
}, Open  ]],

Cell[CellGroupData[{

Cell["Importing & Exporting Characters", "GuideFunctionsSubsection",
 CellID->170044938],

Cell[TextData[{
 Cell[TextData[ButtonBox["CharacterEncoding",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for specific functions"
}], "GuideText",
 CellID->499878698],

Cell[TextData[{
 Cell[TextData[ButtonBox["$CharacterEncoding",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "resettable global ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " default"
}], "GuideText",
 CellID->167343239],

Cell[TextData[{
 Cell[TextData[ButtonBox["$SystemCharacterEncoding",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$SystemCharacterEncoding"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "operating system default"
}], "GuideText",
 CellID->753489844],

Cell[TextData[{
 Cell[TextData[ButtonBox["$CharacterEncodings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of installed character encodings"
}], "GuideText",
 CellID->708760804],

Cell[TextData[{
 "\"ISOLatin1\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"IsoLatin2\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"UTF8\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"ShiftJIS\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\"PrintableASCII\"",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->429697174]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Raw Character Encodings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RawCharacterEncodings"]], "GuideTutorial",
 CellID->260452659]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Listing of All Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "GuideMoreAbout",
 CellID->37101391],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "GuideMoreAboutSub",
 CellID->172019104]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"International Character Sets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 59.0937418}", "context" -> "", 
    "keywords" -> {
     "16-bit characters", "Arabic", "character encoding", 
      "character encodings", "character mnemonics", "character set", 
      "character sets", "Chinese", "code set", "communicating expressions", 
      "communicating language", "Cyrillic", "Danish", "file encoding", 
      "file encoding", "file language", "font encodings", "French", 
      "full form", "functional notation", "German", "Greek", "Hindi", 
      "Hungarian", "internal form", "ISO 8859", "ISO Latin-1", "ISO Latin-2", 
      "ISO Latin-3", "ISO Latin-4", "Japanese", "Kanji", "Katakana", "Korean",
       "language representation", "multilingual", "native character sets", 
      "non-ASCII characters", "Norwegian", "object serialization", 
      "output of internal form", "output of internal representation", 
      "pattern matching", "Polish", "Portuguese", "prefix form", 
      "raw character input", "Russian", "serialization", "Spanish", 
      "special characters", "Swedish", "system character encoding", 
      "transmitting expressions", "tree representation", "Turkish", "Unicode",
       "Unicode files", "Unicode strings"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica supports full Unicode throughout--in strings, symbols, \
graphics and external operations--allowing immediate streamlined use of all \
standard international character sets, integrated with native text entry. ", 
    "synonyms" -> {}, "title" -> "International Character Sets", "type" -> 
    "Guide", "uri" -> "guide/InternationalCharacterSets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[692, 28, 338, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1055, 39, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->192946210],
Cell[1139, 42, 9286, 253, 70, "InlineGuideFunctionListing",
 CellID->195951733],
Cell[10428, 297, 9955, 290, 70, "InlineGuideFunctionListing",
 CellID->704305182],
Cell[20386, 589, 1747, 58, 70, "GuideText",
 CellID->532254445],
Cell[22136, 649, 1223, 38, 70, "InlineGuideFunctionListing",
 CellID->165098716],
Cell[23362, 689, 1746, 59, 70, "GuideText",
 CellID->345179925],
Cell[25111, 750, 1222, 39, 70, "InlineGuideFunctionListing",
 CellID->421623149],
Cell[26336, 791, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->35077929]
}, Open  ]],
Cell[CellGroupData[{
Cell[26430, 797, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->174203534],
Cell[26512, 800, 381, 14, 70, "GuideText",
 CellID->343127962],
Cell[26896, 816, 250, 10, 70, "GuideText",
 CellID->234333375],
Cell[27149, 828, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[27200, 831, 255, 8, 70, "GuideText",
 CellID->454895198]
}, Open  ]],
Cell[CellGroupData[{
Cell[27492, 844, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->170044938],
Cell[27583, 847, 276, 9, 70, "GuideText",
 CellID->499878698],
Cell[27862, 858, 329, 12, 70, "GuideText",
 CellID->167343239],
Cell[28194, 872, 285, 9, 70, "GuideText",
 CellID->753489844],
Cell[28482, 883, 288, 9, 70, "GuideText",
 CellID->708760804],
Cell[28773, 894, 547, 23, 70, "InlineGuideFunctionListing",
 CellID->429697174]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29369, 923, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[29434, 926, 163, 3, 70, "GuideTutorial",
 CellID->260452659]
}, Open  ]],
Cell[CellGroupData[{
Cell[29634, 934, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[29699, 937, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[29855, 942, 171, 3, 70, "GuideMoreAbout",
 CellID->37101391],
Cell[30029, 947, 159, 3, 70, "GuideMoreAboutSub",
 CellID->172019104]
}, Open  ]],
Cell[30203, 953, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

