(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29456,        931]
NotebookOptionsPosition[     22269,        749]
NotebookOutlinePosition[     25752,        814]
CellTagsIndexPosition[     25709,        811]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["List Manipulation", "GuideTitle",
 CellID->19770],

Cell[TextData[{
 "Lists are central constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", used to represent collections, arrays, sets and sequences of all kinds. \
Lists can have any structure and size, and can routinely involve even \
millions of elements",
 ". ",
 "Well over a thousand built-in functions throughout ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operate directly on lists, making lists a powerful vehicle for \
interoperability. "
}], "GuideAbstract",
 CellID->19022],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Constructing Lists \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConstructingLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->210079377],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox[
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/List"], " "}]], "InlineGuideFunction"],
 " (",
 Cell[TextData[ButtonBox["List",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/List"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify a list explicitly"
}], "GuideText",
 CellID->585555718],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make a table of values of an expression"
}], "GuideText",
 CellID->192436566],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make an array of any dimension from a function "
}], "GuideText",
 CellID->17626622],

Cell[TextData[{
 Cell[TextData[ButtonBox["Range",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Range"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tuples",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tuples"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sow",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sow"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reap",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reap"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConstructingLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->77549831],

Cell["\t", "GuideDelimiterSubsection",
 CellID->103641565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Elements of Lists \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ElementsOfLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->488696974],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["list",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"], "TI"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 ")",
 " ",
 " parts or sequences of parts (",
 Cell[BoxData[";;"], "InlineFormula"],
 "), resettable with ",
 Cell[BoxData["="], "InlineFormula"]
}], "GuideText",
 CellID->11749],

Cell[TextData[{
 Cell[TextData[ButtonBox["First",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/First"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Last",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Last"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Extract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extract"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementsOfLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6932],

Cell[TextData[{
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select according to a function"
}], "GuideText",
 CellID->25619],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give cases matching a pattern"
}], "GuideText",
 CellID->16081],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementsOfLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24488227],

Cell["\t", "GuideDelimiterSubsection",
 CellID->6164239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Rearranging & Restructuring Lists \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RearrangingAndRestructuringLists"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->18631],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten out nested lists"
}], "GuideText",
 CellID->42965187],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Partition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Split",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Split"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->140192015],

Cell["\t", "GuideDelimiterSubsection",
 CellID->399010984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Applying Functions to Lists \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ApplyingFunctionsToLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->23152],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ") \[LongDash] map a function over a list:  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "/@", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"]}], "}"}]}], "\[LongRightArrow]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["a", "TI"], "]"}], ",", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["b", "TI"], "]"}], ",", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["c", "TI"], "]"}]}], "}"}]}]], "InlineFormula"]
}], "GuideText",
 CellID->6972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["@@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ") \[LongDash] apply a function to a list: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "@@", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"]}], "}"}]}], "\[LongRightArrow]", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"]}], "]"}]}]], "InlineFormula"]
}], "GuideText",
 CellID->26821],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapIndexed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapIndexed"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Scan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapThread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapThread"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FoldList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FoldList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->395814447],

Cell["\t", "GuideDelimiterSubsection",
 CellID->223344047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Math & Counting Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->47413515],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", "..", "}"}], "+", 
   RowBox[{"{", "..", "}"}]}]], "InlineGuideFunction"],
 ", etc. \[LongDash] automatically operate in parallel on list elements"
}], "GuideText",
 CellID->344079080],

Cell[TextData[{
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalAndCountingOperationsOnLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->698310021],

Cell["\t", "GuideDelimiterSubsection",
 CellID->33505638]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Displaying & Visualizing Lists \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->25428],

Cell[TextData[{
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataVisualization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->29681],

Cell["\t", "GuideDelimiterSubsection",
 CellID->554301934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Importing & Exporting Lists \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExporting"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->370959599],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Text\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Text"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->66995094]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1411],

Cell[TextData[ButtonBox["Making Lists of Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingListsOfObjects"]], "GuideTutorial",
 CellID->235730823],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "GuideTutorial",
 CellID->2454211],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "GuideTutorial",\

 CellID->401388161],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingListsByTheirIndices"]], "GuideTutorial",
 CellID->73061360],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "GuideTutorial",
 CellID->40478342],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "GuideTutorial",
 CellID->742426301],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TestingAndSearchingListElements"]], "GuideTutorial",
 CellID->104562874]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18490],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "GuideMoreAboutSub",
 CellID->75962464],

Cell[TextData[ButtonBox["Handling Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->26177],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "GuideMoreAboutSub",
 CellID->118043673],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "GuideMoreAbout",
 CellID->31071],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "GuideMoreAbout",
 CellID->162813629],

Cell[TextData[ButtonBox["General Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "GuideMoreAboutSub",
 CellID->20643],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"List Manipulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 7.4533308}", "context" -> "", 
    "keywords" -> {
     "alphabetizing of lists", "appending", "applying functions", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", 
      "applying functions with multiple arguments", 
      "applying indexed functions", "beginning of list", "catenating lists", 
      "changing parts", "choose elements", "circular partitioning", 
      "concatenating lists", "cumulative sums", "cyclic partitioning", 
      "deleting elements", "discard elements", "discard list elements", 
      "element of a list", "filtering lists", "fold list", "frequencies", 
      "gather", "gathering elements in lists", "grade in APL", 
      "growing lists", "index in APL", "indices", "interleave", "iota in APL",
       "iterated functions", "iterated operations", 
      "iteration of unary operators", "join lists", "length of list", 
      "levels", "linked lists", "list member", "lists", "lists ordering", 
      "map indexed", "map thread", "matrices", "membership test", 
      "merging lists", "multivariate Map", "nest list", "number of elements", 
      "number of occurrences", "number of terms", "ordered pairs", 
      "outer products", "partitioning lists", "parts", 
      "permutation of indices", "picking elements of lists", 
      "picking out sequences of elements in lists", "present in list", 
      "range counts", "ravel in APL", "removing elements from lists", 
      "repeating expressions", "replacements", "replace part", 
      "replicating expressions", "reshape in APL", "segments of lists", 
      "sequence", "sequence of elements", "size of array", "sorting of lists",
       "span", "sparse array", "sparse matrix", "sparse representation", 
      "sparse vector", "splicing", "splitting lists", "stride", 
      "subexpressions", "sublists", "submatrices", "sum of array elements", 
      "sum of list", "table", "tables", "tally", "test for elements in lists",
       "testing for presence", "threading over lists", "total of list", 
      "transpose of matrices", "transposition of lists", "tree walking", 
      "unflatten", "unravel", "wraparound partitioning", 
      "wrapping functions around elements of lists"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Lists are central constructs in Mathematica, used to represent \
collections, arrays, sets and sequences of all kinds. Lists can have any \
structure and size, and can routinely involve even millions of elements. Well \
over a thousand built-in functions throughout Mathematica operate directly on \
lists, making lists a powerful vehicle for interoperability. ", 
    "synonyms" -> {}, "title" -> "List Manipulation", "type" -> "Guide", 
    "uri" -> "guide/ListManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->19770],
Cell[677, 28, 511, 14, 70, "GuideAbstract",
 CellID->19022],
Cell[CellGroupData[{
Cell[1213, 46, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->210079377],
Cell[1439, 53, 529, 20, 70, "GuideText",
 CellID->585555718],
Cell[1971, 75, 257, 8, 70, "GuideText",
 CellID->192436566],
Cell[2231, 85, 264, 8, 70, "GuideText",
 CellID->17626622],
Cell[2498, 95, 1419, 41, 70, "InlineGuideFunctionListing",
 CellID->77549831],
Cell[3920, 138, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->103641565]
}, Open  ]],
Cell[CellGroupData[{
Cell[4015, 144, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->488696974],
Cell[4238, 151, 823, 32, 70, "GuideText",
 CellID->11749],
Cell[5064, 185, 1613, 47, 70, "InlineGuideFunctionListing",
 CellID->6932],
Cell[6680, 234, 246, 8, 70, "GuideText",
 CellID->25619],
Cell[6929, 244, 243, 8, 70, "GuideText",
 CellID->16081],
Cell[7175, 254, 809, 23, 70, "InlineGuideFunctionListing",
 CellID->24488227],
Cell[7987, 279, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->6164239]
}, Open  ]],
Cell[CellGroupData[{
Cell[8080, 285, 251, 6, 70, "GuideFunctionsSubsection",
 CellID->18631],
Cell[8334, 293, 250, 9, 70, "GuideText",
 CellID->42965187],
Cell[8587, 304, 1789, 51, 70, "InlineGuideFunctionListing",
 CellID->140192015],
Cell[10379, 357, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->399010984]
}, Open  ]],
Cell[CellGroupData[{
Cell[10474, 363, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->23152],
Cell[10714, 371, 863, 30, 70, "GuideText",
 CellID->6972],
Cell[11580, 403, 849, 29, 70, "GuideText",
 CellID->26821],
Cell[12432, 434, 1440, 42, 70, "InlineGuideFunctionListing",
 CellID->395814447],
Cell[13875, 478, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->223344047]
}, Open  ]],
Cell[CellGroupData[{
Cell[13970, 484, 255, 6, 70, "GuideFunctionsSubsection",
 CellID->47413515],
Cell[14228, 492, 242, 7, 70, "GuideText",
 CellID->344079080],
Cell[14473, 501, 1685, 45, 70, "InlineGuideFunctionListing",
 CellID->698310021],
Cell[16161, 548, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->33505638]
}, Open  ]],
Cell[CellGroupData[{
Cell[16255, 554, 233, 6, 70, "GuideFunctionsSubsection",
 CellID->25428],
Cell[16491, 562, 1574, 42, 70, "InlineGuideFunctionListing",
 CellID->29681],
Cell[18068, 606, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->554301934]
}, Open  ]],
Cell[CellGroupData[{
Cell[18163, 612, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->370959599],
Cell[18404, 620, 1238, 35, 70, "InlineGuideFunctionListing",
 CellID->66995094]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19691, 661, 57, 1, 70, "GuideTutorialsSection",
 CellID->1411],
Cell[19751, 664, 162, 3, 70, "GuideTutorial",
 CellID->235730823],
Cell[19916, 669, 160, 3, 70, "GuideTutorial",
 CellID->2454211],
Cell[20079, 674, 206, 5, 70, "GuideTutorial",
 CellID->401388161],
Cell[20288, 681, 187, 4, 70, "GuideTutorial",
 CellID->73061360],
Cell[20478, 687, 141, 3, 70, "GuideTutorial",
 CellID->40478342],
Cell[20622, 692, 201, 4, 70, "GuideTutorial",
 CellID->742426301],
Cell[20826, 698, 188, 4, 70, "GuideTutorial",
 CellID->104562874]
}, Open  ]],
Cell[CellGroupData[{
Cell[21051, 707, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18490],
Cell[21113, 710, 162, 3, 70, "GuideMoreAboutSub",
 CellID->75962464],
Cell[21278, 715, 149, 3, 70, "GuideMoreAbout",
 CellID->26177],
Cell[21430, 720, 160, 3, 70, "GuideMoreAboutSub",
 CellID->118043673],
Cell[21593, 725, 146, 3, 70, "GuideMoreAbout",
 CellID->31071],
Cell[21742, 730, 131, 3, 70, "GuideMoreAbout",
 CellID->162813629],
Cell[21876, 735, 146, 3, 70, "GuideMoreAboutSub",
 CellID->20643],
Cell[22025, 740, 202, 4, 70, "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],
Cell[22242, 747, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

