(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16661,        531]
NotebookOptionsPosition[     11310,        405]
NotebookOutlinePosition[     14754,        468]
CellTagsIndexPosition[     14711,        465]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Logic & Boolean Algebra", "GuideTitle",
 CellID->16840],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents Boolean expressions in symbolic form, so they can not only be \
evaluated, but also be symbolically manipulated and transformed",
 ". ",
 "Incorporating state-of-the-art quantifier elimination, satisfiability and \
equational logic theorem proving, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a powerful framework for investigations based on Boolean algebra. \
"
}], "GuideAbstract",
 CellID->27633],

Cell[TextData[{
 Cell[TextData[ButtonBox["And",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 "(",
 Cell[BoxData[
  RowBox[{
   ButtonBox["&&",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"], ",", 
   ButtonBox["\[And]",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"]}]], "InlineFormula"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Or",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 "(",
 Cell[BoxData[
  RowBox[{
   ButtonBox["||",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"], ",", 
   ButtonBox["\[Or]",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"]}]], "InlineFormula"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Not",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Not"]], "InlineFunctionSans"],
 "(",
 Cell[BoxData[
  RowBox[{
   ButtonBox["!",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], ",", 
   ButtonBox["\[Not]",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"]}]], "InlineFormula"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nand"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Nand]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nand"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nor"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Nor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nor"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Xor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Xor"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Xor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Xor"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Implies",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Implies"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Implies]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Implies"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unequal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["True",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/True"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["False",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/False"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->20274],

Cell["\t", "GuideDelimiter",
 CellID->223463300],

Cell[TextData[{
 Cell[TextData[ButtonBox["If",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Which",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Which"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Piecewise",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Piecewise"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12993],

Cell[TextData[{
 Cell[TextData[ButtonBox["Boole",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Boole"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert symbolic truth values to 0 and 1"
}], "GuideText",
 CellID->28782],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out logical expressions to canonical form"
}], "GuideText",
 CellID->32203],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "simplify logic expressions and prove theorems"
}], "GuideText",
 CellID->8290],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find instances where Boolean expressions are satisfied"
}], "GuideText",
 CellID->19662],

Cell["\t", "GuideDelimiter",
 CellID->22307],

Cell[TextData[{
 Cell[TextData[ButtonBox["ForAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ForAll]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 ") \[LongDash] universal quantifier"
}], "GuideText",
 CellID->20997],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exists",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Exists]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 ") \[LongDash] existential quantifier"
}], "GuideText",
 CellID->31151],

Cell[TextData[{
 Cell[TextData[ButtonBox["Resolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate quantifiers in Boolean and other domains"
}], "GuideText",
 CellID->18423],

Cell["\t", "GuideDelimiter",
 CellID->323570503],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "operate on Boolean vectors"
}], "GuideText",
 CellID->240061531],

Cell[TextData[{
 Cell[TextData[ButtonBox["HammingDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HammingDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatchingDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->190205122]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->8890],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/RelationalAndLogicalOperators"]], "GuideTutorial",
 CellID->16717],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "GuideTutorial",
 CellID->6640],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "GuideTutorial",
 CellID->552044440]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->28703],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "GuideMoreAbout",
 CellID->5566],

Cell[TextData[ButtonBox["Assumptions & Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "GuideMoreAbout",
 CellID->4883],

Cell[TextData[ButtonBox["Distance & Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DistanceAndDissimilarityMeasures"]], "GuideMoreAboutSub",
 CellID->18245],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "GuideMoreAboutSub",
 CellID->351793548]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1767717326],

Cell[TextData[{
 ButtonBox["Demonstrations related to Logic & Boolean Algebra",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22mathematical+logic%22+content%3AAnd+OR+Boole+OR+Equal+OR+Exists+OR+False+OR+\
FindClusters+OR+FindInstance+OR+ForAll+OR+FullSimplify+OR+HammingDistance+OR+\
Implies+OR+LogicalExpand+OR+MatchingDissimilarity+OR+Nand+OR+Nearest+OR+Nor+\
OR+Not+OR+Or+OR+Piecewise+OR+Resolve+OR+True+OR+Unequal+OR+Which+OR+Xor"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->267872234]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Logic & Boolean Algebra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 10.5471600}", "context" -> "", 
    "keywords" -> {
     "ampersand", "And", "bang", "Bar", "biconditional", "Boolean", 
      "Boolean algebra", "Boolean expansion", "Boolean expressions", 
      "Boolean satisfiability", "Boolean tests", "characteristic function", 
      "CNF", "combinatorial explosion", "combinatorial simplification", 
      "combine conditions", "complement", "complete simplification", 
      "concise form", "conditional", "conditional inclusion", "conditionals", 
      "conjunctive normal form", "constraints", "contradiction", 
      "counter example", "counter-example", "decision problem", 
      "De Morgan's laws", "denial", "disjunction", "disjunctive normal form", 
      "DNF", "equal", "equality testing", "equivalence", 
      "exclusive disjunction", "exclusive Or", "existence", 
      "existential quantifier", "exist quantifier", "false", "find instance", 
      "first order logic", "for all", "for all quantifier", 
      "gamma function simplification", "general quantifier", "hybrid systems",
       "identical expressions", "implication", "inclusive Or", 
      "indicator function", "inequality", "inequation", "inequivalent", 
      "intersection", "interval-defined functions", "inversion", 
      "Iverson's convention", "joint denial", "laws of form", "logical plus", 
      "logical bar", "logical connective", "logical expand", "logical plus", 
      "logical prime", "logical product", "logical sum", "logical value", 
      "logic quantifier", "matching dissimilarity", "material implication", 
      "mathematical equivalence", "modulo 2", "multiple conditional", 
      "negation", "Not", "not-equal", "not equal", "not unless", 
      "number theory", "Or ", "piecewise functions", "predicates", 
      "propositional logic", "quantifier elimination", "reflection formula", 
      "relations", "remove quantifiers", "sample points", "satisfiability", 
      "satisfiability problem", "SAT problem", "switching", 
      "switching algebra", "testing equality", "theorem proving", 
      "truth value", "two-level logic", "unequal", "unequivalent", 
      "universal quantifier", "universal quantor", "vertical bar", "bit"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica represents Boolean expressions in symbolic form, so they can \
not only be evaluated, but also be symbolically manipulated and transformed. \
Incorporating state-of-the-art quantifier elimination, satisfiability and \
equational logic theorem proving, Mathematica provides a powerful framework \
for investigations based on Boolean algebra. ", "synonyms" -> {}, "title" -> 
    "Logic & Boolean Algebra", "type" -> "Guide", "uri" -> 
    "guide/LogicAndBooleanAlgebra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->16840],
Cell[683, 28, 498, 13, 70, "GuideAbstract",
 CellID->27633],
Cell[1184, 43, 3441, 125, 70, "InlineGuideFunctionListing",
 CellID->20274],
Cell[4628, 170, 48, 1, 70, "GuideDelimiter",
 CellID->223463300],
Cell[4679, 173, 555, 16, 70, "InlineGuideFunctionListing",
 CellID->12993],
Cell[5237, 191, 259, 9, 70, "GuideText",
 CellID->28782],
Cell[5499, 202, 283, 9, 70, "GuideText",
 CellID->32203],
Cell[5785, 213, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[5836, 216, 277, 9, 70, "GuideText",
 CellID->8290],
Cell[6116, 227, 287, 9, 70, "GuideText",
 CellID->19662],
Cell[6406, 238, 44, 1, 70, "GuideDelimiter",
 CellID->22307],
Cell[6453, 241, 328, 10, 70, "GuideText",
 CellID->20997],
Cell[6784, 253, 330, 10, 70, "GuideText",
 CellID->31151],
Cell[7117, 265, 273, 9, 70, "GuideText",
 CellID->18423],
Cell[7393, 276, 48, 1, 70, "GuideDelimiter",
 CellID->323570503],
Cell[7444, 279, 678, 19, 70, "GuideText",
 CellID->240061531],
Cell[8125, 300, 958, 24, 70, "InlineGuideFunctionListing",
 CellID->190205122]
}, Open  ]],
Cell[CellGroupData[{
Cell[9120, 329, 57, 1, 70, "GuideTutorialsSection",
 CellID->8890],
Cell[9180, 332, 179, 4, 70, "GuideTutorial",
 CellID->16717],
Cell[9362, 338, 138, 3, 70, "GuideTutorial",
 CellID->6640],
Cell[9503, 343, 141, 3, 70, "GuideTutorial",
 CellID->552044440]
}, Open  ]],
Cell[CellGroupData[{
Cell[9681, 351, 59, 1, 70, "GuideMoreAboutSection",
 CellID->28703],
Cell[9743, 354, 155, 3, 70, "GuideMoreAbout",
 CellID->5566],
Cell[9901, 359, 154, 3, 70, "GuideMoreAbout",
 CellID->4883],
Cell[10058, 364, 184, 4, 70, "GuideMoreAboutSub",
 CellID->18245],
Cell[10245, 370, 155, 3, 70, "GuideMoreAboutSub",
 CellID->351793548]
}, Open  ]],
Cell[CellGroupData[{
Cell[10437, 378, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1767717326],
Cell[10510, 381, 758, 19, 70, "GuideRelatedLinks",
 CellID->267872234]
}, Open  ]],
Cell[11283, 403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

