(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12391,        416]
NotebookOptionsPosition[      8628,        315]
NotebookOutlinePosition[     10559,        357]
CellTagsIndexPosition[     10516,        354]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Looping Constructs", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Looping is a core concept in programming",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides powerful primitives for specifying and controlling looping, not \
only in traditional procedural programming, but also in other, more modern \
and streamlined programming paradigms."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " evaluate an expression looping over a variable: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->4193387],

Cell["\t", "GuideDelimiter",
 CellID->98292867],

Cell[TextData[{
 Cell[TextData[ButtonBox["While",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/While"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " evaluate an expression while a criterion is true: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"], "[", 
   RowBox[{
    StyleBox["crit", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->34794504],

Cell[TextData[{
 Cell[TextData[ButtonBox["For",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/For"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a \"for loop\": ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"], "[", 
   RowBox[{
    StyleBox["init", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["incr", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->133778855],

Cell["\t", "GuideDelimiter",
 CellID->69182372],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " build up a table by looping over variables: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->106243706],

Cell["\t", "GuideDelimiterSubsection",
 CellID->37522215],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Functional Iteration Constructs \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionalIteration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->187534966],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NestWhile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FixedPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPoint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fold"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionalIteration"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->47913145],

Cell["\t", "GuideDelimiterSubsection",
 CellID->252213526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Iterating Over Lists & Expressions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ApplyingFunctionsToLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->218441694],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapIndexed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapIndexed"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplaceRepeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["//.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2973686],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loop Termination", "GuideFunctionsSubsection",
 CellID->35162469],

Cell[TextData[{
 Cell[TextData[ButtonBox["Throw",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Throw"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "exit any loop, going to the nearest enclosing ",
 Cell[TextData[ButtonBox["Catch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Catch"]], "InlineFunctionSans"]
}], "GuideText",
 CellID->301985723],

Cell[TextData[{
 Cell[TextData[ButtonBox["Break",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Break"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Continue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Continue"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Return",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Return"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Interrupt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interrupt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abort"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->413964806]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Repetitive Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepetitiveOperations"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Looping Constructs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 11.3440554}", "context" -> "", 
    "keywords" -> {
     "abort", "applying indexed functions", "computed goto", 
      "conditional iteration", "data driven iteration", "fixed point", 
      "iterated functions", "iteration", "jump", "longjmp", "loops", 
      "map indexed", "nesting of functions", "NestList", "nest while", 
      "non-local returns", "parallel form of Map", "procedures", "repeat", 
      "repeated rule application", "repeating expressions", "replacement", 
      "replace repeated", "ReplaceRepeated", "replicating expressions", 
      "returns", "routines", "Scan", "simultaneous application", "stop", 
      "stopping calculations", "subroutines", "table", "terminate", 
      "terminating computations", "termination of loop", "tree walking", 
      "until", "while"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Looping is a core concept in programming. Mathematica provides powerful \
primitives for specifying and controlling looping, not only in traditional \
procedural programming, but also in other, more modern and streamlined \
programming paradigms.", "synonyms" -> {}, "title" -> "Looping Constructs", 
    "type" -> "Guide", "uri" -> "guide/LoopingConstructs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 353, 9, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1038, 39, 541, 19, 70, "GuideText",
 CellID->4193387],
Cell[1582, 60, 47, 1, 70, "GuideDelimiter",
 CellID->98292867],
Cell[1632, 63, 483, 16, 70, "GuideText",
 CellID->34794504],
Cell[2118, 81, 510, 18, 70, "GuideText",
 CellID->133778855],
Cell[2631, 101, 47, 1, 70, "GuideDelimiter",
 CellID->69182372],
Cell[2681, 104, 551, 19, 70, "GuideText",
 CellID->106243706],
Cell[3235, 125, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->37522215],
Cell[CellGroupData[{
Cell[3317, 130, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->187534966],
Cell[3560, 138, 1017, 29, 70, "InlineGuideFunctionListing",
 CellID->47913145],
Cell[4580, 169, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->252213526]
}, Open  ]],
Cell[CellGroupData[{
Cell[4675, 175, 248, 6, 70, "GuideFunctionsSubsection",
 CellID->218441694],
Cell[4926, 183, 1253, 40, 70, "InlineGuideFunctionListing",
 CellID->2973686],
Cell[6182, 225, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[6277, 231, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->35162469],
Cell[6351, 234, 383, 12, 70, "GuideText",
 CellID->301985723],
Cell[6737, 248, 1006, 29, 70, "InlineGuideFunctionListing",
 CellID->413964806]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7792, 283, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7857, 286, 172, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[8032, 291, 161, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[8230, 299, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8295, 302, 144, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[8442, 307, 144, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[8601, 313, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

