(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11595,        352]
NotebookOptionsPosition[      8530,        270]
NotebookOutlinePosition[     10250,        309]
CellTagsIndexPosition[     10207,        306]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Low-Level Interface Control", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The core of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " unique power for building interfaces is in its extremely flexible \
high-level symbolic paradigm. But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to build interfaces at a lower level, more familiar to \
traditional user interface programmers. "
}], "GuideAbstract",
 CellID->509177920],

Cell[TextData[{
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "explicitly handle many low-level interface events"
}], "GuideText",
 CellID->6654],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrontEndEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->48240209],

Cell["\t", "GuideDelimiter",
 CellID->158934864],

Cell[TextData[{
 Cell[TextData[ButtonBox["MousePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MousePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the current mouse position in many coordinate systems"
}], "GuideText",
 CellID->29734],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the current state of any control in an external controller device"
}], "GuideText",
 CellID->108331715],

Cell[TextData[{
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test and set hundreds of user interface properties"
}], "GuideText",
 CellID->58727630],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsoluteCurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AbsoluteCurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Clock",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Clock"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$ControlActiveSetting",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ControlActiveSetting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->848875348],

Cell["\t", "GuideDelimiter",
 CellID->2370290],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "define dynamic content"
}], "GuideText",
 CellID->415455315],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scope dynamic interface variables"
}], "GuideText",
 CellID->152235076],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDocument",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateDocument"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CellPrint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellPrint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EmitSound",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EmitSound"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->343979282],

Cell["\t", "GuideDelimiter",
 CellID->103721231],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrontEndExecute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " programmatically execute built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface commands"
}], "GuideText",
 CellID->27685317]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAbout",
 CellID->29470529],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "GuideMoreAbout",
 CellID->2607],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "GuideMoreAbout",
 CellID->142645122],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Low-Level Interface Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 12.4222080}", "context" -> "", 
    "keywords" -> {
     "absolute current value", "absolute value", "cell event actions", 
      "cell print", "control active", "controller state", "create cell", 
      "create document", "current value", "dynamic module", "emit sound", 
      "event handler", "front end event actions", "front end execute", 
      "incremental writing of notebooks", "inserting cells", "mouse position",
       "notebook event actions", "notebook write", "paste", "pasting", 
      "writing to notebook", "GUI programming"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The core of Mathematica's unique power for building interfaces is in its \
extremely flexible high-level symbolic paradigm. But Mathematica also allows \
you to build interfaces at a lower level, more familiar to traditional user \
interface programmers. ", "synonyms" -> {}, "title" -> 
    "Low-Level Interface Control", "type" -> "Guide", "uri" -> 
    "guide/LowLevelInterfaceControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 404, 12, 70, "GuideAbstract",
 CellID->509177920],
Cell[1098, 42, 426, 12, 70, "GuideText",
 CellID->6654],
Cell[1527, 56, 1102, 26, 70, "InlineGuideFunctionListing",
 CellID->48240209],
Cell[2632, 84, 48, 1, 70, "GuideDelimiter",
 CellID->158934864],
Cell[2683, 87, 438, 12, 70, "GuideText",
 CellID->29734],
Cell[3124, 101, 458, 12, 70, "GuideText",
 CellID->108331715],
Cell[3585, 115, 431, 12, 70, "GuideText",
 CellID->58727630],
Cell[4019, 129, 1301, 32, 70, "InlineGuideFunctionListing",
 CellID->848875348],
Cell[5323, 163, 46, 1, 70, "GuideDelimiter",
 CellID->2370290],
Cell[5372, 166, 394, 12, 70, "GuideText",
 CellID->415455315],
Cell[5769, 180, 417, 12, 70, "GuideText",
 CellID->152235076],
Cell[6189, 194, 1128, 29, 70, "InlineGuideFunctionListing",
 CellID->343979282],
Cell[7320, 225, 48, 1, 70, "GuideDelimiter",
 CellID->103721231],
Cell[7371, 228, 344, 11, 70, "GuideText",
 CellID->27685317]
}, Open  ]],
Cell[CellGroupData[{
Cell[7752, 244, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7817, 247, 172, 3, 70, "GuideMoreAbout",
 CellID->29470529],
Cell[7992, 252, 141, 3, 70, "GuideMoreAbout",
 CellID->2607],
Cell[8136, 257, 175, 3, 70, "GuideMoreAbout",
 CellID->142645122],
Cell[8314, 262, 174, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[8503, 268, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

