(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16387,        568]
NotebookOptionsPosition[     11433,        431]
NotebookOutlinePosition[     13600,        475]
CellTagsIndexPosition[     13557,        472]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 "Low-Level ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Operations"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Sending Low-Level Data", "GuideFunctionsSubsection",
 CellID->896423474],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutNext"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "prepare to send an object of the specified type"
}], "GuideText",
 CellID->1591543813],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutSize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify the number of bytes to send"
}], "GuideText",
 CellID->1875928591],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "send raw bytes"
}], "GuideText",
 CellID->702124464],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLBytesToPut()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLBytesToPut"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the number of bytes remaining to be sent"
}], "GuideText",
 CellID->183226183]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Low-Level Data", "GuideFunctionsSubsection",
 CellID->405782871],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetNext"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "continue to the next object, and return its type"
}], "GuideText",
 CellID->85965984],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetType"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "return the type of the current object"
}], "GuideText",
 CellID->29074544],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get raw bytes"
}], "GuideText",
 CellID->213477090],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLBytesToGet()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLBytesToGet"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the number of bytes to receive"
}], "GuideText",
 CellID->203374175]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Handling", "GuideFunctionsSubsection",
 CellID->21602899],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLErrorMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLErrorMessage"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "information on the most recent error"
}], "GuideText",
 CellID->522487435],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLClearError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLClearError"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clear the most recent error"
}], "GuideText",
 CellID->385687462]
}, Open  ]],

Cell[CellGroupData[{

Cell["Flow Control", "GuideFunctionsSubsection",
 CellID->379704009],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReady()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReady"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLReadyParallel()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReadyParallel"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether there is data ready to be read"
}], "GuideText",
 CellID->196612415],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLFlush()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLFlush"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "send any data currently buffered"
}], "GuideText",
 CellID->477277541],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLCreateMark()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLCreateMark"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLSeekToMark()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSeekToMark"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rewind to specified positions"
}], "GuideText",
 CellID->34012239],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLSetYieldFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetYieldFunction"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetYieldFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetYieldFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "functions to call while waiting"
}], "GuideText",
 CellID->1980158803]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interrupts & Aborts", "GuideFunctionsSubsection",
 CellID->993999390],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessage"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutMessageWithArg()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessageWithArg"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "send an interrupt or abort message"
}], "GuideText",
 CellID->575224850],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessage"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " receive an interrupt or abort message"
}], "GuideText",
 CellID->1594656312],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLMessageReady()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageReady"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether an interrupt or abort message is available"
}], "GuideText",
 CellID->277065780],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLSetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetMessageHandler"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessageHandler"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "handler for messages received"
}], "GuideText",
 CellID->792721224],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLSetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetSignalHandler"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLUnsetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLUnsetSignalHandler"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "handler for signals on Unix"
}], "GuideText",
 CellID->1392722487]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Error and Interrupt Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ErrorAndInterruptHandling"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "GuideMoreAboutSub",
 CellID->164162700],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "GuideMoreAboutSub",
 CellID->56762096],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->39561623]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Low-Level MathLink Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 12.7347160}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutNext() -- prepare to send an object of the specified type, \
MLPutSize() -- specify the number of bytes to send, MLPutData() -- send raw \
bytes, MLBytesToPut() -- find the number of bytes remaining to be sent, \
MLGetNext() -- continue to the next object, and return its type, MLGetType() \
-- return the type of the current object, MLGetData() -- get raw bytes, \
MLBytesToGet() -- the number of bytes to receive, MLError(), MLErrorMessage() \
-- information on the most recent error, MLClearError() -- clear the most \
recent error, MLReady(), MLReadyParallel() -- test whether there is data \
ready to be read, MLFlush() -- send any data currently buffered, \
MLCreateMark(), MLSeekToMark(), ... -- rewind to specified positions, \
MLSetYieldFunction(), MLGetYieldFunction() -- functions to call while \
waiting, MLPutMessage(), MLPutMessageWithArg() -- send an interrupt or abort \
message, MLGetMessage() -- receive an interrupt or abort message, \
MLMessageReady() -- whether an interrupt or abort message is available, \
MLSetMessageHandler(), MLGetMessageHandler() -- handler for messages \
received, MLSetSignalHandler(), MLUnsetSignalHandler() -- handler for signals \
on Unix", "synonyms" -> {}, "title" -> "Low-Level MathLink Operations", 
    "type" -> "Guide", "uri" -> "guide/LowLevelMathLinkOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 129, 6, 70, "GuideTitle",
 CellID->942062912],
Cell[751, 33, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[832, 38, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->896423474],
Cell[913, 41, 283, 9, 70, "GuideText",
 CellID->1591543813],
Cell[1199, 52, 271, 9, 70, "GuideText",
 CellID->1875928591],
Cell[1473, 63, 249, 9, 70, "GuideText",
 CellID->702124464],
Cell[1725, 74, 286, 9, 70, "GuideText",
 CellID->183226183]
}, Open  ]],
Cell[CellGroupData[{
Cell[2048, 88, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->405782871],
Cell[2131, 91, 282, 9, 70, "GuideText",
 CellID->85965984],
Cell[2416, 102, 271, 9, 70, "GuideText",
 CellID->29074544],
Cell[2690, 113, 248, 9, 70, "GuideText",
 CellID->213477090],
Cell[2941, 124, 271, 9, 70, "GuideText",
 CellID->203374175]
}, Open  ]],
Cell[CellGroupData[{
Cell[3249, 138, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->21602899],
Cell[3321, 141, 410, 13, 70, "GuideText",
 CellID->522487435],
Cell[3734, 156, 268, 9, 70, "GuideText",
 CellID->385687462]
}, Open  ]],
Cell[CellGroupData[{
Cell[4039, 170, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->379704009],
Cell[4110, 173, 419, 13, 70, "GuideText",
 CellID->196612415],
Cell[4532, 188, 263, 9, 70, "GuideText",
 CellID->477277541],
Cell[4798, 199, 456, 14, 70, "GuideText",
 CellID->34012239],
Cell[5257, 215, 436, 13, 70, "GuideText",
 CellID->1980158803]
}, Open  ]],
Cell[CellGroupData[{
Cell[5730, 233, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->993999390],
Cell[5808, 236, 428, 13, 70, "GuideText",
 CellID->575224850],
Cell[6239, 251, 274, 8, 70, "GuideText",
 CellID->1594656312],
Cell[6516, 261, 290, 8, 70, "GuideText",
 CellID->277065780],
Cell[6809, 271, 437, 13, 70, "GuideText",
 CellID->792721224],
Cell[7249, 286, 436, 13, 70, "GuideText",
 CellID->1392722487]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7734, 305, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7799, 308, 211, 5, 70, "GuideTutorial",
 CellID->1885805579],
Cell[8013, 315, 172, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[8188, 320, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[8526, 331, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[8860, 342, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9227, 356, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9292, 359, 309, 9, 70, "GuideMoreAboutSub",
 CellID->164162700],
Cell[9604, 370, 336, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9943, 381, 356, 9, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[10302, 392, 313, 9, 70, "GuideMoreAboutSub",
 CellID->56762096],
Cell[10618, 403, 327, 9, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[10948, 414, 443, 12, 70, "GuideMoreAboutSub",
 CellID->39561623]
}, Open  ]],
Cell[11406, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

