(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21463,        660]
NotebookOptionsPosition[     14842,        501]
NotebookOutlinePosition[     18570,        567]
CellTagsIndexPosition[     18527,        564]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Low-Level Notebook Programming", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic architecture, every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook you see is represented as a symbolic expression, that can be \
manipulated and controlled programmatically using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic language. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s low-level notebook programming functions give direct incremental access \
to notebook expressions, allowing you to successively perform arbitrary \
operations on the \"selection\" in any notebook."
}], "GuideAbstract",
 CellID->72150565],

Cell[CellGroupData[{

Cell["Notebook Handles", "GuideFunctionsSubsection",
 CellID->123778769],

Cell[TextData[{
 Cell[TextData[ButtonBox["Notebooks",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Notebooks"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a list of open notebooks (",
 Cell[TextData[ButtonBox["NotebookObject",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookObject"]], "InlineFunctionSans"],
 " objects)"
}], "GuideText",
 CellID->375265711],

Cell[TextData[{
 Cell[TextData[ButtonBox["SelectedNotebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SelectedNotebook"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvaluationNotebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluationNotebook"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InputNotebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputNotebook"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ButtonNotebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ButtonNotebook"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->190978241],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookLocate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookLocate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "locate a notebook, a web notebook, or a tag in a notebook"
}], "GuideText",
 CellID->83181588]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operations on Complete Notebooks", "GuideFunctionsSubsection",
 CellID->40366285],

Cell[TextData[{
 Cell[TextData[ButtonBox["Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Options"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SetOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetOptions"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get or set any option of any notebook object"
}], "GuideText",
 CellID->237188989],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetSelectedNotebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetSelectedNotebook"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookClose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookClose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookSave",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookSave"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookPrint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookPrint"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16994604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbolic Notebook Structure \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelNotebookStructure"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->517660653],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookGet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookGet"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get the symbolic representation of a displayed notebook"
}], "GuideText",
 CellID->469076087],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookPut",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookPut"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display the notebook corresponding to a symbolic expression"
}], "GuideText",
 CellID->15194977],

Cell[TextData[{
 Cell[TextData[ButtonBox["Notebook",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Notebook"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cell"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RowBox",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RowBox"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ButtonBox",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ButtonBox"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GridBox",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GridBox"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelNotebookStructure"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->577050260]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modifying Notebook Contents", "GuideFunctionsSubsection",
 CellID->3123184],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookFind",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookFind"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a structure within a notebook"
}], "GuideText",
 CellID->29577412],

Cell[TextData[{
 Cell[TextData[ButtonBox["SelectionMove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SelectionMove"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "move the selection in a notebook"
}], "GuideText",
 CellID->364402447],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookRead"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read the current selection as a symbolic expression "
}], "GuideText",
 CellID->306310362],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookWrite"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NotebookApply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookApply"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "write, apply content at the current selection"
}], "GuideText",
 CellID->24982529],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookDelete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookDelete"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "delete the current selection"
}], "GuideText",
 CellID->322015122],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowSelection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowSelection"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Visible",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Visible"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AutoScroll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoScroll"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->56046676],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookSelection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookSelection"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a handle to a selection in a notebook"
}], "GuideText",
 CellID->114026970],

Cell[TextData[{
 Cell[TextData[ButtonBox["SelectionEvaluate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SelectionCreateCell",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SelectionCreateCell"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SelectionAnimate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SelectionAnimate"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->72230713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Global Front End Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->42443905],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrontEndTokenExecute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FrontEndTokenExecute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " execute a menu-like front-end command"
}], "GuideText",
 CellID->873364137],

Cell[TextData[{
 Cell[TextData[ButtonBox["$FrontEnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$FrontEnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$FrontEndSession",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$FrontEndSession"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrontEndEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->159277979],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrontEndExecute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " send an expression to be executed by the front end"
}], "GuideText",
 CellID->686807299]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "GuideTutorial",
 CellID->753340101],

Cell[TextData[{
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"]
}], "GuideTutorial",
 CellID->514076301],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "GuideTutorial",
 CellID->111055008],

Cell[TextData[ButtonBox["Manipulating the Front End from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]], "GuideTutorial",
 CellID->368735],

Cell[TextData[ButtonBox["Executing Notebook Commands Directly in the Front \
End",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"]], \
"GuideTutorial",
 CellID->303370241],

Cell[TextData[ButtonBox["Notebooks as Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebooksAsDocuments"]], "GuideTutorial",
 CellID->46208142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "GuideMoreAbout",
 CellID->155438061],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "GuideMoreAbout",
 CellID->46223355],

Cell[TextData[ButtonBox["Front End Menu Actions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FrontEndTokens"]], "GuideMoreAbout",
 CellID->2089895392],

Cell[TextData[ButtonBox["Stylesheets & Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Converting Between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "GuideMoreAboutSub",\

 CellID->19368]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Low-Level Notebook Programming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 12.9222208}", "context" -> "", 
    "keywords" -> {
     "abut boxes", "active element", "applying functions to notebook content",
       "automatic scrolling", "auto scroll", "button box", "button notebook", 
      "clickable elements", "close document", "close notebook", 
      "close window", "command notebook", "delete selection", 
      "display selection", "document object model", "DOM", 
      "domain object model", "evaluate in place", "evaluation notebook", 
      "exit notebook", "extend selection", "finding options for output", 
      "finding options for streams", "flicker", "focus notebook", "front end",
       "front end event actions", "front end execute", "front end session", 
      "grid box", "\\hbox (TeX)", "highlighted notebook", "highlighting", 
      "highlight selection", "horizontal box", "import notebook", 
      "incremental writing of notebooks", "input focus", "input notebook", 
      "invisible selection", "invisible windows", "keyboard notebook", 
      "list notebooks", "move selection", "notebook apply", "notebook close", 
      "notebook contents", "notebook data", "notebook delete", 
      "notebook find", "notebook get", "notebook handle", "notebook locate", 
      "notebook manipulation", "notebook object", "notebook print", 
      "notebook put", "notebook read", "notebooks", "notebook save", 
      "notebook search", "notebook seek", "notebook selection", 
      "notebook write", "open notebooks", "options for a selection", 
      "options for streams", "options for symbol", "palette buttons", 
      "palette element", "palette notebook", "paper copy", "paste", "pasting",
       "remove selection", "reset medium", "reset page width", "row box", 
      "save notebook", "save to file", "save work", "scripting notebook", 
      "scroll notebook", "scroll to cursor", "searching for tags", 
      "selected cell", "selected notebook", "selected text", "selection", 
      "selection animate", "selection create cell", "selection evaluate", 
      "selection focus", "selection move", "set front notebook", 
      "set front window", "set options", "set selected notebook", 
      "setting options for a selection", "set top notebook", "set top window",
       "show selection", "shut notebook", "store notebook", "target notebook",
       "\\vbox (TeX)", "visible selection", "writing to notebook"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In Mathematica's unified symbolic architecture, every Mathematica \
notebook you see is represented as a symbolic expression, that can be \
manipulated and controlled programmatically using Mathematica's symbolic \
language. Mathematica's low-level notebook programming functions give direct \
incremental access to notebook expressions, allowing you to successively \
perform arbitrary operations on the \"selection\" in any notebook.", 
    "synonyms" -> {}, "title" -> "Low-Level Notebook Programming", "type" -> 
    "Guide", "uri" -> "guide/LowLevelNotebookProgramming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 72, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[694, 28, 662, 18, 70, "GuideAbstract",
 CellID->72150565],
Cell[CellGroupData[{
Cell[1381, 50, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->123778769],
Cell[1456, 53, 403, 13, 70, "GuideText",
 CellID->375265711],
Cell[1862, 68, 870, 23, 70, "InlineGuideFunctionListing",
 CellID->190978241],
Cell[2735, 93, 297, 9, 70, "GuideText",
 CellID->83181588]
}, Open  ]],
Cell[CellGroupData[{
Cell[3069, 107, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->40366285],
Cell[3159, 110, 682, 20, 70, "GuideText",
 CellID->237188989],
Cell[3844, 132, 861, 23, 70, "InlineGuideFunctionListing",
 CellID->16994604]
}, Open  ]],
Cell[CellGroupData[{
Cell[4742, 160, 242, 6, 70, "GuideFunctionsSubsection",
 CellID->517660653],
Cell[4987, 168, 290, 9, 70, "GuideText",
 CellID->469076087],
Cell[5280, 179, 293, 9, 70, "GuideText",
 CellID->15194977],
Cell[5576, 190, 1233, 36, 70, "InlineGuideFunctionListing",
 CellID->577050260]
}, Open  ]],
Cell[CellGroupData[{
Cell[6846, 231, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->3123184],
Cell[6930, 234, 270, 9, 70, "GuideText",
 CellID->29577412],
Cell[7203, 245, 271, 9, 70, "GuideText",
 CellID->364402447],
Cell[7477, 256, 289, 9, 70, "GuideText",
 CellID->306310362],
Cell[7769, 267, 420, 13, 70, "GuideText",
 CellID->24982529],
Cell[8192, 282, 269, 9, 70, "GuideText",
 CellID->322015122],
Cell[8464, 293, 615, 17, 70, "InlineGuideFunctionListing",
 CellID->56046676],
Cell[9082, 312, 284, 9, 70, "GuideText",
 CellID->114026970],
Cell[9369, 323, 659, 17, 70, "InlineGuideFunctionListing",
 CellID->72230713]
}, Open  ]],
Cell[CellGroupData[{
Cell[10065, 345, 261, 6, 70, "GuideFunctionsSubsection",
 CellID->42443905],
Cell[10329, 353, 285, 8, 70, "GuideText",
 CellID->873364137],
Cell[10617, 363, 1181, 30, 70, "InlineGuideFunctionListing",
 CellID->159277979],
Cell[11801, 395, 288, 8, 70, "GuideText",
 CellID->686807299]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12138, 409, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[12203, 412, 436, 12, 70, "GuideTutorial",
 CellID->753340101],
Cell[12642, 426, 420, 12, 70, "GuideTutorial",
 CellID->514076301],
Cell[13065, 440, 194, 4, 70, "GuideTutorial",
 CellID->111055008],
Cell[13262, 446, 197, 4, 70, "GuideTutorial",
 CellID->368735],
Cell[13462, 452, 225, 6, 70, "GuideTutorial",
 CellID->303370241],
Cell[13690, 460, 160, 3, 70, "GuideTutorial",
 CellID->46208142]
}, Open  ]],
Cell[CellGroupData[{
Cell[13887, 468, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[13952, 471, 154, 3, 70, "GuideMoreAbout",
 CellID->155438061],
Cell[14109, 476, 174, 3, 70, "GuideMoreAbout",
 CellID->46223355],
Cell[14286, 481, 154, 3, 70, "GuideMoreAbout",
 CellID->2089895392],
Cell[14443, 486, 155, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[14601, 491, 199, 5, 70, "GuideMoreAboutSub",
 CellID->19368]
}, Open  ]],
Cell[14815, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

