(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9508,        312]
NotebookOptionsPosition[      5463,        209]
NotebookOutlinePosition[      8008,        261]
CellTagsIndexPosition[      7965,        258]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Manipulating Equations", "GuideTitle",
 CellID->12118],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture allows it to represent any equation as a symbolic \
expression that can be manipulated using any of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful collection of symbolic operations."
}], "GuideAbstract",
 CellID->559441580],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general algebraic reduction of equations, inequalities, etc."
}], "GuideText",
 CellID->11622],

Cell["\t", "GuideDelimiter",
 CellID->87293442],

Cell[TextData[{
 Cell[TextData[ButtonBox["Simplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Simplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify each side of an equation"
}], "GuideText",
 CellID->10481],

Cell[TextData[{
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " series expand each side of an equation "
}], "GuideText",
 CellID->30614],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "evaluate each side of an equation numerically"
}], "GuideText",
 CellID->82356956],

Cell["\t", "GuideDelimiter",
 CellID->132794573],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand out logical combinations of equations"
}], "GuideText",
 CellID->14398],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "==", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["u", "TI"], ",", 
     StyleBox["v", "TI"]}], "}"}]}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "==", 
     StyleBox["u", "TI"]}], ",", 
    RowBox[{
     StyleBox["b", "TI"], "==", 
     StyleBox["v", "TI"]}]}], "}"}]], "InlineFormula"]
}], "GuideText",
 CellID->27098],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert equations to matrices"
}], "GuideText",
 CellID->3760],

Cell["\t", "GuideDelimiter",
 CellID->196352276],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ") \[LongDash] substitute equation solutions into any expression"
}], "GuideText",
 CellID->10219480]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->28596],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "GuideTutorial",
 CellID->86075116],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SimplifyingAlgebraicExpressions"]], "GuideTutorial",
 CellID->718500469],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "GuideTutorial",
 CellID->13209656],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "GuideTutorial",
 CellID->445148539],

Cell[TextData[ButtonBox["Solving Equations Involving Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]], "GuideTutorial",
 CellID->30224059]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->10538],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "GuideMoreAbout",
 CellID->350458638],

Cell[TextData[ButtonBox["Polynomial Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAboutSub",
 CellID->7864],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 18.3911108}", "context" -> "", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", 
      "algebraic simplification", "approximate formulas", 
      "approximation of functions", "approximations", "assertions", 
      "assumptions", "asymptotic expansions", "Boolean algebra", 
      "Boolean expansion", "Boolean expressions", "cleaning up expressions", 
      "CNF", "combinatorial explosion", "complex variables", 
      "compress expression", "concise form", "conjunctive normal form", 
      "constraints", "controlled transformations", 
      "cylindrical decomposition", "equations", "evaluation at a point", 
      "expansion", "Groebner basis", "homogeneous forms", 
      "implementing listability", "inequalities", "integer equations", 
      "Laurent series", "linear equations", "linear inequalities", 
      "logical expand", "Maclaurin series", "power series", "quadratic forms",
       "rearrange expression", "reducing inequalities", "replace all", 
      "replacement", "series expansions", "shortest form", "simplest forms", 
      "simplification", "smallest form", "square roots", "squash expression", 
      "substitution", "switching algebra", "Taylor series", 
      "temporary binding", "threading operations over equations", 
      "threading over lists", "transcendental equations", 
      "transcendental inequalities", "transformations", 
      "trigonometric simplification", "variables"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's symbolic architecture allows it to represent any equation \
as a symbolic expression that can be manipulated using any of Mathematica's \
powerful collection of symbolic operations.", "synonyms" -> {}, "title" -> 
    "Manipulating Equations", "type" -> "Guide", "uri" -> 
    "guide/ManipulatingEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->12118],
Cell[682, 28, 334, 9, 70, "GuideAbstract",
 CellID->559441580],
Cell[1019, 39, 276, 8, 70, "GuideText",
 CellID->11622],
Cell[1298, 49, 47, 1, 70, "GuideDelimiter",
 CellID->87293442],
Cell[1348, 52, 253, 8, 70, "GuideText",
 CellID->10481],
Cell[1604, 62, 255, 8, 70, "GuideText",
 CellID->30614],
Cell[1862, 72, 259, 9, 70, "GuideText",
 CellID->82356956],
Cell[2124, 83, 48, 1, 70, "GuideDelimiter",
 CellID->132794573],
Cell[2175, 86, 274, 8, 70, "GuideText",
 CellID->14398],
Cell[2452, 96, 706, 28, 70, "GuideText",
 CellID->27098],
Cell[3161, 126, 266, 8, 70, "GuideText",
 CellID->3760],
Cell[3430, 136, 48, 1, 70, "GuideDelimiter",
 CellID->196352276],
Cell[3481, 139, 365, 10, 70, "GuideText",
 CellID->10219480]
}, Open  ]],
Cell[CellGroupData[{
Cell[3883, 154, 58, 1, 70, "GuideTutorialsSection",
 CellID->28596],
Cell[3944, 157, 151, 3, 70, "GuideTutorial",
 CellID->86075116],
Cell[4098, 162, 186, 4, 70, "GuideTutorial",
 CellID->718500469],
Cell[4287, 168, 172, 3, 70, "GuideTutorial",
 CellID->13209656],
Cell[4462, 173, 198, 4, 70, "GuideTutorial",
 CellID->445148539],
Cell[4663, 179, 197, 4, 70, "GuideTutorial",
 CellID->30224059]
}, Open  ]],
Cell[CellGroupData[{
Cell[4897, 188, 59, 1, 70, "GuideMoreAboutSection",
 CellID->10538],
Cell[4959, 191, 148, 3, 70, "GuideMoreAbout",
 CellID->350458638],
Cell[5110, 196, 155, 3, 70, "GuideMoreAboutSub",
 CellID->7864],
Cell[5268, 201, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[5436, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

