(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19443,        639]
NotebookOptionsPosition[     14774,        506]
NotebookOutlinePosition[     16562,        546]
CellTagsIndexPosition[     16519,        543]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Functions for Exchanging Expressions"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Basic Types \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCFunctionsForExchangingData"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->489668514],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutDouble"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->70467387],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutIntegerArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerArray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutByteArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutByteArray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->94015845]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions with Simple Heads", "GuideFunctionsSubsection",
 CellID->66298991],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "send the head of a function and its argument count"
}], "GuideText",
 CellID->1631649026],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get the head of a function and its argument count"
}], "GuideText",
 CellID->209956873],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLCheckFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLCheckFunction"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLTestHead()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTestHead"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "check the head of a function and its argument count"
}], "GuideText",
 CellID->728940401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbols \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCFunctionsForExchangingSymbols"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->40410122],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUCS2Symbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1481638912],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2Symbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1832307019],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLReleaseUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUCS2Symbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->668570353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Expression Packet Handling \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkExpressionPacketHandling"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->302524971],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLNextPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLNewPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNewPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLEndPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEndPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->96932119]
}, Open  ]],

Cell[CellGroupData[{

Cell["Low-Level Expression Operations", "GuideFunctionsSubsection",
 CellID->124445558],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutNext"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "prepare to put a specified type of expression on a link"
}], "GuideText",
 CellID->689565146],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetNext"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "go to the next part of an expression and return its type"
}], "GuideText",
 CellID->37124161],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetType"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get the type of the current part of an expression"
}], "GuideText",
 CellID->581838474],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutArgCount()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutArgCount"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetArgCount()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetArgCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numbers of arguments for a head"
}], "GuideText",
 CellID->421296841]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expression Storage", "GuideFunctionsSubsection",
 CellID->174160209],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLLoopbackOpen()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLLoopbackOpen"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "open a loopback link for expression storage"
}], "GuideText",
 CellID->247465296],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLTransferExpression()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "move an entire expression from one link to another"
}], "GuideText",
 CellID->241671692],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLTransferToEndOfLoopbackLink()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferToEndOfLoopbackLink"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transfer the entire contents of a loopback link"
}], "GuideText",
 CellID->328359619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Low-Level Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelMathLinkOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->271098952],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutSize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLSeekMark()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSeekMark"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->385857818]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Two\[Hyphen]Way Communication with External \
Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]], "GuideTutorial",\

 CellID->449026297],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->1885805579],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "GuideMoreAboutSub",
 CellID->164162700],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->55584847],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Functions for Exchanging Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 34.5946506}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutFunction() -- send the head of a function and its argument count, \
MLGetFunction() -- get the head of a function and its argument count, \
MLCheckFunction(), MLTestHead() -- check the head of a function and its \
argument count, MLPutNext() -- prepare to put a specified type of expression \
on a link, MLGetNext() -- go to the next part of an expression and return its \
type, MLGetType() -- get the type of the current part of an expression, \
MLPutArgCount(), MLGetArgCount() -- numbers of arguments for a head, \
MLLoopbackOpen() -- open a loopback link for expression storage, \
MLTransferExpression() -- move an entire expression from one link to another, \
MLTransferToEndOfLoopbackLink() -- transfer the entire contents of a loopback \
link", "synonyms" -> {}, "title" -> 
    "MathLink C Functions for Exchanging Expressions", "type" -> "Guide", 
    "uri" -> "guide/MathLinkCFunctionsForExchangingExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 142, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[764, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[845, 37, 234, 5, 70, "GuideFunctionsSubsection",
 CellID->489668514],
Cell[1082, 44, 1090, 30, 70, "InlineGuideFunctionListing",
 CellID->70467387],
Cell[2175, 76, 896, 24, 70, "InlineGuideFunctionListing",
 CellID->94015845]
}, Open  ]],
Cell[CellGroupData[{
Cell[3108, 105, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->66298991],
Cell[3193, 108, 294, 9, 70, "GuideText",
 CellID->1631649026],
Cell[3490, 119, 292, 9, 70, "GuideText",
 CellID->209956873],
Cell[3785, 130, 433, 13, 70, "GuideText",
 CellID->728940401]
}, Open  ]],
Cell[CellGroupData[{
Cell[4255, 148, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->40410122],
Cell[4490, 155, 663, 18, 70, "InlineGuideFunctionListing",
 CellID->1481638912],
Cell[5156, 175, 663, 18, 70, "InlineGuideFunctionListing",
 CellID->1832307019],
Cell[5822, 195, 678, 18, 70, "InlineGuideFunctionListing",
 CellID->668570353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6537, 218, 248, 6, 70, "GuideFunctionsSubsection",
 CellID->302524971],
Cell[6788, 226, 867, 24, 70, "InlineGuideFunctionListing",
 CellID->96932119]
}, Open  ]],
Cell[CellGroupData[{
Cell[7692, 255, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->124445558],
Cell[7782, 258, 290, 9, 70, "GuideText",
 CellID->689565146],
Cell[8075, 269, 290, 9, 70, "GuideText",
 CellID->37124161],
Cell[8368, 280, 284, 9, 70, "GuideText",
 CellID->581838474],
Cell[8655, 291, 415, 13, 70, "GuideText",
 CellID->421296841]
}, Open  ]],
Cell[CellGroupData[{
Cell[9107, 309, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->174160209],
Cell[9184, 312, 288, 9, 70, "GuideText",
 CellID->247465296],
Cell[9475, 323, 307, 9, 70, "GuideText",
 CellID->241671692],
Cell[9785, 334, 325, 10, 70, "GuideText",
 CellID->328359619]
}, Open  ]],
Cell[CellGroupData[{
Cell[10147, 349, 234, 5, 70, "GuideFunctionsSubsection",
 CellID->271098952],
Cell[10384, 356, 1064, 30, 70, "InlineGuideFunctionListing",
 CellID->385857818]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11497, 392, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11562, 395, 217, 6, 70, "GuideTutorial",
 CellID->449026297],
Cell[11782, 403, 211, 5, 70, "GuideTutorial",
 CellID->1885805579],
Cell[11996, 410, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[12334, 421, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[12668, 432, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[13035, 446, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[13100, 449, 309, 9, 70, "GuideMoreAboutSub",
 CellID->164162700],
Cell[13412, 460, 334, 9, 70, "GuideMoreAbout",
 CellID->55584847],
Cell[13749, 471, 536, 16, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[14288, 489, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[14747, 504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

