(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19886,        688]
NotebookOptionsPosition[     13857,        521]
NotebookOutlinePosition[     16362,        571]
CellTagsIndexPosition[     16319,        568]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Functions for Exchanging Integers"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Sending Integers", "GuideFunctionsSubsection",
 CellID->369868082],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit ",
 StyleBox["int", "InlineCode"]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutShortInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutShortInteger"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutInteger16()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit ",
 StyleBox["short", "InlineCode"]
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutLongInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutLongInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["long", "InlineCode"]
}], "GuideText",
 CellID->516153700],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integers"
}], "GuideText",
 CellID->1308785667]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Integers", "GuideFunctionsSubsection",
 CellID->1555179756],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit ",
 StyleBox["int", "InlineCode"]
}], "GuideText",
 CellID->85709048],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetShortInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetShortInteger"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetInteger16()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit ",
 StyleBox["short", "InlineCode"]
}], "GuideText",
 CellID->1697926246],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetLongInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetLongInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["long", "InlineCode"]
}], "GuideText",
 CellID->1283715186],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integers"
}], "GuideText",
 CellID->1780413340],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1300179222]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Lists of Integers", "GuideFunctionsSubsection",
 CellID->532812034],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerList"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutInteger32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 32-bit integers (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1807784080],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger16List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 16-bit integers (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->2112531095],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 64-bit integers"
}], "GuideText",
 CellID->889356255]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Lists of Integers", "GuideFunctionsSubsection",
 CellID->924394665],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetIntegerList"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetInteger32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 32-bit integers (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->694987327],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger16List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger16List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 16-bit short integers (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->488448856],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 64-bit integers"
}], "GuideText",
 CellID->1677423958]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Lists of Integers", "GuideFunctionsSubsection",
 CellID->1404432257],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 32-bit integers (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1581321295],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger16List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger16List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 16-bit integers (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->9389793],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of 64-bit integers"
}], "GuideText",
 CellID->1047944720],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1650325791]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Arrays of Integers", "GuideFunctionsSubsection",
 CellID->126784685],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutIntegerArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1076153366],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit short integer array (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->802347328],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer arrays"
}], "GuideText",
 CellID->1001722183]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Arrays of Integers", "GuideFunctionsSubsection",
 CellID->566422971],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetIntegerArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetIntegerArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1820420848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger16Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit short integer array (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->613673527],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer array"
}], "GuideText",
 CellID->1794495395]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Arrays of Integers", "GuideFunctionsSubsection",
 CellID->75866446],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger32Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->458864403],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger16Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit short integer array (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->520244844],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger64Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer array"
}], "GuideText",
 CellID->1349166171]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->455193277],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->358651136],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "GuideTutorial",
 CellID->641518635],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Functions for Exchanging Integers - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 34.7821554}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutInteger(), MLPutInteger32() -- 32-bit int, MLPutShortInteger(), \
MLPutInteger16() -- 16-bit short, MLPutLongInteger() -- long, \
MLPutInteger64() -- 64-bit integers, MLGetInteger(), MLGetInteger32() -- \
32-bit int, MLGetShortInteger(), MLGetInteger16() -- 16-bit short, \
MLGetLongInteger() -- long, MLGetInteger64() -- 64-bit integers, \
MLPutIntegerList(), MLPutInteger32List() -- list of 32-bit integers (int *), \
MLPutInteger16List() -- list of 16-bit integers (short *), \
MLGetInteger64List() -- list of 64-bit integers, MLGetIntegerList(), \
MLGetInteger32List() -- list of 32-bit integers (int *), MLGetInteger16List() \
-- list of 16-bit short integers (short *), MLGetInteger64List() -- list of \
64-bit integers, MLReleaseInteger32List() -- list of 32-bit integers (int *), \
MLReleaseInteger16List() -- list of 16-bit integers (short *), \
MLReleaseInteger64List() -- list of 64-bit integers, MLPutIntegerArray(), \
MLPutInteger32Array() -- 32-bit integer array (int *), MLPutInteger16Array() \
-- 16-bit short integer array (short *), MLPutInteger64Array() -- 64-bit \
integer arrays, MLGetIntegerArray(), MLGetInteger32Array() -- 32-bit integer \
array (int *), MLGetInteger16Array() -- 16-bit short integer array (short *), \
MLGetInteger64Array() -- 64-bit integer array, MLReleaseInteger32Array() -- \
32-bit integer array (int *), MLReleaseInteger16Array() -- 16-bit short \
integer array (short *), MLReleaseInteger64Array() -- 64-bit integer array", 
    "synonyms" -> {}, "title" -> 
    "MathLink C Functions for Exchanging Integers", "type" -> "Guide", "uri" -> 
    "guide/MathLinkCFunctionsForExchangingIntegers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 139, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[761, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[842, 37, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->369868082],
Cell[917, 40, 418, 13, 70, "GuideText",
 CellID->203374175],
Cell[1338, 55, 431, 13, 70, "GuideText",
 CellID->1463276848],
Cell[1772, 70, 277, 9, 70, "GuideText",
 CellID->516153700],
Cell[2052, 81, 256, 8, 70, "GuideText",
 CellID->1308785667]
}, Open  ]],
Cell[CellGroupData[{
Cell[2345, 94, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->1555179756],
Cell[2423, 97, 417, 13, 70, "GuideText",
 CellID->85709048],
Cell[2843, 112, 431, 13, 70, "GuideText",
 CellID->1697926246],
Cell[3277, 127, 278, 9, 70, "GuideText",
 CellID->1283715186],
Cell[3558, 138, 256, 8, 70, "GuideText",
 CellID->1780413340],
Cell[3817, 148, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1300179222]
}, Open  ]],
Cell[CellGroupData[{
Cell[3913, 154, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->532812034],
Cell[3997, 157, 461, 14, 70, "GuideText",
 CellID->1807784080],
Cell[4461, 173, 316, 10, 70, "GuideText",
 CellID->2112531095],
Cell[4780, 185, 271, 8, 70, "GuideText",
 CellID->889356255]
}, Open  ]],
Cell[CellGroupData[{
Cell[5088, 198, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->924394665],
Cell[5174, 201, 460, 14, 70, "GuideText",
 CellID->694987327],
Cell[5637, 217, 321, 10, 70, "GuideText",
 CellID->488448856],
Cell[5961, 229, 272, 8, 70, "GuideText",
 CellID->1677423958]
}, Open  ]],
Cell[CellGroupData[{
Cell[6270, 242, 95, 1, 70, "GuideFunctionsSubsection",
 CellID->1404432257],
Cell[6368, 245, 322, 10, 70, "GuideText",
 CellID->1581321295],
Cell[6693, 257, 321, 10, 70, "GuideText",
 CellID->9389793],
Cell[7017, 269, 280, 8, 70, "GuideText",
 CellID->1047944720],
Cell[7300, 279, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1650325791]
}, Open  ]],
Cell[CellGroupData[{
Cell[7396, 285, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->126784685],
Cell[7481, 288, 462, 14, 70, "GuideText",
 CellID->1076153366],
Cell[7946, 304, 320, 10, 70, "GuideText",
 CellID->802347328],
Cell[8269, 316, 272, 8, 70, "GuideText",
 CellID->1001722183]
}, Open  ]],
Cell[CellGroupData[{
Cell[8578, 329, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->566422971],
Cell[8665, 332, 462, 14, 70, "GuideText",
 CellID->1820420848],
Cell[9130, 348, 320, 10, 70, "GuideText",
 CellID->613673527],
Cell[9453, 360, 271, 8, 70, "GuideText",
 CellID->1794495395]
}, Open  ]],
Cell[CellGroupData[{
Cell[9761, 373, 94, 1, 70, "GuideFunctionsSubsection",
 CellID->75866446],
Cell[9858, 376, 323, 11, 70, "GuideText",
 CellID->458864403],
Cell[10184, 389, 331, 11, 70, "GuideText",
 CellID->520244844],
Cell[10518, 402, 282, 9, 70, "GuideText",
 CellID->1349166171]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10849, 417, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10914, 420, 375, 11, 70, "GuideTutorial",
 CellID->455193277],
Cell[11292, 433, 210, 5, 70, "GuideTutorial",
 CellID->358651136],
Cell[11505, 440, 420, 12, 70, "GuideTutorial",
 CellID->641518635],
Cell[11928, 454, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[12266, 465, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[12600, 476, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[12967, 490, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[13032, 493, 336, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[13371, 504, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[13830, 519, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

