(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18325,        638]
NotebookOptionsPosition[     12539,        478]
NotebookOutlinePosition[     14998,        527]
CellTagsIndexPosition[     14955,        524]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Functions for Exchanging Reals"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Sending Reals", "GuideFunctionsSubsection",
 CellID->1461705142],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutFloat()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFloat"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutReal32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real numbers of type ",
 StyleBox["float", "InlineCode"]
}], "GuideText",
 CellID->578250709],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutDouble"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutReal64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real numbers of type ",
 StyleBox["double", "InlineCode"]
}], "GuideText",
 CellID->882691455],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal128()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quad-precision floating-point numbers"
}], "GuideText",
 CellID->1296163488]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Reals", "GuideFunctionsSubsection",
 CellID->1581152160],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetFloat()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetFloat"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetReal32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real numbers of type ",
 StyleBox["float", "InlineCode"]
}], "GuideText",
 CellID->545627648],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetReal64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real numbers of type ",
 StyleBox["double", "InlineCode"]
}], "GuideText",
 CellID->608707246],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal128()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quad-precision floating-point numbers"
}], "GuideText",
 CellID->1644023666],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1466075929]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Lists of Reals", "GuideFunctionsSubsection",
 CellID->110773025],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->2041392873],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["double *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1491272039],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal128List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal128List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of quad-precision floating-point numbers"
}], "GuideText",
 CellID->527515336]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Lists of Reals", "GuideFunctionsSubsection",
 CellID->1137757336],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->715314550],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["double *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->678185944],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal128List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal128List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of quad-precision floating-point numbers"
}], "GuideText",
 CellID->1575446179]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Lists of Reals", "GuideFunctionsSubsection",
 CellID->1093153264],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal32List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->50562943],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal64List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of reals (",
 StyleBox["double *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1555342436],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal128List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal128List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of quad-precision floating-point numbers"
}], "GuideText",
 CellID->1469370568],

Cell["\t", "GuideDelimiterSubsection",
 CellID->823765297]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Arrays of Reals", "GuideFunctionsSubsection",
 CellID->196274470],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutRealArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRealArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->307110312],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["double *", "InlineCode"],
 ") "
}], "GuideText",
 CellID->1199810043],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of quad-precision floating-point numbers"
}], "GuideText",
 CellID->335947371]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Arrays of Reals", "GuideFunctionsSubsection",
 CellID->250135498],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutRealArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRealArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->532956434],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["double *", "InlineCode"],
 ") "
}], "GuideText",
 CellID->244494601],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of quad-precision floating-point numbers"
}], "GuideText",
 CellID->1084542296]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Arrays of Reals", "GuideFunctionsSubsection",
 CellID->1401817707],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->61173136],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["double *", "InlineCode"],
 ") "
}], "GuideText",
 CellID->1639713486],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of quad-precision floating-point numbers"
}], "GuideText",
 CellID->6917251]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->455193277],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->358651136],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Functions for Exchanging Reals - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 35.2509174}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutFloat(), MLPutReal32() -- real numbers of type float, \
MLPutDouble(), MLPutReal64() -- real numbers of type double, MLPutReal128() \
-- quad-precision floating-point numbers, MLGetFloat(), MLGetReal32() -- real \
numbers of type float, MLGetDouble(), MLGetReal64() -- real numbers of type \
double, MLGetReal128() -- quad-precision floating-point numbers, \
MLPutReal32List() -- list of reals (float *), MLPutReal64List() -- list of \
reals (double *), MLPutReal128List() -- list of quad-precision floating-point \
numbers, MLGetReal32List() -- list of reals (float *), MLGetReal64List() -- \
list of reals (double *), MLGetReal128List() -- list of quad-precision \
floating-point numbers, MLReleaseReal32List() -- list of reals (float *), \
MLReleaseReal64List() -- list of reals (double *), MLReleaseReal128List() -- \
list of quad-precision floating-point numbers, MLPutRealArray(), \
MLPutReal32Array() -- array of reals (float *), MLPutReal64Array() -- array \
of reals (double *) , MLPutReal128Array() -- array of quad-precision \
floating-point numbers, MLPutRealArray(), MLGetReal32Array() -- array of \
reals (float *), MLGetReal64Array() -- array of reals (double *) , \
MLGetReal128Array() -- array of quad-precision floating-point numbers, \
MLReleaseReal32Array() -- array of reals (float *), MLReleaseReal64Array() -- \
array of reals (double *) , MLReleaseReal128Array() -- array of \
quad-precision floating-point numbers", "synonyms" -> {}, "title" -> 
    "MathLink C Functions for Exchanging Reals", "type" -> "Guide", "uri" -> 
    "guide/MathLinkCFunctionsForExchangingReals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 136, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[758, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[839, 37, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->1461705142],
Cell[912, 40, 429, 14, 70, "GuideText",
 CellID->578250709],
Cell[1344, 56, 432, 14, 70, "GuideText",
 CellID->882691455],
Cell[1779, 72, 274, 8, 70, "GuideText",
 CellID->1296163488]
}, Open  ]],
Cell[CellGroupData[{
Cell[2090, 85, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->1581152160],
Cell[2165, 88, 429, 14, 70, "GuideText",
 CellID->545627648],
Cell[2597, 104, 432, 14, 70, "GuideText",
 CellID->608707246],
Cell[3032, 120, 274, 8, 70, "GuideText",
 CellID->1644023666],
Cell[3309, 130, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1466075929]
}, Open  ]],
Cell[CellGroupData[{
Cell[3405, 136, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->110773025],
Cell[3486, 139, 300, 10, 70, "GuideText",
 CellID->2041392873],
Cell[3789, 151, 301, 10, 70, "GuideText",
 CellID->1491272039],
Cell[4093, 163, 289, 8, 70, "GuideText",
 CellID->527515336]
}, Open  ]],
Cell[CellGroupData[{
Cell[4419, 176, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->1137757336],
Cell[4503, 179, 299, 10, 70, "GuideText",
 CellID->715314550],
Cell[4805, 191, 300, 10, 70, "GuideText",
 CellID->678185944],
Cell[5108, 203, 290, 8, 70, "GuideText",
 CellID->1575446179]
}, Open  ]],
Cell[CellGroupData[{
Cell[5435, 216, 92, 1, 70, "GuideFunctionsSubsection",
 CellID->1093153264],
Cell[5530, 219, 306, 10, 70, "GuideText",
 CellID->50562943],
Cell[5839, 231, 309, 10, 70, "GuideText",
 CellID->1555342436],
Cell[6151, 243, 298, 8, 70, "GuideText",
 CellID->1469370568],
Cell[6452, 253, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->823765297]
}, Open  ]],
Cell[CellGroupData[{
Cell[6547, 259, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->196274470],
Cell[6629, 262, 445, 14, 70, "GuideText",
 CellID->307110312],
Cell[7077, 278, 305, 10, 70, "GuideText",
 CellID->1199810043],
Cell[7385, 290, 292, 8, 70, "GuideText",
 CellID->335947371]
}, Open  ]],
Cell[CellGroupData[{
Cell[7714, 303, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->250135498],
Cell[7798, 306, 445, 14, 70, "GuideText",
 CellID->532956434],
Cell[8246, 322, 304, 10, 70, "GuideText",
 CellID->244494601],
Cell[8553, 334, 293, 8, 70, "GuideText",
 CellID->1084542296]
}, Open  ]],
Cell[CellGroupData[{
Cell[8883, 347, 93, 1, 70, "GuideFunctionsSubsection",
 CellID->1401817707],
Cell[8979, 350, 309, 10, 70, "GuideText",
 CellID->61173136],
Cell[9291, 362, 313, 10, 70, "GuideText",
 CellID->1639713486],
Cell[9607, 374, 298, 8, 70, "GuideText",
 CellID->6917251]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9954, 388, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10019, 391, 375, 11, 70, "GuideTutorial",
 CellID->455193277],
Cell[10397, 404, 210, 5, 70, "GuideTutorial",
 CellID->358651136],
Cell[10610, 411, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[10948, 422, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[11282, 433, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11649, 447, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11714, 450, 336, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[12053, 461, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[12512, 476, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

