(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9859,        346]
NotebookOptionsPosition[      6948,        261]
NotebookOutlinePosition[      8341,        295]
CellTagsIndexPosition[      8298,        292]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Expression Packet Handling"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Sending ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Packets"
}], "GuideFunctionsSubsection",
 CellID->43028166],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "send a packet wrapper"
}], "GuideText",
 CellID->14027441],

Cell[TextData[{
 Cell[TextData[ButtonBox["EvaluatePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EnterTextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EnterTextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EnterExpressionPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EnterExpressionPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->955527475],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLEndPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEndPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "tell ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " that a packet is complete"
}], "GuideText",
 CellID->203374175]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Receiving ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Packets"
}], "GuideFunctionsSubsection",
 CellID->304681625],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLNewPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNewPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "skip to the end of the current packet"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLNextPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "continue to the next packet, and return its type"
}], "GuideText",
 CellID->233134260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["Functions \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->247789082],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->33756154]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Error and Interrupt Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ErrorAndInterruptHandling"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Expression Packet Handling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 42.1417188}", "context" -> "", 
    "keywords" -> {
     "get data from Mathlink", "LinkRead", "LinkWrite", "put data", 
      "reading expression from MathLink", "send data via MathLink", 
      "write data to MathLink"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MLPutFunction() -- send a packet wrapper, MLEndPacket() -- tell MathLink \
that a packet is complete, MLNewPacket() -- skip to the end of the current \
packet, MLNextPacket() -- continue to the next packet, and return its type", 
    "synonyms" -> {}, "title" -> "MathLink Expression Packet Handling", 
    "type" -> "Guide", "uri" -> "guide/MathLinkExpressionPacketHandling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 130, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[752, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[833, 37, 137, 6, 70, "GuideFunctionsSubsection",
 CellID->43028166],
Cell[973, 45, 263, 9, 70, "GuideText",
 CellID->14027441],
Cell[1239, 56, 784, 21, 70, "InlineGuideFunctionListing",
 CellID->955527475],
Cell[2026, 79, 321, 12, 70, "GuideText",
 CellID->203374175]
}, Open  ]],
Cell[CellGroupData[{
Cell[2384, 96, 140, 6, 70, "GuideFunctionsSubsection",
 CellID->304681625],
Cell[2527, 104, 277, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2807, 115, 289, 9, 70, "GuideText",
 CellID->233134260]
}, Open  ]],
Cell[CellGroupData[{
Cell[3133, 129, 402, 11, 70, "GuideFunctionsSubsection",
 CellID->247789082],
Cell[3538, 142, 625, 18, 70, "InlineGuideFunctionListing",
 CellID->33756154]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4212, 166, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4277, 169, 499, 15, 70, "GuideTutorial",
 CellID->806871991],
Cell[4779, 186, 173, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[4955, 191, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[5293, 202, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[5627, 213, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[5994, 227, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6059, 230, 400, 12, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[6462, 244, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[6921, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

