(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10305,        359]
NotebookOptionsPosition[      7168,        271]
NotebookOutlinePosition[      8753,        308]
CellTagsIndexPosition[      8710,        305]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Packets"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "When exchanging expressions with external programs, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel uses the convention of wrapping the expressions inside packets \
which identify what role the expressions have, or how they should be \
processed."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["EvaluatePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "an expression sent purely for evaluation"
}], "GuideText",
 CellID->1265092154],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReturnPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the final result of an ",
 Cell[TextData[ButtonBox["EvaluatePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFunctionSans"],
 " evaluation"
}], "GuideText",
 CellID->168243331],

Cell["\t", "GuideDelimiter",
 CellID->1104561],

Cell[TextData[{
 Cell[TextData[ButtonBox["EnterTextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EnterTextPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a string to be entered like keyboard input"
}], "GuideText",
 CellID->761635555],

Cell[TextData[{
 Cell[TextData[ButtonBox["EnterExpressionPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EnterExpressionPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "an expression to be entered like keyboard input"
}], "GuideText",
 CellID->1190671221],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReturnTextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnTextPacket"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ReturnExpressionPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnExpressionPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "final results returned"
}], "GuideText",
 CellID->1806236765],

Cell["\t", "GuideDelimiter",
 CellID->1384487551],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputNamePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputNamePacket"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["OutputNamePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OutputNamePacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[TextData[ButtonBox["In",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/In"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Out",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Out"]], "InlineFunctionSans"],
 " labels"
}], "GuideText",
 CellID->592475363],

Cell[TextData[{
 Cell[TextData[ButtonBox["TextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TextPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[TextData[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Print"]], "InlineFunctionSans"],
 " and other incidental output"
}], "GuideText",
 CellID->1185914060],

Cell[TextData[{
 Cell[TextData[ButtonBox["MessagePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MessagePacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "name of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message"
}], "GuideText",
 CellID->861878613],

Cell["\t", "GuideDelimiter",
 CellID->1096954412],

Cell[TextData[{
 Cell[TextData[ButtonBox["CallPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CallPacket"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "data for calling functions in an installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program"
}], "GuideText",
 CellID->365692989]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->455193277],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->358651136],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "GuideTutorial",
 CellID->641518635],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Packets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 42.7667348}", "context" -> "", 
    "keywords" -> {
     "call packet", "enter expression packet", "enter text packet", 
      "evaluate packet", "input lines", "input name packet", "message packet",
       "out", "output lines", "output name packet", "passing expression", 
      "previous output", "previous result", "return expression packet", 
      "return packet", "return text packet", "sending expressions", 
      "text packet", "transferring expression", "write"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When exchanging expressions with external programs, the Mathematica \
kernel uses the convention of wrapping the expressions inside packets which \
identify what role the expressions have, or how they should be processed.", 
    "synonyms" -> {}, "title" -> "MathLink Packets", "type" -> "Guide", "uri" -> 
    "guide/MathLinkPackets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 111, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[733, 32, 325, 8, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1061, 42, 282, 9, 70, "GuideText",
 CellID->1265092154],
Cell[1346, 53, 408, 13, 70, "GuideText",
 CellID->168243331],
Cell[1757, 68, 46, 1, 70, "GuideDelimiter",
 CellID->1104561],
Cell[1806, 71, 285, 9, 70, "GuideText",
 CellID->761635555],
Cell[2094, 82, 303, 9, 70, "GuideText",
 CellID->1190671221],
Cell[2400, 93, 423, 13, 70, "GuideText",
 CellID->1806236765],
Cell[2826, 108, 49, 1, 70, "GuideDelimiter",
 CellID->1384487551],
Cell[2878, 111, 618, 20, 70, "GuideText",
 CellID->592475363],
Cell[3499, 133, 376, 12, 70, "GuideText",
 CellID->1185914060],
Cell[3878, 147, 311, 12, 70, "GuideText",
 CellID->861878613],
Cell[4192, 161, 49, 1, 70, "GuideDelimiter",
 CellID->1096954412],
Cell[4244, 164, 337, 12, 70, "GuideText",
 CellID->365692989]
}, Open  ]],
Cell[CellGroupData[{
Cell[4618, 181, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4683, 184, 375, 11, 70, "GuideTutorial",
 CellID->455193277],
Cell[5061, 197, 210, 5, 70, "GuideTutorial",
 CellID->358651136],
Cell[5274, 204, 420, 12, 70, "GuideTutorial",
 CellID->641518635],
Cell[5697, 218, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[6035, 229, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[6369, 240, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[6736, 254, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6801, 257, 325, 9, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[7141, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

