(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17618,        527]
NotebookOptionsPosition[     11422,        384]
NotebookOutlinePosition[     15237,        452]
CellTagsIndexPosition[     15194,        449]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Math & Counting Operations on Lists", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Ordinary mathematical functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are always \"listable\", so that they are immediately applied in parallel \
across lists. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a wide variety of tightly integrated functions for analyzing \
elements in lists of any size and structure."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", "..", "}"}], "+", 
   RowBox[{"{", "..", "}"}]}]], "InlineGuideFunction"],
 ", etc. \[LongDash] automatically operate in parallel on list elements"
}], "GuideText",
 CellID->344079080],

Cell[TextData[{
 Cell[TextData[ButtonBox["Listable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Listable"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " attribute carried by math functions specifying automatic threading over \
lists"
}], "GuideText",
 CellID->41011508],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of elements in a list"
}], "GuideText",
 CellID->38295181],

Cell[TextData[{
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total from adding up elements in a list"
}], "GuideText",
 CellID->331335986],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fold"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->63951736],

Cell["\t", "GuideDelimiter",
 CellID->2047926],

Cell[TextData[{
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count how many elements match a pattern"
}], "GuideText",
 CellID->140611948],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "tally the number of copies of each distinct element"
}], "GuideText",
 CellID->118243389],

Cell[TextData[{
 Cell[TextData[ButtonBox["Max",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Max"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Min",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Min"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ordering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Ordering"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->78455918],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count the number of elements in a sequence of bins"
}], "GuideText",
 CellID->104619785],

Cell["\t", "GuideDelimiterSubsection",
 CellID->585191671],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Analysis \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->376868159],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Median",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Median"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->322216734],

Cell["\t", "GuideDelimiterSubsection",
 CellID->4220636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Vector-Oriented Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OperationsOnVectors"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->54446785],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Projection",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Projection"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OperationsOnVectors"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->895162142],

Cell["\t", "GuideDelimiterSubsection",
 CellID->269717967]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set-Oriented Operations", "GuideFunctionsSubsection",
 CellID->292393416],

Cell[TextData[{
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Intersection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Intersection"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complement"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Subsets",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subsets"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->83064890]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Operations on Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OperationsOnScalarsVectorsAndMatrices"]], "GuideTutorial",
 CellID->324302481],

Cell[TextData[ButtonBox["Manipulating Expressions like Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsLikeLists"]], "GuideTutorial",
 CellID->775048004],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TestingAndSearchingListElements"]], "GuideTutorial",
 CellID->361851888],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->586961102],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "GuideTutorial",\

 CellID->323825349]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Handling Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->286339763],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Math & Counting Operations on Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 19.3286348}", "context" -> "", 
    "keywords" -> {
     "1-norm", "2nd quartile", "2-norm", "50th percentile", 
      "absent from list", "alphabetic", "alphabetizing of lists", 
      "alphabetizing of string", "approximation of functions", "arrange", 
      "ascending order", "automatic threading over lists", "average", "avg", 
      "Be'zier curve", "bilinear interpolation", "bin counts", "binning", 
      "b-spline", "b spline", "canonical order", "category counts", "census", 
      "central value", "collating of strings", "collation", "column sum", 
      "combining lists", "cubic spline", "curve fitting", "decreasing order", 
      "density estimation", "descending order", "difference of sets", 
      "disjointness", "dispersion", "distinct elements in lists", 
      "dot product", "element positions", "equivalence class counting", 
      "Euclidean norm", "expectation", "expected value", 
      "expressions ordering", "extrapolation", 
      "finding maximal element in lists", "frequencies", "Frobenius norm", 
      "gather", "grade", "grade in APL", "highest", "histogram", 
      "increasing order", "induced matrix norm", "infimum", "infinity-norm", 
      "inner product norm", "inner products", "interp", "interpolate data", 
      "interpolate equation", "interpolate formula", "interpolate numbers", 
      "interpolate table", "largest", "length of list", "length of vector", 
      "linear interpolation", "list complement", "lists", "lists ordering", 
      "location", "lowest", "matrices", "matrix multiplication", 
      "matrix multiply", "matrix norm", "matrix vector multiplication", 
      "maximal element", "maximum", "mean", "median", "merging lists", "min", 
      "minimal element", "minimum", "mode", "most frequent value", 
      "multiplication", "multiplicities", "NOPs", "norm", "normalize vector", 
      "number of elements", "number of occurrences", "number of terms", 
      "order in lists", "order statistics", "overlap between lists", "p-norm",
       "powerset", "project vector onto vector", "range counts", "ranking", 
      "remove duplicates", "row sum", "sample variance", "scalar product", 
      "set exponential", "sets", "size of array", "smallest element", 
      "sorting of lists", "spread", "statistical mode", "subtraction of sets",
       "sum of array elements", "sum of list", "tally", "tensors", 
      "threadable", "total of list", "union of sets", "uniq", 
      "unique elements in lists", "VAR", "variance", "vector length", 
      "vector norm", "vector projection", "vectors", 
      "vector space projection"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Ordinary mathematical functions in Mathematica are always \"listable\", \
so that they are immediately applied in parallel across lists. Mathematica \
provides a wide variety of tightly integrated functions for analyzing \
elements in lists of any size and structure.", "synonyms" -> {}, "title" -> 
    "Math & Counting Operations on Lists", "type" -> "Guide", "uri" -> 
    "guide/MathematicalAndCountingOperationsOnLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 77, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[699, 28, 412, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1114, 41, 242, 7, 70, "GuideText",
 CellID->344079080],
Cell[1359, 50, 302, 9, 70, "GuideText",
 CellID->41011508],
Cell[1664, 61, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1715, 64, 252, 9, 70, "GuideText",
 CellID->38295181],
Cell[1970, 75, 262, 9, 70, "GuideText",
 CellID->331335986],
Cell[2235, 86, 895, 23, 70, "InlineGuideFunctionListing",
 CellID->63951736],
Cell[3133, 111, 46, 1, 70, "GuideDelimiter",
 CellID->2047926],
Cell[3182, 114, 262, 9, 70, "GuideText",
 CellID->140611948],
Cell[3447, 125, 419, 12, 70, "GuideText",
 CellID->118243389],
Cell[3869, 139, 1138, 32, 70, "InlineGuideFunctionListing",
 CellID->78455918],
Cell[5010, 173, 426, 12, 70, "GuideText",
 CellID->104619785],
Cell[5439, 187, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->585191671],
Cell[CellGroupData[{
Cell[5522, 192, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->376868159],
Cell[5743, 199, 1368, 38, 70, "InlineGuideFunctionListing",
 CellID->322216734],
Cell[7114, 239, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->4220636]
}, Open  ]],
Cell[CellGroupData[{
Cell[7207, 245, 234, 6, 70, "GuideFunctionsSubsection",
 CellID->54446785],
Cell[7444, 253, 1306, 35, 70, "InlineGuideFunctionListing",
 CellID->895162142],
Cell[8753, 290, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->269717967]
}, Open  ]],
Cell[CellGroupData[{
Cell[8848, 296, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->292393416],
Cell[8930, 299, 815, 23, 70, "InlineGuideFunctionListing",
 CellID->83064890]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9794, 328, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9859, 331, 202, 4, 70, "GuideTutorial",
 CellID->324302481],
Cell[10064, 337, 189, 4, 70, "GuideTutorial",
 CellID->775048004],
Cell[10256, 343, 188, 4, 70, "GuideTutorial",
 CellID->361851888],
Cell[10447, 349, 150, 3, 70, "GuideTutorial",
 CellID->586961102],
Cell[10600, 354, 180, 4, 70, "GuideTutorial",
 CellID->323825349]
}, Open  ]],
Cell[CellGroupData[{
Cell[10817, 363, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10882, 366, 153, 3, 70, "GuideMoreAbout",
 CellID->286339763],
Cell[11038, 371, 159, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[11200, 376, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[11395, 382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

