(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10532,        375]
NotebookOptionsPosition[      7412,        284]
NotebookOutlinePosition[      9034,        322]
CellTagsIndexPosition[      8991,        319]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Mathematical Constants", "GuideTitle",
 CellID->16371],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " incorporates the latest algorithms\[LongDash]some original to Wolfram \
Research\[LongDash]for evaluating mathematical constants to any number of \
digits of precision. For basic constants like ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ", millions of digits can routinely be computed in seconds. "
}], "GuideAbstract",
 CellID->16760],

Cell[TextData[{
 Cell[TextData[ButtonBox["Pi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pi"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Pi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pi"]], "InlineFunctionSans"],
 ") \[LongDash] pi ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "\[TildeEqual]", "3.14"}], TraditionalForm]], 
  "InlineMath"],
 " (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->32255],

Cell[TextData[{
 Cell[TextData[ButtonBox["E",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/E"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/E"]], "InlineFunctionSans"],
 ") \[LongDash] exponential constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"e", "\[TildeEqual]", "2.718"}], TraditionalForm]], "InlineMath"],
 " (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ee\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " \"exponential e\")"
}], "GuideText",
 CellID->29065],

Cell[TextData[{
 Cell[TextData[ButtonBox["Degree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 ") \[LongDash] conversion factor from radians to degrees"
}], "GuideText",
 CellID->726],

Cell[TextData[{
 Cell[TextData[ButtonBox["GoldenRatio",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GoldenRatio"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " golden ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "\[TildeEqual]", "1.618"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->2401],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerGamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Euler's constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "\[TildeEqual]", "0.577"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->3034],

Cell[TextData[{
 Cell[TextData[ButtonBox["StieltjesGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Stieltjes constants ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->12759],

Cell[TextData[{
 Cell[TextData[ButtonBox["Catalan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Catalan"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Catalan's constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[TildeEqual]", "0.916"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->10393],

Cell[TextData[{
 Cell[TextData[ButtonBox["Glaisher",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Glaisher"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Glaisher's constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "\[TildeEqual]", "1.282"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->30548],

Cell[TextData[{
 Cell[TextData[ButtonBox["Khinchin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Khinchin"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Khinchin's constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", "\[TildeEqual]", "2.685"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->27273],

Cell["\t", "GuideDelimiter",
 CellID->18792],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ") \[LongDash] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "=", 
    SqrtBox[
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath"],
 " (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " \"imaginary i\")"
}], "GuideText",
 CellID->16193],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general root of a polynomial"
}], "GuideText",
 CellID->12933],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " evaluate to any precision"
}], "GuideText",
 CellID->17103],

Cell[TextData[{
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of digits"
}], "GuideText",
 CellID->3690],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " continued fraction expansion"
}], "GuideText",
 CellID->28211],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify symbolic expressions involving constants"
}], "GuideText",
 CellID->13694]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->24668],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "GuideTutorial",
 CellID->32627]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->989],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "GuideMoreAbout",
 CellID->15248],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->11149]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Constants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 20.2349080}", "context" -> "", 
    "keywords" -> {
     "Catalan constant", "Degree", "divine proportion", "divine section", 
      "Euler gamma", "Euler-Mascheroni constant", "Euler's constant", 
      "generalization of Euler's constant", "Glaisher-Kinkelin constant", 
      "golden cut", "golden mean", "golden number", "golden proportion", 
      "golden ratio", "golden section", "phi", "radian", 
      "Stieltjes constants", "Stieltjes gamma"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica incorporates the latest algorithms--some original to Wolfram \
Research--for evaluating mathematical constants to any number of digits of \
precision. For basic constants like \\[Pi] and E, millions of digits can \
routinely be computed in seconds. ", "synonyms" -> {}, "title" -> 
    "Mathematical Constants", "type" -> "Guide", "uri" -> 
    "guide/MathematicalConstants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->16371],
Cell[682, 28, 520, 13, 70, "GuideAbstract",
 CellID->16760],
Cell[1205, 43, 543, 19, 70, "GuideText",
 CellID->32255],
Cell[1751, 64, 581, 18, 70, "GuideText",
 CellID->29065],
Cell[2335, 84, 347, 10, 70, "GuideText",
 CellID->726],
Cell[2685, 96, 350, 12, 70, "GuideText",
 CellID->2401],
Cell[3038, 110, 354, 12, 70, "GuideText",
 CellID->3034],
Cell[3395, 124, 346, 11, 70, "GuideText",
 CellID->12759],
Cell[3744, 137, 341, 11, 70, "GuideText",
 CellID->10393],
Cell[4088, 150, 344, 11, 70, "GuideText",
 CellID->30548],
Cell[4435, 163, 344, 11, 70, "GuideText",
 CellID->27273],
Cell[4782, 176, 44, 1, 70, "GuideDelimiter",
 CellID->18792],
Cell[4829, 179, 575, 20, 70, "GuideText",
 CellID->16193],
Cell[5407, 201, 240, 8, 70, "GuideText",
 CellID->12933],
Cell[5650, 211, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[5701, 214, 231, 8, 70, "GuideText",
 CellID->17103],
Cell[5935, 224, 237, 8, 70, "GuideText",
 CellID->3690],
Cell[6175, 234, 266, 8, 70, "GuideText",
 CellID->28211],
Cell[6444, 244, 277, 8, 70, "GuideText",
 CellID->13694]
}, Open  ]],
Cell[CellGroupData[{
Cell[6758, 257, 58, 1, 70, "GuideTutorialsSection",
 CellID->24668],
Cell[6819, 260, 158, 3, 70, "GuideTutorial",
 CellID->32627]
}, Open  ]],
Cell[CellGroupData[{
Cell[7014, 268, 57, 1, 70, "GuideMoreAboutSection",
 CellID->989],
Cell[7074, 271, 142, 3, 70, "GuideMoreAbout",
 CellID->15248],
Cell[7219, 276, 151, 3, 70, "GuideMoreAboutSub",
 CellID->11149]
}, Open  ]],
Cell[7385, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

