(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25685,        829]
NotebookOptionsPosition[     19617,        669]
NotebookOutlinePosition[     22396,        724]
CellTagsIndexPosition[     22353,        721]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Mathematical Typesetting", "GuideTitle",
 CellID->841],

Cell[TextData[{
 "Developed at Wolfram Research over nearly twenty years, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has by far the world's most sophisticated and convenient mathematical \
typesetting technology",
 ". ",
 "Generalizing the concept of a computer language to allow 2D input, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows both interactive and programmatic entry of arbitrarily complex \
typeset expressions, with publication-quality layout continuously maintained \
in real time."
}], "GuideAbstract",
 CellID->25079748],

Cell[TextData[{
 Cell[TextData[ButtonBox["StandardForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StandardForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " unambiguous format (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["N", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->13452],

Cell[TextData[{
 Cell[TextData[ButtonBox["TraditionalForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TraditionalForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " traditional textbook math notation (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["T", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->700],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " linear input form (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["I", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->31542165],

Cell["\t", "GuideDelimiter",
 CellID->5093],

Cell[TextData[{
 StyleBox[ButtonBox["Palettes",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Basic Input Palette", "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bring up a palette of common input notations"
}], "GuideText",
 CellID->158052113],

Cell[TextData[{
 StyleBox[ButtonBox["Palettes",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Special Characters Palette", "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " access all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " special characters \[RightGuillemet]"
}], "GuideText",
 CellID->212780524],

Cell["\t", "GuideDelimiterSubsection",
 CellID->23619563],

Cell[CellGroupData[{

Cell["Keyboard Input", "GuideFunctionsSubsection",
 CellID->268942295],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox["\[Placeholder]", "\[Placeholder]"]], "InlineFormula"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 StyleBox[" ", "FunctionAnnotation"],
 StyleBox["or", "FunctionAnnotation"],
 StyleBox[" ", "FunctionAnnotation"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  SubscriptBox["\[Placeholder]", "\[Placeholder]"]], "InlineFormula"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  FractionBox["\[Placeholder]", "\[Placeholder]"]], "InlineFormula"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  SqrtBox["\[Placeholder]"]], "InlineFormula"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "..."
}], "InlineGuideFunctionListing",
 CellID->127854290],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " move out of a script position"
}], "GuideText",
 CellID->204661780],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["(", "KeyEvent"],
 ", ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[")", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " start, end an inline math cell in text, or text in math"
}], "GuideText",
 CellID->41495494]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SpecialCharacters"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->337782942],

Cell[TextData[{
 "\[Pi] (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\[ImaginaryI] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SqrtBox[
     RowBox[{"-", "1"}]], ")"}], TraditionalForm]], "InlineMath",
  FontWeight->"Plain"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\[Infinity] (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\[Integral] (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\[DifferentialD] ",
 StyleBox["(differential d)", "GuideText",
  FontWeight->"Plain"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "\[Alpha] (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]a\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "..."
}], "InlineGuideFunctionListing",
 CellID->392798838],

Cell["\t", "GuideDelimiterSubsection",
 CellID->174893116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbolic Notational Forms \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SymbolicNotationalForms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->773362093],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subscript",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subscript"]], "InlineFunctionSans"],
 "(",
 Cell[BoxData[
  SubscriptBox["\[Placeholder]", "\[Placeholder]"]], "InlineFormula"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OverBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OverBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "(",
 Cell[BoxData[
  OverscriptBox["\[Placeholder]", "_"]], "InlineFormula"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CirclePlus",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CirclePlus"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "(\[CirclePlus])",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LeftRightArrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeftRightArrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "(\[LeftRightArrow])",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolicNotationalForms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->74498879]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Table & Layout Constructs \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LayoutAndTables"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->38914340],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Framed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Framed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Labeled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Labeled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LayoutAndTables"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->173824868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Number Formatting \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DisplayOfNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->450400646],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PaddedForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PaddedForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DisplayOfNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->843976579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["General Styling \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NotebookFormattingAndStyling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->184584888],

Cell[TextData[{
 Cell[TextData[ButtonBox["Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Text"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "text within math"
}], "GuideText",
 CellID->93563038],

Cell[TextData[{
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bold",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Bold"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Italic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Italic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Large",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Large"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Small",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Small"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->821123078],

Cell["\t", "GuideDelimiter",
 CellID->229387131],

Cell[TextData[{
 Cell[TextData[ButtonBox["HoldForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display expressions without evaluating them"
}], "GuideText",
 CellID->93651938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Options & Tweaking \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathTypesettingOptionsAndTweaking"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->457942548],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScriptSizeMultipliers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LineIndent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LineIndent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Invisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Invisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->477295771]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->11798],

Cell[TextData[ButtonBox["Basic Editing Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BasicEditingTechniquesOverview"]], "GuideTutorial",
 CellID->507152383],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "GuideTutorial",
 CellID->484315875],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"GuideTutorial",
 CellID->191546471],

Cell[TextData[ButtonBox["Entering Two-Dimensional Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringTwoDimensionalInput"]], "GuideTutorial",\

 CellID->86189687],

Cell[TextData[ButtonBox["Reducing Expressions to Their Standard Form",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ReducingExpressionsToTheirStandardForm"]], "GuideTutorial",\

 CellID->913241237],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "GuideTutorial",
 CellID->465581344],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "GuideTutorial",
 CellID->735480129],

Cell[TextData[ButtonBox["Notebooks as Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebooksAsDocuments"]], "GuideTutorial",
 CellID->46208142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12274],

Cell[TextData[ButtonBox["Importing & Exporting Typeset Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentFormats"]], "GuideMoreAboutSub",
 CellID->44958409],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "GuideMoreAboutSub",
 CellID->6862],

Cell[TextData[ButtonBox["Notation Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Notation/guide/NotationPackage"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "GuideMoreAbout",
 CellID->184873245]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Typesetting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 24.2818866}", "context" -> "", 
    "keywords" -> {
     "1D format", "2D layout", "alignment of decimal points", 
      "alignment of numbers in columns", "alignment of numbers in tables", 
      "ascii input syntax", "classical notation", "display style", 
      "font size", "format of matrices", "formatting of arrays", 
      "formatting of tensors", "formulae in 3D graphics", 
      "formulae in graphics", "formulae in notebooks", "formula typesetting", 
      "input form", "invisible tags", "left right arrow", "linear formatting",
       "linear input", "line indent", "mathematical notation", 
      "mathematical typesetting", "matrix form", "number form", 
      "number formatting", "output formatting", "over bar", "padded form", 
      "padded formatting", "padded numeric formatting", "publication format", 
      "\\scriptscriptstyle (TeX)", "script size multipliers", 
      "\\scriptstyle (TeX)", "standard form", "standard representation", 
      "styles", "sub in HTML", "subscript index", "subscripts", 
      "tabular layout", "TeX", "LaTeX", "MathType", "textbook notation", 
      "text color", "text in 3D graphics", "text in graphics", 
      "text in notebooks", "textual form in 3D graphics", 
      "textual form in graphics", "textual form in notebooks", 
      "traditional form", "traditional notation", "two-dimensional format", 
      "two-dimensional input", "two-dimensional output", 
      "unicode input syntax"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Developed at Wolfram Research over nearly twenty years, Mathematica has \
by far the world's most sophisticated and convenient mathematical typesetting \
technology. Generalizing the concept of a computer language to allow 2D \
input, Mathematica allows both interactive and programmatic entry of \
arbitrarily complex typeset expressions, with publication-quality layout \
continuously maintained in real time.", "synonyms" -> {}, "title" -> 
    "Mathematical Typesetting", "type" -> "Guide", "uri" -> 
    "guide/MathematicalTypesetting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->841],
Cell[682, 28, 562, 14, 70, "GuideAbstract",
 CellID->25079748],
Cell[1247, 44, 474, 17, 70, "GuideText",
 CellID->13452],
Cell[1724, 63, 439, 14, 70, "GuideText",
 CellID->700],
Cell[2166, 79, 415, 14, 70, "GuideText",
 CellID->31542165],
Cell[2584, 95, 43, 1, 70, "GuideDelimiter",
 CellID->5093],
Cell[2630, 98, 364, 10, 70, "GuideText",
 CellID->158052113],
Cell[2997, 110, 429, 13, 70, "GuideText",
 CellID->212780524],
Cell[3429, 125, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->23619563],
Cell[CellGroupData[{
Cell[3511, 130, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->268942295],
Cell[3584, 133, 1325, 49, 70, "InlineGuideFunctionListing",
 CellID->127854290],
Cell[4912, 184, 233, 8, 70, "GuideText",
 CellID->204661780],
Cell[5148, 194, 357, 12, 70, "GuideText",
 CellID->41495494]
}, Open  ]],
Cell[CellGroupData[{
Cell[5542, 211, 205, 5, 70, "GuideFunctionsSubsection",
 CellID->337782942],
Cell[5750, 218, 1553, 61, 70, "InlineGuideFunctionListing",
 CellID->392798838],
Cell[7306, 281, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->174893116]
}, Open  ]],
Cell[CellGroupData[{
Cell[7401, 287, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->773362093],
Cell[7642, 295, 1638, 48, 70, "InlineGuideFunctionListing",
 CellID->74498879]
}, Open  ]],
Cell[CellGroupData[{
Cell[9317, 348, 229, 6, 70, "GuideFunctionsSubsection",
 CellID->38914340],
Cell[9549, 356, 2492, 65, 70, "InlineGuideFunctionListing",
 CellID->173824868]
}, Open  ]],
Cell[CellGroupData[{
Cell[12078, 426, 221, 5, 70, "GuideFunctionsSubsection",
 CellID->450400646],
Cell[12302, 433, 617, 17, 70, "InlineGuideFunctionListing",
 CellID->843976579]
}, Open  ]],
Cell[CellGroupData[{
Cell[12956, 455, 231, 5, 70, "GuideFunctionsSubsection",
 CellID->184584888],
Cell[13190, 462, 236, 9, 70, "GuideText",
 CellID->93563038],
Cell[13429, 473, 2141, 57, 70, "InlineGuideFunctionListing",
 CellID->821123078],
Cell[15573, 532, 48, 1, 70, "GuideDelimiter",
 CellID->229387131],
Cell[15624, 535, 271, 9, 70, "GuideText",
 CellID->93651938]
}, Open  ]],
Cell[CellGroupData[{
Cell[15932, 549, 239, 5, 70, "GuideFunctionsSubsection",
 CellID->457942548],
Cell[16174, 556, 1014, 27, 70, "InlineGuideFunctionListing",
 CellID->477295771]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17237, 589, 58, 1, 70, "GuideTutorialsSection",
 CellID->11798],
Cell[17298, 592, 176, 4, 70, "GuideTutorial",
 CellID->507152383],
Cell[17477, 598, 165, 3, 70, "GuideTutorial",
 CellID->484315875],
Cell[17645, 603, 201, 5, 70, "GuideTutorial",
 CellID->191546471],
Cell[17849, 610, 177, 4, 70, "GuideTutorial",
 CellID->86189687],
Cell[18029, 616, 205, 5, 70, "GuideTutorial",
 CellID->913241237],
Cell[18237, 623, 196, 4, 70, "GuideTutorial",
 CellID->465581344],
Cell[18436, 629, 199, 4, 70, "GuideTutorial",
 CellID->735480129],
Cell[18638, 635, 160, 3, 70, "GuideTutorial",
 CellID->46208142]
}, Open  ]],
Cell[CellGroupData[{
Cell[18835, 643, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12274],
Cell[18897, 646, 171, 3, 70, "GuideMoreAboutSub",
 CellID->44958409],
Cell[19071, 651, 161, 3, 70, "GuideMoreAboutSub",
 CellID->6862],
Cell[19235, 656, 161, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[19399, 661, 176, 3, 70, "GuideMoreAbout",
 CellID->184873245]
}, Open  ]],
Cell[19590, 667, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

