(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32966,        993]
NotebookOptionsPosition[     23443,        766]
NotebookOutlinePosition[     28884,        860]
CellTagsIndexPosition[     28841,        857]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Matrices and Linear Algebra", "GuideTitle",
 CellID->32629],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically handles both numeric and symbolic matrices, seamlessly \
switching among large numbers of highly-optimized algorithms",
 ". ",
 "Using many original methods, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle numerical matrices of any precision, automatically invoking \
machine-optimized code when appropriate. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles both dense and sparse matrices, and can routinely operate on \
matrices with millions of entries."
}], "GuideAbstract",
 CellID->186106352],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Operations on Vectors \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OperationsOnVectors"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->27085],

Cell[TextData[{
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OperationsOnVectors"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " automatically operate element-wise: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "+", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["c", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}], "\[LongRightArrow]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["b", "TI"]}], ",", 
      RowBox[{
       StyleBox["c", "TI"], "+", 
       StyleBox["d", "TI"]}]}], "}"}]}]}]], "InlineFormula"]
}], "GuideText",
 CellID->29400],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " scalar dot product"
}], "GuideText",
 CellID->23024],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cross",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cross"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Projection",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Projection"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Orthogonalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Orthogonalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OperationsOnVectors"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14193],

Cell["\t", "GuideDelimiterSubsection",
 CellID->23105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Constructing Matrices \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConstructingMatrices"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->9412],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a matrix from an expression"
}], "GuideText",
 CellID->15765],

Cell[TextData[{
 Cell[TextData[ButtonBox["IdentityMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiagonalMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HilbertMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HilbertMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConstructingMatrices"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Parts of Matrices \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PartsOfMatrices"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->15407],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a part or submatrix: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"i", ",", "j"}], "]"}], "]"}], TraditionalForm]], "InlineMath"],
 "; resettable with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "x"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->10677],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dimensions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dimensions"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Diagonal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Diagonal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PartsOfMatrices"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13784],

Cell["\t", "GuideDelimiterSubsection",
 CellID->704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Matrix Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MatrixOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14790],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Inverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inverse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Det",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Det"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tr"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Eigenvalues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigenvalues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MatrixOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Linear Systems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LinearSystems"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->10891],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NullSpace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NullSpace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatrixRank",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixRank"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RowReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RowReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Minors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minors"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LinearSystems"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Minimization Problems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MatrixBasedMinimization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18085],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PseudoInverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PseudoInverse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MatrixBasedMinimization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->27734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Matrix Decompositions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MatrixDecompositions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->25190],

Cell[TextData[{
 Cell[TextData[ButtonBox["SingularValueDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueDecomposition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QRDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/QRDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LUDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LUDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CholeskyDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SchurDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MatrixDecompositions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->20542]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Tests", "GuideFunctionsSubsection",
 CellID->484641461],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HermitianMatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HermitianMatrixQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PositiveDefiniteMatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->325319065],

Cell["\t", "GuideDelimiterSubsection",
 CellID->17998]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying Matrices", "GuideFunctionsSubsection",
 CellID->22086],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a matrix in 2D form"
}], "GuideText",
 CellID->32018],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatrixPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " visualize a matrix using colors for elements"
}], "GuideText",
 CellID->15621],

Cell["\t", "GuideDelimiterSubsection",
 CellID->30424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Sparse Arrays \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SparseArrays"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22597],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a sparse matrix from positions and values"
}], "GuideText",
 CellID->21376],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayRules"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Normal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Normal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SparseArrays"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24254],

Cell["\t", "GuideDelimiterSubsection",
 CellID->29669]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Formats", "GuideFunctionsSubsection",
 CellID->18108],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MTX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HarwellBoeing\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->12927]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->12493],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->50763171],

Cell[TextData[ButtonBox["Vector Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorOperations"]], "GuideTutorial",
 CellID->193754727],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingMatrices"]], "GuideTutorial",
 CellID->133685174],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "GuideTutorial",
 CellID->329583849],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "GuideTutorial",
 CellID->514358545],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "GuideTutorial",
 CellID->109332592],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "GuideTutorial",
 CellID->58760755],

Cell[TextData[ButtonBox["Sparse Arrays: Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-LinearAlgebra"]], "GuideTutorial",
 CellID->123733919],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->115795587]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->9102],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "GuideMoreAbout",
 CellID->2438],

Cell[TextData[ButtonBox["Geometric Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "GuideMoreAboutSub",
 CellID->10819],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "GuideMoreAboutSub",
 CellID->14318],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->309824722],

Cell[TextData[{
 ButtonBox["Demonstrations related to Matrices and Linear Algebra",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22linear+algebra%22+content%3AArrayRules+OR+CholeskyDecomposition+OR+\
CoefficientArrays+OR+Cross+OR+Det+OR+Diagonal+OR+DiagonalMatrix+OR+Dimensions+\
OR+Dot+OR+Eigenvalues+OR+HermitianMatrixQ+OR+HilbertMatrix+OR+IdentityMatrix+\
OR+Inverse+OR+LeastSquares+OR+LinearProgramming+OR+LinearSolve+OR+\
LUDecomposition+OR+MatrixExp+OR+MatrixForm+OR+MatrixPlot+OR+MatrixQ+OR+\
MatrixRank+OR+Minors+OR+Norm+OR+Normalize+OR+NullSpace+OR+Orthogonalize+OR+\
Part+OR+PositiveDefiniteMatrixQ+OR+Projection+OR+PseudoInverse+OR+\
QRDecomposition+OR+RotationMatrix+OR+RowReduce+OR+SchurDecomposition+OR+\
SingularValueDecomposition+OR+SparseArray+OR+Table+OR+Total+OR+Tr+OR+\
Transpose"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->78822353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrices and Linear Algebra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 43.5323794}", "context" -> "", 
    "keywords" -> {
     "1-norm", "2-norm", "adjoint", "Arnoldi methods", "ARPACK", 
      "array shape", "array size", "ArrayRules", "arrays", 
      "band-diagonal matrices", "basis dimension", "block matrices", 
      "characteristic polynomials for matrices", "Cholesky decomposition", 
      "coefficient arrays", "cofactors", "collapse", "column rank", "columns",
       "column sum", "combinations", "condition number of matrices", 
      "contraction", "Cramer's rule", "cross product", "determinant", 
      "determinant of matrix", "Diagonal", "diagonal of matrix", 
      "diagonalization", "diagonalize", "DiagonalMatrix", 
      "direct solver methods", "division of matrices", "dot product", 
      "echelon form of matrices", "Euclidean norm", 
      "exponentials of matrices", "format of matrices", 
      "formatting of arrays", "formatting of tensors", "Frobenius norm", 
      "Gaussian elimination", "Gauss-Jordan elimination", 
      "generalized eigenvalues", "generalized inverse of matrices", 
      "generalized singular value decomposition", "Givens rotations", 
      "Gram-Schmidt", "hashing", "Hermitian matrix", "Hodge star", 
      "homogeneous forms", "Householder reflections", "identity", 
      "identity array", "IdentityMatrix", "indices", "induced matrix norm", 
      "infinity-norm", "inner product norm", "inner products", 
      "integer programming", "interior point methods", 
      "invariant subspace problem", "inverse of a matrix", 
      "inversion of matrices", "invert", "Jordan decomposition", 
      "Karmarkar algorithm", "kernel of matrices", "Kross", "Krylov methods", 
      "ladder form", "least-squares", "LeastSquares", "length of vector", 
      "linear constraints", "linear equations", "linear objective function", 
      "linear optimization", "linear programming", "LINPACK", 
      "list as matrix", "lists", "LP", "matrices", "matrix diagonal", 
      "matrix dimensions", "matrix equations", "matrix exp", 
      "matrix exponential", "matrix form", "matrix multiplication", 
      "matrix multiply", "matrix norm", "matrix pencils", "matrix plot", 
      "matrix rank", "matrix transpose", "matrix vector multiplication", 
      "metric", "minors of matrices", "modified Gram-Schmidt", 
      "Moore-Penrose inverse", "multifrontal methods", "multiple parts", 
      "multiplication", "norm", "normalize vector", "null space", 
      "null spaces of matrices", "numerical matrices", 
      "orthogonal decomposition", "orthogonalization", "orthonormal basis", 
      "orthonormal matrix", "permutation of indices", "perp", 
      "perpendicular vector", "p-norm", "position-value pairs", 
      "positive definite matrix", "project vector onto vector", 
      "pseudo inverse", "pseudo-inverse", "Putzer's method", 
      "QRDecomposition", "quadratic forms", "rank of matrices", 
      "redundant linear equations", "removing elements from lists", 
      "repeated solution of linear systems", "rotation matrix", 
      "row elimination", "row rank", "RowReduce", "row reduction of matrices",
       "row sum", "rows", "scalar product", "Schur decomposition", 
      "segments of lists", "semi-inverse", "sequence of elements", 
      "similarity transformation", "simplex algorithm", 
      "singular eigenvalue problem", "singular value decomposition", 
      "solution of linear systems", "sparse array", "sparse matrices", 
      "sparse matrix", "sparse representation", "sparse vector", 
      "special matrices", "specify elements in sparse array", 
      "spur of matrix", "stride", "structured matrix", "submatrices", 
      "sum of array elements", "sum of list", "SVD", "tables", 
      "tabulation of values", "tensors", "testing for matrices", 
      "total of list", "trace of matrix", "transpose of matrices", 
      "transposition of lists", "triangular matrices", "UMFPACK", 
      "unit array", "unit diagonal", "unit matrix", "unitary matrix", 
      "vector length", "vector norm", "vector product", "vector projection", 
      "vectors", "vector space projection", "wedge"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica automatically handles both numeric and symbolic matrices, \
seamlessly switching among large numbers of highly-optimized algorithms. \
Using many original methods, Mathematica can handle numerical matrices of any \
precision, automatically invoking machine-optimized code when appropriate. \
Mathematica handles both dense and sparse matrices, and can routinely operate \
on matrices with millions of entries.", "synonyms" -> {}, "title" -> 
    "Matrices and Linear Algebra", "type" -> "Guide", "uri" -> 
    "guide/MatricesAndLinearAlgebra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->32629],
Cell[687, 28, 611, 16, 70, "GuideAbstract",
 CellID->186106352],
Cell[CellGroupData[{
Cell[1323, 48, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->27085],
Cell[1550, 55, 1106, 39, 70, "GuideText",
 CellID->29400],
Cell[2659, 96, 349, 13, 70, "GuideText",
 CellID->23024],
Cell[3011, 111, 1871, 50, 70, "InlineGuideFunctionListing",
 CellID->14193],
Cell[4885, 163, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->23105]
}, Open  ]],
Cell[CellGroupData[{
Cell[4976, 169, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->9412],
Cell[5203, 176, 256, 9, 70, "GuideText",
 CellID->15765],
Cell[5462, 187, 1215, 32, 70, "InlineGuideFunctionListing",
 CellID->5767]
}, Open  ]],
Cell[CellGroupData[{
Cell[6714, 224, 216, 5, 70, "GuideFunctionsSubsection",
 CellID->15407],
Cell[6933, 231, 574, 21, 70, "GuideText",
 CellID->10677],
Cell[7510, 254, 1361, 38, 70, "InlineGuideFunctionListing",
 CellID->13784],
Cell[8874, 294, 52, 1, 70, "GuideDelimiterSubsection",
 CellID->704]
}, Open  ]],
Cell[CellGroupData[{
Cell[8963, 300, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->14790],
Cell[9183, 307, 1722, 52, 70, "InlineGuideFunctionListing",
 CellID->9834]
}, Open  ]],
Cell[CellGroupData[{
Cell[10942, 364, 211, 5, 70, "GuideFunctionsSubsection",
 CellID->10891],
Cell[11156, 371, 1234, 35, 70, "InlineGuideFunctionListing",
 CellID->621]
}, Open  ]],
Cell[CellGroupData[{
Cell[12427, 411, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->18085],
Cell[12658, 418, 1201, 32, 70, "InlineGuideFunctionListing",
 CellID->27734]
}, Open  ]],
Cell[CellGroupData[{
Cell[13896, 455, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->25190],
Cell[14124, 462, 1346, 36, 70, "InlineGuideFunctionListing",
 CellID->20542]
}, Open  ]],
Cell[CellGroupData[{
Cell[15507, 503, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->484641461],
Cell[15578, 506, 648, 17, 70, "InlineGuideFunctionListing",
 CellID->325319065],
Cell[16229, 525, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->17998]
}, Open  ]],
Cell[CellGroupData[{
Cell[16320, 531, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->22086],
Cell[16394, 534, 256, 9, 70, "GuideText",
 CellID->32018],
Cell[16653, 545, 413, 11, 70, "GuideText",
 CellID->15621],
Cell[17069, 558, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->30424]
}, Open  ]],
Cell[CellGroupData[{
Cell[17160, 564, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->22597],
Cell[17372, 571, 282, 9, 70, "GuideText",
 CellID->21376],
Cell[17657, 582, 827, 23, 70, "InlineGuideFunctionListing",
 CellID->24254],
Cell[18487, 607, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->29669]
}, Open  ]],
Cell[CellGroupData[{
Cell[18578, 613, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->18108],
Cell[18645, 616, 1169, 33, 70, "InlineGuideFunctionListing",
 CellID->12927]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19863, 655, 58, 1, 70, "GuideTutorialsSection",
 CellID->12493],
Cell[19924, 658, 156, 3, 70, "GuideTutorial",
 CellID->50763171],
Cell[20083, 663, 152, 3, 70, "GuideTutorial",
 CellID->193754727],
Cell[20238, 668, 160, 3, 70, "GuideTutorial",
 CellID->133685174],
Cell[20401, 673, 163, 3, 70, "GuideTutorial",
 CellID->329583849],
Cell[20567, 678, 161, 3, 70, "GuideTutorial",
 CellID->514358545],
Cell[20731, 683, 173, 3, 70, "GuideTutorial",
 CellID->109332592],
Cell[20907, 688, 168, 3, 70, "GuideTutorial",
 CellID->58760755],
Cell[21078, 693, 174, 3, 70, "GuideTutorial",
 CellID->123733919],
Cell[21255, 698, 177, 4, 70, "GuideTutorial",
 CellID->115795587]
}, Open  ]],
Cell[CellGroupData[{
Cell[21469, 707, 58, 1, 70, "GuideMoreAboutSection",
 CellID->9102],
Cell[21530, 710, 126, 3, 70, "GuideMoreAbout",
 CellID->2438],
Cell[21659, 715, 160, 3, 70, "GuideMoreAboutSub",
 CellID->10819],
Cell[21822, 720, 147, 3, 70, "GuideMoreAboutSub",
 CellID->14318],
Cell[21972, 725, 202, 4, 70, "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],
Cell[CellGroupData[{
Cell[22211, 734, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->309824722],
Cell[22283, 737, 1118, 24, 70, "GuideRelatedLinks",
 CellID->78822353]
}, Open  ]],
Cell[23416, 764, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

