(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13731,        451]
NotebookOptionsPosition[      8484,        320]
NotebookOutlinePosition[     11655,        380]
CellTagsIndexPosition[     11612,        377]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Matrix Operations", "GuideTitle",
 CellID->20415],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s matrix operations handle both numeric and symbolic matrices,  \
automatically accessing large numbers of highly efficient algorithms. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses state-of-the-art algorithms to work with both dense and sparse \
matrices, and incorporates a number of powerful original algorithms, \
especially for high-precision and symbolic matrices."
}], "GuideAbstract",
 CellID->656],

Cell[TextData[{
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "all automatically work element-wise"
}], "GuideText",
 CellID->11959],

Cell["\t", "GuideDelimiter",
 CellID->16251],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ") \[LongDash] products of matrices, automatically handling row and column \
vectors"
}], "GuideText",
 CellID->18738],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "matrix inverse (use ",
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 " for linear systems)"
}], "GuideText",
 CellID->13370],

Cell["\t", "GuideDelimiter",
 CellID->26124],

Cell[TextData[{
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transpose (",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Transpose]"}], TraditionalForm]], "InlineMath"],
 ", entered with ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]tr\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->5507],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConjugateTranspose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " conjugate transpose (",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[ConjugateTranspose]"}], TraditionalForm]], "InlineMath"],
 ", entered with ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ct\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->8007],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tr"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "trace"
}], "GuideText",
 CellID->17584],

Cell[TextData[{
 Cell[TextData[ButtonBox["Det",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Det"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "determinant"
}], "GuideText",
 CellID->10951],

Cell[TextData[{
 Cell[TextData[ButtonBox["KroneckerProduct",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "matrix direct product (outer product)"
}], "GuideText",
 CellID->453515050],

Cell["\t", "GuideDelimiter",
 CellID->14489],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixPower",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixPower"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "powers of numeric or symbolic matrices"
}], "GuideText",
 CellID->24958],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "matrix exponential"
}], "GuideText",
 CellID->15441],

Cell["\t", "GuideDelimiter",
 CellID->1790],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eigenvalues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigenvalues"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Eigenvectors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigenvectors"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "exact or approximate eigenvalues and eigenvectors"
}], "GuideText",
 CellID->17013],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eigensystem",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigensystem"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eigenvalues and eigenvectors together"
}], "GuideText",
 CellID->30412],

Cell[TextData[{
 Cell[TextData[ButtonBox["CharacteristicPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CharacteristicPolynomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic characteristic polynomial"
}], "GuideText",
 CellID->14855]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->21060],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->144885689],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "GuideTutorial",
 CellID->15108586],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "GuideTutorial",
 CellID->287220151],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "GuideTutorial",
 CellID->860777521]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->25402],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "GuideMoreAbout",
 CellID->32676],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->13543],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "GuideMoreAbout",
 CellID->7373],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "GuideMoreAboutSub",
 CellID->27651],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1912971130],

Cell[TextData[{
 ButtonBox["Demonstrations related to Matrix Operations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22linear+algebra%22+content%3ACharacteristicPolynomial+OR+ConjugateTranspose+\
OR+Det+OR+Dot+OR+Eigensystem+OR+Eigenvalues+OR+Eigenvectors+OR+Inverse+OR+\
KroneckerProduct+OR+LinearSolve+OR+MatrixExp+OR+MatrixPower+OR+Tr+OR+\
Transpose"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->679801933]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 45.6105576}", "context" -> "", 
    "keywords" -> {
     "Arnoldi methods", "ARPACK", "Cayley-Hamilton", 
      "characteristic polynomial", "characteristic polynomials for matrices", 
      "characteristic roots", "collapse", "conjugate transpose", 
      "contraction", "Cramer's rule", "determinant", "determinant of matrix", 
      "diagonal", "diagonalization", "diagonalization of matrices", 
      "diagonalize", "diagonal of matrix", "direct solver methods", 
      "division of matrices", "dot product", "eigen decomposition", 
      "eigensystem", "eigenvectors", "EISPACK", "exponentials of matrices", 
      "Frobenius norm", "Gaussian elimination", 
      "generalized eigen decomposition", "generalized eigensystem", 
      "generalized eigenvalues", "generalized eigenvectors", 
      "generalized similarity transformation", "Hermitian conjugate", 
      "Hermitian transpose", "inner products", "inverse matrix power", 
      "inverse of a matrix", "inversion of matrices", "invert", 
      "Jordan decomposition", "KroneckerProduct", "Krylov methods", "LAPACK", 
      "left eigenvectors", "linear matrix pencils", "LINPACK", "matrices", 
      "matrix direct product", "matrix equations", "MatrixExp", 
      "matrix exponential", "matrix function", "matrix multiplication", 
      "matrix multiply", "matrix pencils", "matrix polynomial", "MatrixPower",
       "matrix transpose", "matrix vector multiplication", 
      "multifrontal methods", "multiplication", "outer product", 
      "permutation of indices", "powers of matrices", "Putzer's method", 
      "reorder columns", "reverse columns", "reverse rows", 
      "right eigenvectors", "scalar product", "similarity transformation", 
      "singular eigenvalue problem", "solution of linear systems", 
      "sparse matrices", "spur of matrix", "tensor product", "tensors", 
      "trace of matrix", "transpose of matrices", "UMFPACK", "vectors"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's matrix operations handle both numeric and symbolic \
matrices, automatically accessing large numbers of highly efficient \
algorithms. Mathematica uses state-of-the-art algorithms to work with both \
dense and sparse matrices, and incorporates a number of powerful original \
algorithms, especially for high-precision and symbolic matrices.", 
    "synonyms" -> {}, "title" -> "Matrix Operations", "type" -> "Guide", 
    "uri" -> "guide/MatrixOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->20415],
Cell[677, 28, 488, 11, 70, "GuideAbstract",
 CellID->656],
Cell[1168, 41, 536, 19, 70, "GuideText",
 CellID->11959],
Cell[1707, 62, 44, 1, 70, "GuideDelimiter",
 CellID->16251],
Cell[1754, 65, 360, 11, 70, "GuideText",
 CellID->18738],
Cell[2117, 78, 394, 13, 70, "GuideText",
 CellID->13370],
Cell[2514, 93, 44, 1, 70, "GuideDelimiter",
 CellID->26124],
Cell[2561, 96, 467, 16, 70, "GuideText",
 CellID->5507],
Cell[3031, 114, 504, 16, 70, "GuideText",
 CellID->8007],
Cell[3538, 132, 218, 9, 70, "GuideText",
 CellID->17584],
Cell[3759, 143, 226, 9, 70, "GuideText",
 CellID->10951],
Cell[3988, 154, 427, 12, 70, "GuideText",
 CellID->453515050],
Cell[4418, 168, 44, 1, 70, "GuideDelimiter",
 CellID->14489],
Cell[4465, 171, 269, 9, 70, "GuideText",
 CellID->24958],
Cell[4737, 182, 245, 9, 70, "GuideText",
 CellID->15441],
Cell[4985, 193, 43, 1, 70, "GuideDelimiter",
 CellID->1790],
Cell[5031, 196, 415, 13, 70, "GuideText",
 CellID->17013],
Cell[5449, 211, 268, 9, 70, "GuideText",
 CellID->30412],
Cell[5720, 222, 291, 9, 70, "GuideText",
 CellID->14855]
}, Open  ]],
Cell[CellGroupData[{
Cell[6048, 236, 58, 1, 70, "GuideTutorialsSection",
 CellID->21060],
Cell[6109, 239, 157, 3, 70, "GuideTutorial",
 CellID->144885689],
Cell[6269, 244, 162, 3, 70, "GuideTutorial",
 CellID->15108586],
Cell[6434, 249, 173, 3, 70, "GuideTutorial",
 CellID->287220151],
Cell[6610, 254, 133, 3, 70, "GuideTutorial",
 CellID->860777521]
}, Open  ]],
Cell[CellGroupData[{
Cell[6780, 262, 59, 1, 70, "GuideMoreAboutSection",
 CellID->25402],
Cell[6842, 265, 140, 3, 70, "GuideMoreAbout",
 CellID->32676],
Cell[6985, 270, 161, 3, 70, "GuideMoreAbout",
 CellID->13543],
Cell[7149, 275, 153, 3, 70, "GuideMoreAbout",
 CellID->7373],
Cell[7305, 280, 148, 3, 70, "GuideMoreAboutSub",
 CellID->27651],
Cell[7456, 285, 202, 4, 70, "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],
Cell[CellGroupData[{
Cell[7695, 294, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1912971130],
Cell[7768, 297, 674, 18, 70, "GuideRelatedLinks",
 CellID->679801933]
}, Open  ]],
Cell[8457, 318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

