(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25507,        692]
NotebookOptionsPosition[     17546,        530]
NotebookOutlinePosition[     23606,        631]
CellTagsIndexPosition[     23563,        628]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Data Handling & Data Sources", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Building on the concept of symbolic data description,",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " 6.0 introduces the major new \"elements\" framework for handling import \
and export of data, in nearly a hundred distinct formats",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 also introduces the concept of large-scale integrated data sources, \
for the first time allowing immediate programmatic use of many forms of \
real-world data. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["New Import-Export Framework", "GuideFunctionsSubsection",
 CellID->118723986],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import data, specifying the elements to retrieve "
}], "GuideText",
 CellID->616145080],

Cell[TextData[{
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " export data, constructing the output from specified elements"
}], "GuideText",
 CellID->80780903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Import-Export Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60ImportAndExportFormats"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->266697293],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SWF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"QuickTime\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/QuickTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JPEG2000\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG2000"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JVX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JVX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Maya\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ODS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ODS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"USGSDEM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SDTS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MBOX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Base64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Base64"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GZIP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->440427083],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a bitmap or other elements for graphics"
}], "GuideText",
 CellID->555506084],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "infer formats from data"
}], "GuideText",
 CellID->618639174],

Cell["\t", "GuideDelimiterSubsection",
 CellID->77272604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Numerical Data Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumericalDataHandling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->528382548],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->502153281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Built-in Statistics Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->532873064],

Cell[TextData[{
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeanDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Skewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kurtosis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Kurtosis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->800684357],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Built-in Data Sources \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataCollections"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->6590137],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChemicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChemicalData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElementData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ElementData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AstronomicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AstronomicalData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CountryData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CountryData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CityData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CityData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FinancialData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FinancialData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WordData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WordData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DictionaryLookup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiterSubsection",
 CellID->80680710]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Date & Time Framework \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DateAndTime"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->619996798],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DateList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DatePlus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DatePlus"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DateDifference",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DateDifference"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DateAndTime"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->53243483]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Overview of Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataHandlingAndDataSourcesOverview"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Index of All New Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlphabeticalListing"]], "GuideMoreAboutSub",\

 CellID->582854384]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Data Handling & Data Sources - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 54.1420260}", "context" -> "", 
    "keywords" -> {
     "agglomeration", "AIFF format", "AMEX", "animations", 
      "Archimedean polyhedra", "Archimidean polyhedra", "astronomical data", 
      "asymmetry", "audio", "AU format", "AutoCAD format", "AVI", 
      "bin counts", "binning", "biomedical image format", 
      "bitmap graphics formats", "BMP", "bonds", "CAD", "calendar", 
      "capturing images", "category counts", "chemical compounds", 
      "chemical data", "chemical elements", "chemicals", "chemistry", 
      "city data", "clock", "cluster", "cluster analysis", "clustering", 
      "clustering of data", "comma-separated values", "commodities", 
      "computational linguistics", "computer-aided design", "country data", 
      "CSV format", "currencies", "currency", "data", "data feeds", 
      "datafeeds", "data filter", "data filtering", "data smoother", 
      "data smoothing", "date as string", "date difference", "date list", 
      "date plus", "date string", "date structure", "day", "ddf format", 
      "demographic data", "density estimation", "desktop publishing", "DICOM",
       "dictionary", "dictionary lookup", "DIF format", "dispersion", 
      "dividends", "drawing format", "draw programs", "DXF format", 
      "earnings", "EC-No", "EC number", "element data", 
      "encapsulated PostScript", "English", "EPS", "EPSF", "EPSI", "EPSTIFF", 
      "etymology", "excel format", "Excel format", "exchange rates", 
      "expectation", "expected value", "exporting graphics", 
      "exporting sounds", "ExpressionML", "external data", "filter taps", 
      "finance", "financial data", "financial options", "find clusters", 
      "finite impulse response filter", "FIR filter", "Fisher kurtosis", 
      "Fisher's kurtosis", "FITS format", "flexible Image Transport System", 
      "foreign data", "ftp", "funds", "futures", "geography", "geometry data",
       "GIF", "GIS data", "glossary", "grammar", "graph data", 
      "grouping of data", "Harwell-Boeing format", "HDF", "heavy tails", 
      "hierarchical Data Format", "high low close", "histogram", "hour", 
      "http", "human language", "hypernym", "hyponym", "image capture", 
      "image processing", "images", "market index", "interchange format", 
      "International Chemical Identifier", "JFIF", "JPEG", 
      "knowledge representation", "kurtosis", "kurtosis excess", "language", 
      "lexicography", "lexicology", "lexicon", "linear moving average", 
      "linguistics", "lithography", "lithography format", "long tails", 
      "Lotus 1-2-3 format", "MA", "Macintosh PICT", "market cap", 
      "MAT format", "matrix Market format", "mean deviation", 
      "medical imaging", "metafile format", "Metafile format", 
      "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "minute", "mode", "molecular weight", 
      "molecules", "month", "most frequent value", "moving average", 
      "moving mean", "MPS", "MTX format", "mu law format", "mutual funds", 
      "NASD", "NASDAQ", "natural language", "natural language processing", 
      "network data", "NLP", "NotebookML", "NYSE", "parse date", "parsing", 
      "partitioning of data", "parts of speech", "PBM graphics format", "PCX",
       "PEG ratio", "PE ratio", "PGM graphics format", "philology", 
      "phrase structure", "physical chemistry", "PICT", 
      "Pixmap graphics format", "Platonic solids", "PNG", 
      "PNM graphics format", "polyhedron data", "polytopes", 
      "portable anymap format", "portable bitmap format", 
      "portable graymap format", "portable pixmap format", 
      "PPM graphics format", "price data", "processing images", 
      "radiology formats", "range counts", "raster conversion", 
      "regular polyhedra", "robust estimates", "robust estimation", 
      "scalable vector graphics", "SDTS importing", "second", "securities", 
      "security", "semantics", "semantic tagging", "semiology", "semiotics", 
      "sentence structure", "shape", "shape statistic", 
      "simple moving average", "skew", "SMA", "SND format", 
      "solid object modeling", "sounds", "spoken language", "spreadsheets", 
      "statistical expectation", "statistical mode", "stereo-lithography", 
      "stereolithography format", "STL format", "stocks", "SVG", 
      "SymbolicXML", "tab-delimited data", "tabular data", "terrain data", 
      "thesaurus", "TIFF", "time", "trading", "trading volume", "TSV format", 
      "URL", "USD", "WAV format", "web", "web import", 
      "weighted moving average", "Windows metafile format", "WMA", "WMF", 
      "word data", "words", "world data", "written language", 
      "XBitmap format", "XLS format", "XML", "X Windows graphics format"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Building on the concept of symbolic data description, Mathematica 6.0 \
introduces the major new \"elements\" framework for handling import and \
export of data, in nearly a hundred distinct formats. Mathematica 6.0 also \
introduces the concept of large-scale integrated data sources, for the first \
time allowing immediate programmatic use of many forms of real-world data. ", 
    "synonyms" -> {}, "title" -> "New in 6.0: Data Handling & Data Sources", 
    "type" -> "Guide", "uri" -> "guide/NewIn60DataHandlingAndDataSources"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 82, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[704, 28, 527, 13, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1256, 45, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->118723986],
Cell[1342, 48, 322, 10, 70, "GuideText",
 CellID->616145080],
Cell[1667, 60, 332, 10, 70, "GuideText",
 CellID->80780903]
}, Open  ]],
Cell[CellGroupData[{
Cell[2036, 75, 244, 6, 70, "GuideFunctionsSubsection",
 CellID->266697293],
Cell[2283, 83, 4031, 114, 70, "InlineGuideFunctionListing",
 CellID->440427083],
Cell[6317, 199, 422, 12, 70, "GuideText",
 CellID->555506084],
Cell[6742, 213, 681, 19, 70, "GuideText",
 CellID->618639174],
Cell[7426, 234, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->77272604]
}, Open  ]],
Cell[CellGroupData[{
Cell[7520, 240, 246, 6, 70, "GuideFunctionsSubsection",
 CellID->528382548],
Cell[7769, 248, 1646, 42, 70, "InlineGuideFunctionListing",
 CellID->502153281]
}, Open  ]],
Cell[CellGroupData[{
Cell[9452, 295, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->532873064],
Cell[9695, 303, 1981, 50, 70, "InlineGuideFunctionListing",
 CellID->800684357],
Cell[11679, 355, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[11774, 361, 228, 6, 70, "GuideFunctionsSubsection",
 CellID->6590137],
Cell[12005, 369, 3362, 86, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[15370, 457, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->80680710]
}, Open  ]],
Cell[CellGroupData[{
Cell[15464, 463, 226, 6, 70, "GuideFunctionsSubsection",
 CellID->619996798],
Cell[15693, 471, 1325, 35, 70, "InlineGuideFunctionListing",
 CellID->53243483]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17067, 512, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[17132, 515, 195, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[17330, 521, 174, 4, 70, "GuideMoreAboutSub",
 CellID->582854384]
}, Open  ]],
Cell[17519, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

