(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68126,       1809]
NotebookOptionsPosition[     48323,       1422]
NotebookOutlinePosition[     62632,       1642]
CellTagsIndexPosition[     62589,       1639]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Mathematics & Algorithms", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 represents a major new level in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s distinguished twenty-year history of broad cutting-edge algorithm \
development. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified architecture and unique tradition of integrating disparate \
algorithmic areas\[LongDash]together with new basic scientific and \
mathematical methodologies created at Wolfram Research\[LongDash]have made \
possible an ever increasing rate of algorithm innovation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "GuideAbstract",
 CellID->17611489],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Mathematical Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MathematicalFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->81952034],

Cell[TextData[{
 Cell[TextData[ButtonBox["HankelH1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KelvinKer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinKer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParabolicCylinderD",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WhittakerM",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WhittakerM"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselJZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselJZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryAiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZernikeR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZernikeR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->71317725],

Cell["\t", "GuideDelimiterSubsection",
 CellID->739392104]
}, Open  ]],

Cell[CellGroupData[{

Cell["Major New Numerics Capabilities", "GuideFunctionsSubsection",
 CellID->524605910],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FindMaximum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMaximum"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support constrained nonlinear optimization"
}], "GuideText",
 CellID->93541131],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports constrained nonlinear fitting"
}], "GuideText",
 CellID->363167680],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Maximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Maximize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support integer programming"
}], "GuideText",
 CellID->82633842],

Cell[TextData[{
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "now supports efficient high-dimensional integration"
}], "GuideText",
 CellID->18058045],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InterpolatingPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " generalized to higher dimensions"
}], "GuideText",
 CellID->620853628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Matrix & Linear Algebra Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->110502329],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic representation of generalized banded matrices & arrays"
}], "GuideText",
 CellID->37106337],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generalized block matrix constructor"
}], "GuideText",
 CellID->316119392],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Orthogonalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Orthogonalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Projection",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Projection"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KroneckerProduct",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->187098474],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HermiteDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->214361285],

Cell["\t", "GuideDelimiterSubsection",
 CellID->266821883]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Symbolic & Algebraic Computing \
Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60AlgebraicComputing"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->328421121],

Cell[TextData[{
 Cell[TextData[ButtonBox["Discriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Discriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CountRoots",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CountRoots"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SymmetricPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SymmetricPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SymmetricReduction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SymmetricReduction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->346393892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports general equational theorem proving"
}], "GuideText",
 CellID->138751186],

Cell[TextData[{
 Cell[TextData[ButtonBox["SeriesCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports symbolic series"
}], "GuideText",
 CellID->263351231],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadeApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PadeApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PossibleZeroQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HornerForm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HornerForm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->830606265],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Apart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apart"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now automatically thread over equations"
}], "GuideText",
 CellID->595591190],

Cell["\t", "GuideDelimiterSubsection",
 CellID->162323790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Statistics Capabilities \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->171739400],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support symbolic distributions"
}], "GuideText",
 CellID->44072022],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeanDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeanDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Skewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kurtosis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Kurtosis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CentralMoment",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CentralMoment"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->133678542],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8870049],

Cell[TextData[{
 Cell[TextData[ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "probability density function, cumulative density function"
}], "GuideText",
 CellID->122109823]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Data Analysis Capabilities \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumericalDataHandling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->267929713],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingMedian",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingMedian"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->73734978],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find nearest neighbors in multidimensional data"
}], "GuideText",
 CellID->19925114],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " cluster analysis for numerical, Boolean, string, etc. data"
}], "GuideText",
 CellID->186323821],

Cell[TextData[{
 Cell[TextData[ButtonBox["EuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ManhattanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CorrelationDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CorrelationDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16514092],

Cell["\t", "GuideDelimiterSubsection",
 CellID->500940039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Computational Geometry Capabilities \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ComputationalGeometry"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->46784032],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " database of properties of regular polyhedra"
}], "GuideText",
 CellID->107876564],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NearestFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NearestFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->121025970],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransformationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TransformationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ComputationalGeometry"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->442155286],

Cell["\t", "GuideDelimiterSubsection",
 CellID->237987942]
}, Open  ]],

Cell[CellGroupData[{

Cell["New in Discrete Math", "GuideFunctionsSubsection",
 CellID->30731540],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["GraphPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["LayeredGraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " lay out graphs of any size"
}], "GuideText",
 CellID->29541],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " database of named graphs and their properties"
}], "GuideText",
 CellID->36094129],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display trees"
}], "GuideText",
 CellID->73720779],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindShortestTour",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindShortestTour"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve traveling salesman problems"
}], "GuideText",
 CellID->763209139],

Cell["\t", "GuideDelimiterSubsection",
 CellID->481817994]
}, Open  ]],

Cell[CellGroupData[{

Cell["New in Computational Systems", "GuideFunctionsSubsection",
 CellID->24371874],

Cell[TextData[{
 Cell[TextData[ButtonBox["TuringMachine",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TuringMachine"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general 1D, 2D, etc. Turing machines"
}], "GuideText",
 CellID->43225051],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extended to allow more general rules"
}], "GuideText",
 CellID->51553408],

Cell["\t", "GuideDelimiterSubsection",
 CellID->26782705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Mathematical Data Sources \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalData"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->317028838],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExampleData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExampleData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->728203263],

Cell["\t", "GuideDelimiterSubsection",
 CellID->508859336]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Number Theory & Integer Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->144904086],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowersRepresentations",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChineseRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrobeniusSolve",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimitiveRoot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BellB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BellB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RamanujanTau",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RamanujanTau"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->711459036],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "implicit representation of a general algebraic number"
}], "GuideText",
 CellID->344108202],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumberNorm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberNorm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldDiscriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToNumberField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ToNumberField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->357518894],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an algebraic approximation to a number"
}], "GuideText",
 CellID->493686518],

Cell[TextData[{
 Cell[TextData[ButtonBox["Divisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Divisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NextPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->283651199],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitSet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitSet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitShiftLeft",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitShiftLeft"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->261694990],

Cell["\t", "GuideDelimiterSubsection",
 CellID->697432649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Random Generation Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RandomNumberGeneration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->525148655],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RandomNumberGeneration"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->145125114],

Cell["\t", "GuideDelimiterSubsection",
 CellID->949789751]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Functions with Major New Algorithms", "GuideFunctionsSubsection",
 CellID->266252605],

Cell[TextData[{
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->466211341]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Overview of Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicsAndAlgorithmsOverview"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Index of All New Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlphabeticalListing"]], "GuideMoreAboutSub",\

 CellID->582854384]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Mathematics & Algorithms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 3.9079010}", "context" -> "", 
    "keywords" -> {
     "3D graph drawing", "3D graph embedding", "3D graph layout", 
      "3D graph visualization", "3D network layout", 
      "3D network visualization", "Abel equation", "Abramov algorithm", 
      "absolute value of algebraic number", "Adamchik techniques", 
      "Adams methods", "adaptive Monte Carlo integration", 
      "adaptive procedure", "adaptive quasi Monte Carlo integration", 
      "additive cellular automata", "affine transform", 
      "affine transformation", "agglomeration", "Airy Ai zero", 
      "Airy's differential equation", "algebraic field", "algebraic integer", 
      "algebraic number", "algebraic number field", 
      "algebraic number invariant", "algebraic number norm", 
      "algebraic rational", "algebraic simplification", "analytical solution",
       "anti-derivative", "approximate by algebraic number", 
      "approximate formulas", "approximation of functions", 
      "Archimedean polyhedra", "Archimidean polyhedra", "area", "areas", 
      "arithmetic difference equations", "array automata", "array flatten", 
      "artificial intelligence", "assertions", "assumptions", "asymmetry", 
      "asymptotic expansions", "automata", "average", "avg", "BDF methods", 
      "Bernoulli equation", "Bessel functions", 
      "Bessel function simplification", "Bessel zero", "Bezier curve", 
      "bilinear interpolation", "binary numbers", "binary number system", 
      "binary representation", "bin counts", "binning", 
      "Birkhoff interpolation", "bit set", "bit shift left", "block maps", 
      "Bocharov techniques", "boundary conditions", "Bronstein algorithm", 
      "b-spline", "b spline", "BVP", "CA", "Cartesian product cubature", 
      "category counts", "cell-automaton", "cell automaton", 
      "cellular automaton", "census", "central moment", "chasing method", 
      "chi squared distribution", "chi square distribution", 
      "Chinese remainder", "circle polynomials", "city block distance", 
      "cleaning up expressions", "Clenshaw-Curtis integration", 
      "closed-form solution", "cluster", "cluster analysis", "clustering", 
      "clustering of data", "coin problem", "combinatorial explosion", 
      "combinatorial simplification", "complete simplification", 
      "complex root counts", "composite quadrature", "compound arguments", 
      "compress expression", "concise form", "constrained local optimization",
       "constrained optimization", "continuous mappings of the shift", 
      "convert number", "convex programming", "correlation dissimilarity", 
      "correlation distance", "cost function", "count roots", 
      "coupled map lattices", "cubature", "cubic spline", 
      "cumulative distribution function", "curve fitting", 
      "cylindrical functions", "DAE", "d'Alembert test", "data filter", 
      "data filtering", "data smoother", "data smoothing", 
      "density estimation", "density function", "diff", "diffeq", 
      "difference-algebraic equations", "difference equations", 
      "differential-algebraic equations", "differential equations", 
      "digraph layout", "direct solver methods", "Dirichlet series", 
      "discrete equations", "discrete models", "discriminant", "dispersion", 
      "distribution", "distribution function", "divide-and-conquer equations",
       "divisibility", "divisible numbers", "division of matrices", 
      "double exponential integration", "draw a graph", "Dwight's tables", 
      "efficiency", "efficient polynomial evaluation", 
      "elementary cellular automata", "equivalence class counting", 
      "equivalence testing", "Euclidean distance", "Euclidean norm", 
      "exact root counts", "example data", "expanding special constants", 
      "expanding special functions", "expanding special sequences", 
      "expectation", "expected value", "extended GCD", "extrapolation", 
      "extremization", "factorial simplification", "Fibonacci equations", 
      "figure eight", "filter taps", "find clusters", "find fit", 
      "find maximum", "find minimum", "finite difference equations", 
      "finite group data", "finite impulse response filter", "FIR filter", 
      "Fisher kurtosis", "Fisher's kurtosis", "fits", "fitting curves", 
      "fitting differential equations", "fitting surfaces", "flatten matrix", 
      "flowchart layout", "formulas", "frequencies", "Frobenius equation", 
      "Frobenius solve", "full simplify", "function expand", 
      "gamma function simplification", "gather", "Gaussian distribution", 
      "Gaussian elimination", "Gaussian integral", "Gaussian quadrature", 
      "Gauss integral", "Gauss integration", "Gauss-Kronrod integration", 
      "gear method", "Gel'fand-Lokutsiyevskii method", 
      "Gelfand-Lokutsiyevskii method", "generator", "Genz-Malik algorithm", 
      "Genz-Malik cubature", "geometric difference equations", 
      "Germundsson methods", "global adaptive integration", 
      "global minimization", "goal functions", "Goktas methods", 
      "Gradshteyn-Ryzhik", "Gram-Schmidt", "graph data", "graph drawing", 
      "graph embedding", "graph layout", "graph plot", "graph plot 3D", 
      "graph visualization", "grid distance", "group generator", 
      "grouping of data", "guessing algebraic numbers", 
      "guessing minimal polynomials", "Hamilton-Jacobi equations", 
      "Hankel function of the first kind", "Hankel functions", "Hankel H1", 
      "heavy tails", "Hermite decomposition", "Hermite interpolation", 
      "heuristics", "hex digits", "hex values", "hexadecimal numbers", 
      "hierarchical graph layout", "histogram", 
      "homogeneous differential equations", "horner form", 
      "hypergeometric sums", "infrequent events", 
      "inhomogeneous differential equations", "initial conditions", 
      "integer length", "integer partitions", "integer programming", 
      "integer representation", "integer sequence equations", 
      "integer string", "integration over regions", 
      "interior point algorithm", "interior point methods", "interp", 
      "interpolate data", "interpolate equation", "interpolate formula", 
      "interpolate numbers", "interpolate table", "interpolating polynomial", 
      "inverse Z transform", "iterative arrays", "join block matrices", 
      "Karmarkar algorithm", "Kelvin functions", "Kelvin ker", "knot", 
      "knot data", "knot invariants", "Kovacic algorithm", 
      "Kronecker product", "Kronrod points", "Krylov methods", "kurtosis", 
      "kurtosis excess", "Las Vegas integration", "Laurent series", 
      "layered graph plot", "least squares", "least-squares", 
      "least-squares fits", "length of vector", "linear constraints", 
      "linear differential equations", "linear Diophantine equations", 
      "linear fractional programming", "linear interpolation", 
      "linear moving average", "linear objective function", 
      "linear optimization", "linear programming", "LINPACK", 
      "Lobatto-Kronrod integration", "local adaptive integration", 
      "local maximization", "local minimization", "local optimization", 
      "location", "long tails", "LP", "LSODA", "MA", "Maclaurin series", 
      "Maclaurin series expansion", "Manhattan distance", "Manhattan metric", 
      "Marichev-Adamchik methods", "mass function", "matrix direct product", 
      "matrix equations", "Matrix Market", "MatrixMarket", "maximization", 
      "mean", "mean deviation", "measures", "Mellin transform methods", 
      "mensuration", "method of lines", "minimization", "models", 
      "Modified Gram-Schmidt", "Monte Carlo integration", "moving average", 
      "moving mean", "moving median", "multifrontal methods", 
      "multi-panel quadrature", "multiple integrals", "multiple roots", 
      "multiplicities", "multivariate differential equations", 
      "nearest function", "network data", "network layout", 
      "network visualization", "Newton-Cotes integration", 
      "Newton interpolation", "next prime", "non-frequent events", 
      "nonlinear differential equations", "nonlinear fitting", 
      "norm of algebraic number", "normal distribution", "normalize vector", 
      "number base", "number field", "number field discriminant", 
      "number theory", "numerical integration", "numerical maximization", 
      "numerical maximum", "numerical minimization", 
      "numerical solution of differential equations", "objective functions", 
      "octal number system", "octal numbers", "ODE", "one-dimensional list", 
      "operations research", "optical aberrations", "optimization", 
      "ordinary differential equations", "orthogonalization", 
      "orthonormal basis", "orthonormal matrix", "Pade approximant", 
      "Pade technique", "parabolic cylinder", "partial difference equations", 
      "partial differential equations", "partial fractions", 
      "partial recurrence equations", "partitioning of data", "partitions", 
      "pay-off functions", "PDE", "Pearson chi square", "Pearson chi squared",
       "phase plots", "piecewise differential equations", "Platonic solids", 
      "plot a graph", "plot region", "plot volume", "Poisson distribution", 
      "Poisson process", "polyautomata", "polyhedron data", "polynomial", 
      "polynomial fit", "polynomial interpolation", 
      "polynomial representation", "polytopes", "possible zero", 
      "power series", "power series expansion", "powers representations", 
      "predicates", "primitive element", "primitive root", "prob", 
      "probability density function", "probability distribution", 
      "probability function", "probability mass function", 
      "project vector onto vector", "quadratic programming", "quadrature", 
      "quasi Monte Carlo integration", "Raabe test", "radial polynomials", 
      "radical simplification", "Ramanujan tau", 
      "Ramanujan tau-Dirichlet series", "Ramanujan tau function", "rand", 
      "randomint", "random choice", "random integer", "random number", 
      "random permutation", "random prime", "random real", "random sample", 
      "random selection", "random subset", "range counts", "rare events", 
      "rational function representation", "real root counts", 
      "recurrence equations", "recursion equations", "recursive drawing", 
      "recursive polynomial representation", "reduction formulas", 
      "reflection formula", "reflection formulas", "region integrals", 
      "region plot", "region plot3", "region plot 3D", "regular polyhedra", 
      "residuals", "resultant", "Riccati equations", "ring of integers", 
      "Risch algorithm", "rnd", "robust estimates", "robust estimation", 
      "Roman numbers", "Roman numerals", "root approximant", 
      "root counts in region", "rotation matrix", "rotation transform", 
      "rule numbers", "Runge-Kutta methods", "sample data", "sample moments", 
      "sample variance", "sampling with replacement", 
      "sampling without replacement", "Schlaefli symbol", "select randomly", 
      "sequence equations", "sequences", "series coefficient", 
      "series expansions", "series terms", "shape", "shape statistic", 
      "shortest form", "simple moving average", "simplest forms", 
      "simplex algorithm", "singularities", "skew", "Slater's Theorem", "SMA",
       "smallest field", "smallest form", "solution of linear systems", 
      "solving differential equations", "sparse matrices", 
      "special function simplification", "special functions", 
      "spherical Bessel", "spherical Bessel function", "spherical Bessel J", 
      "spheroidal functions", "spheroidal harmonics", "spheroidal s1", 
      "splines", "spread", "square free", "square-free integers", 
      "square-free polynomials", "square roots", "squash expression", 
      "stable polynomial evaluation", "standard normal distribution", 
      "statistical expectation", "StringInteger", "sum of powers", 
      "sum of squares", "surface integrals", "symbolic dynamics", 
      "symbolic sums", "symmetric polynomial", "symmetric reduction", 
      "symmetry reduction", "tally", "taxi cab distance", "taxicab distance", 
      "taxicab metric", "Taylor series", "Taylor series expansion", 
      "tensor product", "tesselation automata", "test data", "testing models",
       "theorem proving", "to number field", "totalistic cellular automata", 
      "transformation matrix", "transformations", "trapezoidal integration", 
      "traveling salesman problem", "tree plot", "trefoil", "trend line", 
      "trigonometric simplification", "TSP", "UMFPACK", "unitary matrix", 
      "unknot", "urn problem", "van Hoeij algorithms", "VAR", "variance", 
      "vector projection", "vector space projection", "volume integrals", 
      "weighted moving average", "Weninger model", "WMA", "Wythoff symbol", 
      "zero of Airy function", "zero recognition", 
      "zeros of Bessel functions", "zero testing", "zeta function root", 
      "zeta zero"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica 6.0 represents a major new level in Mathematica's \
distinguished twenty-year history of broad cutting-edge algorithm \
development. Mathematica's unified architecture and unique tradition of \
integrating disparate algorithmic areas--together with new basic scientific \
and mathematical methodologies created at Wolfram Research--have made \
possible an ever increasing rate of algorithm innovation in Mathematica. ", 
    "synonyms" -> {}, "title" -> "New in 6.0: Mathematics & Algorithms", 
    "type" -> "Guide", "uri" -> "guide/NewIn60MathematicsAndAlgorithms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 78, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[700, 28, 671, 18, 70, "GuideAbstract",
 CellID->17611489],
Cell[CellGroupData[{
Cell[1396, 50, 243, 6, 70, "GuideFunctionsSubsection",
 CellID->81952034],
Cell[1642, 58, 3797, 96, 70, "InlineGuideFunctionListing",
 CellID->71317725],
Cell[5442, 156, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->739392104]
}, Open  ]],
Cell[CellGroupData[{
Cell[5537, 162, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->524605910],
Cell[5627, 165, 461, 14, 70, "GuideText",
 CellID->93541131],
Cell[6091, 181, 317, 10, 70, "GuideText",
 CellID->363167680],
Cell[6411, 193, 579, 18, 70, "GuideText",
 CellID->82633842],
Cell[6993, 213, 283, 9, 70, "GuideText",
 CellID->18058045],
Cell[7279, 224, 476, 14, 70, "GuideText",
 CellID->620853628]
}, Open  ]],
Cell[CellGroupData[{
Cell[7792, 243, 265, 6, 70, "GuideFunctionsSubsection",
 CellID->110502329],
Cell[8060, 251, 428, 12, 70, "GuideText",
 CellID->37106337],
Cell[8491, 265, 418, 12, 70, "GuideText",
 CellID->316119392],
Cell[8912, 279, 1662, 42, 70, "InlineGuideFunctionListing",
 CellID->187098474],
Cell[10577, 323, 1321, 33, 70, "InlineGuideFunctionListing",
 CellID->214361285],
Cell[11901, 358, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->266821883]
}, Open  ]],
Cell[CellGroupData[{
Cell[11996, 364, 259, 6, 70, "GuideFunctionsSubsection",
 CellID->328421121],
Cell[12258, 372, 1671, 42, 70, "InlineGuideFunctionListing",
 CellID->346393892],
Cell[13932, 416, 332, 10, 70, "GuideText",
 CellID->138751186],
Cell[14267, 428, 323, 10, 70, "GuideText",
 CellID->263351231],
Cell[14593, 440, 1292, 33, 70, "InlineGuideFunctionListing",
 CellID->830606265],
Cell[15888, 475, 577, 19, 70, "GuideText",
 CellID->595591190],
Cell[16468, 496, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->162323790]
}, Open  ]],
Cell[CellGroupData[{
Cell[16563, 502, 234, 6, 70, "GuideFunctionsSubsection",
 CellID->171739400],
Cell[16800, 510, 562, 18, 70, "GuideText",
 CellID->44072022],
Cell[17365, 530, 1989, 50, 70, "InlineGuideFunctionListing",
 CellID->133678542],
Cell[19357, 582, 1319, 32, 70, "InlineGuideFunctionListing",
 CellID->8870049],
Cell[20679, 616, 683, 19, 70, "GuideText",
 CellID->122109823]
}, Open  ]],
Cell[CellGroupData[{
Cell[21399, 640, 248, 6, 70, "GuideFunctionsSubsection",
 CellID->267929713],
Cell[21650, 648, 1633, 42, 70, "InlineGuideFunctionListing",
 CellID->73734978],
Cell[23286, 692, 418, 12, 70, "GuideText",
 CellID->19925114],
Cell[23707, 706, 435, 11, 70, "GuideText",
 CellID->186323821],
Cell[24145, 719, 1324, 33, 70, "InlineGuideFunctionListing",
 CellID->16514092],
Cell[25472, 754, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->500940039]
}, Open  ]],
Cell[CellGroupData[{
Cell[25567, 760, 249, 6, 70, "GuideFunctionsSubsection",
 CellID->46784032],
Cell[25819, 768, 424, 11, 70, "GuideText",
 CellID->107876564],
Cell[26246, 781, 1416, 35, 70, "InlineGuideFunctionListing",
 CellID->121025970],
Cell[27665, 818, 1313, 32, 70, "InlineGuideFunctionListing",
 CellID->442155286],
Cell[28981, 852, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->237987942]
}, Open  ]],
Cell[CellGroupData[{
Cell[29076, 858, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->30731540],
Cell[29154, 861, 959, 25, 70, "GuideText",
 CellID->29541],
Cell[30116, 888, 415, 11, 70, "GuideText",
 CellID->36094129],
Cell[30534, 901, 386, 12, 70, "GuideText",
 CellID->73720779],
Cell[30923, 915, 273, 8, 70, "GuideText",
 CellID->763209139],
Cell[31199, 925, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->481817994]
}, Open  ]],
Cell[CellGroupData[{
Cell[31294, 931, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->24371874],
Cell[31380, 934, 414, 11, 70, "GuideText",
 CellID->43225051],
Cell[31797, 947, 330, 10, 70, "GuideText",
 CellID->51553408],
Cell[32130, 959, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->26782705]
}, Open  ]],
Cell[CellGroupData[{
Cell[32224, 965, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->317028838],
Cell[32462, 973, 1626, 41, 70, "InlineGuideFunctionListing",
 CellID->728203263],
Cell[34091, 1016, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->508859336]
}, Open  ]],
Cell[CellGroupData[{
Cell[34186, 1022, 268, 6, 70, "GuideFunctionsSubsection",
 CellID->144904086],
Cell[34457, 1030, 2773, 69, 70, "InlineGuideFunctionListing",
 CellID->711459036],
Cell[37233, 1101, 441, 12, 70, "GuideText",
 CellID->344108202],
Cell[37677, 1115, 1339, 33, 70, "InlineGuideFunctionListing",
 CellID->357518894],
Cell[39019, 1150, 431, 12, 70, "GuideText",
 CellID->493686518],
Cell[39453, 1164, 1999, 51, 70, "InlineGuideFunctionListing",
 CellID->283651199],
Cell[41455, 1217, 1654, 42, 70, "InlineGuideFunctionListing",
 CellID->261694990],
Cell[43112, 1261, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->697432649]
}, Open  ]],
Cell[CellGroupData[{
Cell[43207, 1267, 243, 6, 70, "GuideFunctionsSubsection",
 CellID->525148655],
Cell[43453, 1275, 1641, 41, 70, "InlineGuideFunctionListing",
 CellID->145125114],
Cell[45097, 1318, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->949789751]
}, Open  ]],
Cell[CellGroupData[{
Cell[45192, 1324, 96, 1, 70, "GuideFunctionsSubsection",
 CellID->266252605],
Cell[45291, 1327, 2510, 71, 70, "InlineGuideFunctionListing",
 CellID->466211341]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47850, 1404, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[47915, 1407, 189, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[48107, 1413, 174, 4, 70, "GuideMoreAboutSub",
 CellID->582854384]
}, Open  ]],
Cell[48296, 1420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

