(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13370,        413]
NotebookOptionsPosition[      8752,        300]
NotebookOutlinePosition[     11535,        354]
CellTagsIndexPosition[     11492,        351]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Number Digits", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle numbers of essentially unlimited length, in any base, using \
state-of-the-art platform-optimized algorithms, including several developed \
at Wolfram Research",
 ". ",
 "For rational numbers, it uses number-theoretic methods to efficiently find \
the exact forms of repeating digit sequences. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "digits of an integer"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "digits of a real number"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reconstruct a number from its digits"
}], "GuideText",
 CellID->111104295],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " total number of digits in an integer"
}], "GuideText",
 CellID->245819224],

Cell[TextData[{
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count the number of occurrences of given digits"
}], "GuideText",
 CellID->412350062],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MantissaExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MantissaExponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerPart"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->675950849],

Cell["\t", "GuideDelimiter",
 CellID->220780747],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "digits of an integer as a string"
}], "GuideText",
 CellID->677139805],

Cell[TextData[{
 Cell[TextData[ButtonBox["BaseForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BaseForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display a number in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->58633892],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PaddedForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PaddedForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DisplayOfNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->198023867],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Bitwise Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BitwiseOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->295332495],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitOr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitOr"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitNot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitNot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitShiftLeft",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitShiftLeft"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitSet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitSet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BitwiseOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3822]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Number Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1133407382],

Cell[TextData[{
 ButtonBox["Demonstrations related to Number Digits",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BaseForm+OR+BitAnd+OR+BitNot+OR+BitOr+OR+BitSet+OR+BitShiftLeft+OR+BitXor+OR+\
DigitCount+OR+FromDigits+OR+IntegerDigits+OR+IntegerExponent+OR+IntegerLength+\
OR+IntegerPart+OR+IntegerString+OR+MantissaExponent+OR+NumberForm+OR+\
PaddedForm+OR+RealDigits)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->539190466]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Number Digits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 16.2988432}", "context" -> "", 
    "keywords" -> {
     "add", "alignment of decimal points", "alignment of numbers in columns", 
      "alignment of numbers in tables", "base form", "bases", "bignums", 
      "binary digits", "binary number system", "binary numbers", 
      "binary representation", "bit and", "bit count", "bit not", "bit or", 
      "bit set", "bit shift left", "bit xor", "carry", "conversion", 
      "convert number", "count of digits", "decimal", "decimal digits", 
      "decode", "digit count", "digit sequences", "digital sums", "digits", 
      "digits count", "digits of real numbers", "encode", "explode", 
      "exponents of numbers", "fix", "floating-point decomposition", 
      "fractal", "from digits", "greatest dividing exponent", "half adder", 
      "Hamming weight", "height", "hex digits", "hex values", 
      "hexadecimal digits", "hexadecimal numbers", "int", "integer digits", 
      "integer exponent", "integer length", "integer part", "integer string", 
      "intrz", "mantissa exponent", "mask", "number base", 
      "number conversion", "number form", "number formatting", 
      "number reconstruction", "octal digits", "octal number system", 
      "octal numbers", "padded form", "padded formatting", 
      "padded numeric formatting", "padding", "radix conversion", 
      "real digits", "reconstruct a number", "reconstruction of numbers", 
      "recurring decimals", "repeating decimals", "Roman numbers", 
      "Roman numerals", "ruler function", "StringInteger", "ternary digits", 
      "trunc", "truncate to integer", "unpack"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica can handle numbers of essentially unlimited length, in any \
base, using state-of-the-art platform-optimized algorithms, including several \
developed at Wolfram Research. For rational numbers, it uses number-theoretic \
methods to efficiently find the exact forms of repeating digit sequences. ", 
    "synonyms" -> {}, "title" -> "Number Digits", "type" -> "Guide", "uri" -> 
    "guide/NumberDigits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[677, 28, 416, 10, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1096, 40, 259, 9, 70, "GuideText",
 CellID->203374175],
Cell[1358, 51, 257, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1618, 62, 269, 9, 70, "GuideText",
 CellID->111104295],
Cell[1890, 73, 415, 11, 70, "GuideText",
 CellID->245819224],
Cell[2308, 86, 280, 9, 70, "GuideText",
 CellID->412350062],
Cell[2591, 97, 640, 17, 70, "InlineGuideFunctionListing",
 CellID->675950849],
Cell[3234, 116, 48, 1, 70, "GuideDelimiter",
 CellID->220780747],
Cell[3285, 119, 416, 12, 70, "GuideText",
 CellID->677139805],
Cell[3704, 133, 305, 10, 70, "GuideText",
 CellID->58633892],
Cell[4012, 145, 617, 17, 70, "InlineGuideFunctionListing",
 CellID->198023867],
Cell[4632, 164, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[4715, 169, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->295332495],
Cell[4941, 176, 1713, 47, 70, "InlineGuideFunctionListing",
 CellID->3822]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6703, 229, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6768, 232, 151, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[6922, 237, 207, 4, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[7166, 246, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7231, 249, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7395, 254, 165, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7563, 259, 188, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[7754, 266, 155, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[7946, 274, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1133407382],
Cell[8019, 277, 691, 18, 70, "GuideRelatedLinks",
 CellID->539190466]
}, Open  ]],
Cell[8725, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

