(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13895,        421]
NotebookOptionsPosition[      8860,        299]
NotebookOutlinePosition[     11833,        356]
CellTagsIndexPosition[     11790,        353]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Number Recognition", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "A core activity in exploratory experimental mathematics is recognition of \
numbers: going backwards from a number to find out how it can be generated",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides tools for recognizing many classes of numbers, including a number \
of original algorithms."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Primes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Primes"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Algebraics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Algebraics"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rationals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->150204187],

Cell[TextData[{
 Cell[TextData[ButtonBox["Element",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test whether a number is in a given class"
}], "GuideText",
 CellID->165740297],

Cell["\t", "GuideDelimiter",
 CellID->227068347],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rationalize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationalize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a rational approximation"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Convergents",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Convergents"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->98939158],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an approximating algebraic number"
}], "GuideText",
 CellID->145900339],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MinimalPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->242350968],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find reduced basis vectors in a lattice"
}], "GuideText",
 CellID->560786831],

Cell["\t", "GuideDelimiter",
 CellID->793795963],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce an exact numeric expression to simpler functions"
}], "GuideText",
 CellID->178462660],

Cell["\t", "GuideDelimiter",
 CellID->293173500],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "recognize prime numbers"
}], "GuideText",
 CellID->354384744],

Cell[TextData[{
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimePowerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimePowerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicIntegerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicIntegerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->130454388]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "GuideTutorial",
 CellID->8048206],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "GuideTutorial",
 CellID->596666207],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "GuideTutorial",
 CellID->109534443],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->161376627],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "GuideTutorial",
 CellID->94053280]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAboutSub",
 CellID->364062707],

Cell[TextData[ButtonBox["Analyzing Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAbout",
 CellID->517831915]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->997920384],

Cell[TextData[{
 ButtonBox["Demonstrations related to Number Recognition",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AlgebraicIntegerQ+OR+Algebraics+OR+ContinuedFraction+OR+Convergents+OR+\
Element+OR+FunctionExpand+OR+Integers+OR+LatticeReduce+OR+MinimalPolynomial+\
OR+PrimePowerQ+OR+PrimeQ+OR+Primes+OR+Rationalize+OR+Rationals+OR+\
RootApproximant+OR+RootReduce+OR+SquareFreeQ+OR+ToRadicals)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->401931273]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Number Recognition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 16.9238592}", "context" -> "", 
    "keywords" -> {
     "algebraic integer", "algebraic number", "algebraic numbers", 
      "algebraic solutions", "algebraic variables", "AlgebraicNumber", 
      "approximate by algebraic number", "approximation", "basis vectors", 
      "characteristic polynomial", "combinatorial algorithms", 
      "combining radicals", "compound arguments", "continued fraction", 
      "continued fractions", "domain assumptions", "domain membership", 
      "domain of algebraic numbers", "domains for variables", "exact numbers",
       "expanding", "expanding special constants", 
      "expanding special functions", "expanding special sequences", 
      "fraction expansion", "fractions", "function expand", 
      "guessing algebraic numbers", "guessing minimal polynomials", 
      "identities", "infinite fraction", "integer domain", "integer lattice", 
      "integer range", "integer solutions", "integer variables", "integers", 
      "integral numbers", "isprime", "lattice reduce", "minimal polynomial", 
      "number representation", "partial quotients", "power of a prime", 
      "primality testing", "Prime domain", "Prime number", "prime power", 
      "Primes", "pseudoprime test", "quadratic irrationals", 
      "radical expression", "rational approximation", "rational numbers", 
      "rational solutions", "rational space", "rational variables", 
      "recursive fraction", "reducing radicals", "reduction formulas", 
      "reflection formulas", "root", "root approximant", "root of polynomial",
       "root reduce", "roots", "simplifying radicals", "square free", 
      "square-free integers", "square-free polynomials", "surds", 
      "testing for primality of integers", "testing for prime", "to radicals",
       "type specification", "whole numbers"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "A core activity in exploratory experimental mathematics is recognition \
of numbers: going backwards from a number to find out how it can be \
generated. Mathematica provides tools for recognizing many classes of \
numbers, including a number of original algorithms.", "synonyms" -> {}, 
    "title" -> "Number Recognition", "type" -> "Guide", "uri" -> 
    "guide/NumberRecognition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 373, 9, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1058, 39, 814, 23, 70, "InlineGuideFunctionListing",
 CellID->150204187],
Cell[1875, 64, 263, 8, 70, "GuideText",
 CellID->165740297],
Cell[2141, 74, 48, 1, 70, "GuideDelimiter",
 CellID->227068347],
Cell[2192, 77, 264, 9, 70, "GuideText",
 CellID->203374175],
Cell[2459, 88, 564, 14, 70, "InlineGuideFunctionListing",
 CellID->98939158],
Cell[3026, 104, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[3077, 107, 426, 12, 70, "GuideText",
 CellID->145900339],
Cell[3506, 121, 775, 20, 70, "InlineGuideFunctionListing",
 CellID->242350968],
Cell[4284, 143, 278, 9, 70, "GuideText",
 CellID->560786831],
Cell[4565, 154, 48, 1, 70, "GuideDelimiter",
 CellID->793795963],
Cell[4616, 157, 296, 9, 70, "GuideText",
 CellID->178462660],
Cell[4915, 168, 48, 1, 70, "GuideDelimiter",
 CellID->293173500],
Cell[4966, 171, 248, 9, 70, "GuideText",
 CellID->354384744],
Cell[5217, 182, 1069, 26, 70, "InlineGuideFunctionListing",
 CellID->130454388]
}, Open  ]],
Cell[CellGroupData[{
Cell[6323, 213, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6388, 216, 147, 3, 70, "GuideTutorial",
 CellID->8048206],
Cell[6538, 221, 152, 3, 70, "GuideTutorial",
 CellID->596666207],
Cell[6693, 226, 163, 3, 70, "GuideTutorial",
 CellID->109534443],
Cell[6859, 231, 206, 4, 70, "GuideTutorial",
 CellID->161376627],
Cell[7068, 237, 172, 3, 70, "GuideTutorial",
 CellID->94053280]
}, Open  ]],
Cell[CellGroupData[{
Cell[7277, 245, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7342, 248, 188, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[7533, 255, 145, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[7681, 260, 145, 3, 70, "GuideMoreAboutSub",
 CellID->364062707],
Cell[7829, 265, 161, 3, 70, "GuideMoreAbout",
 CellID->517831915]
}, Open  ]],
Cell[CellGroupData[{
Cell[8027, 273, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->997920384],
Cell[8099, 276, 719, 18, 70, "GuideRelatedLinks",
 CellID->401931273]
}, Open  ]],
Cell[8833, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

