(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30214,        865]
NotebookOptionsPosition[     20372,        651]
NotebookOutlinePosition[     26827,        758]
CellTagsIndexPosition[     26784,        755]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Number Theory", "GuideTitle",
 CellID->7028],

Cell[TextData[{
 "Packing a large number of sophisticated algorithms\[LongDash]many recent \
and original\[LongDash]into a powerful collection of functions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " draws on almost every major result in  number theory. A key tool for two \
decades in the advance of the field, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture and web of highly efficient algorithms make it a \
unique platform for number-theoretical experiment, discovery and proof. "
}], "GuideAbstract",
 CellID->83522133],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the factors of an integer"
}], "GuideText",
 CellID->11503],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an integer is prime"
}], "GuideText",
 CellID->26569],

Cell[TextData[{
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NextPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimePi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimePi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EulerPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MoebiusMu",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MoebiusMu"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/IntegerFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6816],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LerchPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LerchPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberTheoreticFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1883],

Cell["\t", "GuideDelimiter",
 CellID->440412193],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerMod"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "modular powers, roots and inverses"
}], "GuideText",
 CellID->241422744],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimitiveRoot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultiplicativeOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChineseRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberTheoreticFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->322232042],

Cell["\t", "GuideDelimiter",
 CellID->25367],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find general solutions to Diophantine equations"
}], "GuideText",
 CellID->5385],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "search for particular solutions to Diophantine equations"
}], "GuideText",
 CellID->28402],

Cell["\t", "GuideDelimiter",
 CellID->17157],

Cell[TextData[{
 Cell[TextData[ButtonBox["Element",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test field, ring, etc. memberships "
}], "GuideText",
 CellID->28681],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integers"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rationals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Algebraics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Algebraics"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Primes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Primes"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15567],

Cell["\t", "GuideDelimiter",
 CellID->3477],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent an algebraic number"
}], "GuideText",
 CellID->1866],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce algebraic numbers to canonical form"
}], "GuideText",
 CellID->3687],

Cell[TextData[{
 Cell[TextData[ButtonBox["GaussianIntegers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "allow factorization over Gaussian integers"
}], "GuideText",
 CellID->13171],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimalPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->235774160],

Cell["\t", "GuideDelimiter",
 CellID->403220119],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromContinuedFraction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromContinuedFraction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ContinuedFractionsAndRationalApproximations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->242909754],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rationalize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationalize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find rational approximations"
}], "GuideText",
 CellID->6238],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find short bases in integer lattices"
}], "GuideText",
 CellID->27671],

Cell["\t", "GuideDelimiter",
 CellID->19635810],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberDigits"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2047],

Cell["\t", "GuideDelimiter",
 CellID->26115],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find restricted and unrestricted partitions of integers"
}], "GuideText",
 CellID->4592],

Cell[TextData[{
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrobeniusNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SquaresR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquaresR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->27311],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowersRepresentations",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find representations of integers as sums of powers"
}], "GuideText",
 CellID->528246983],

Cell["\t", "GuideDelimiter",
 CellID->32657],

Cell[TextData[{
 Cell[TextData[ButtonBox["Divisors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divisors"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DivisorSigma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DivisorSigma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DedekindEta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DedekindEta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1405],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Number Theory \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicNumberTheory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->410160073],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToNumberField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ToNumberField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "operate in a given algebraic number field "
}], "GuideText",
 CellID->288084634],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberFieldDiscriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldIntegralBasis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->246133628]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->53],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->7171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->22740],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->22530],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAbout",
 CellID->13675],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->24320],

Cell[TextData[ButtonBox["Discrete Math",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->25790],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "GuideMoreAboutSub",
 CellID->395599860],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "GuideMoreAboutSub",
 CellID->10998],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAboutSub",
 CellID->537961844],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAboutSub",
 CellID->930454250],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->116692336],

Cell[TextData[{
 ButtonBox["Demonstrations related to Number Theory",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Algebraics+OR+ChineseRemainder+OR+ContinuedFraction+OR+DedekindEta+OR+\
DigitCount+OR+Divisors+OR+DivisorSigma+OR+Element+OR+EllipticTheta+OR+\
EulerPhi+OR+FactorInteger+OR+FindInstance+OR+FrobeniusNumber+OR+\
FromContinuedFraction+OR+FromDigits+OR+GaussianIntegers+OR+IntegerDigits+OR+\
IntegerPartitions+OR+Integers+OR+JacobiSymbol+OR+LatticeReduce+OR+LerchPhi+OR+\
LogIntegral+OR+MinimalPolynomial+OR+MoebiusMu+OR+MultiplicativeOrder+OR+\
NextPrime+OR+NumberFieldDiscriminant+OR+NumberFieldIntegralBasis+OR+\
PartitionsP+OR+PartitionsQ+OR+PowerMod+OR+PowersRepresentations+OR+Prime+OR+\
PrimePi+OR+PrimeQ+OR+Primes+OR+PrimitiveRoot+OR+Rationalize+OR+Rationals+OR+\
RealDigits+OR+Reals+OR+Reduce+OR+RiemannSiegelZ+OR+Root+OR+RootApproximant+OR+\
RootReduce+OR+SquaresR+OR+Sum+OR+ToNumberField+OR+Zeta+OR+ZetaZero)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->1256734]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Number Theory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 23.7052828}", "context" -> "", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", "algebraic number", 
      "algebraic numbers", "algebraic solutions", "algebraic variables", 
      "approximate by algebraic number", "bases", "basis vectors", 
      "binary digits", "bit count", "Boolean satisfiability", 
      "Catalan beta function", "characteristic polynomial", 
      "Chinese remainder", "Chinese remainder theorem", 
      "Collins-Krandick algorithm", "combinatorial algorithms", 
      "combining radicals", "complex variables", "continued fraction", 
      "continued fractions", "convergents", "counterexample", 
      "count of digits", "cylindrical decomposition", "d'Alembert test", 
      "decimal digits", "decomposition into primes", 
      "Dedekind elliptic function", "Dedekind eta", "density of primes", 
      "Descartes' rule of signs", "digit count", "digit sequences", 
      "digital sums", "digits", "digits count", "digits of real numbers", 
      "Diophantine equations", "Dirichlet L series", "Dirichlet series", 
      "discrete log", "discrete logarithm", "distribution of primes", 
      "divisor function", "divisor sigma", "domain assumptions", 
      "domain membership", "domain of algebraic numbers", "domains", 
      "domains for variables", "double-periodic function", 
      "elliptic functions", "elliptic theta", "encode", "Euler phi", 
      "Euler totient", "Euler-Maclaurin summation", 
      "Euler's pentagonal formula", "exact numbers", "explode", 
      "factor integer", "factoring", "factors", "Fermi-Dirac integrals", 
      "find instance", "finite fields", "fraction expansion", "fractions", 
      "Frobenius number", "from continued fraction", "from digits", 
      "Gaussian integers", "generalized zeta function", "Groebner basis", 
      "group generator", "group order", "guessing algebraic numbers", 
      "guessing minimal polynomials", "Hamming weight", 
      "Hardy-Muskat-Williams methods", "Hardy-Ramanujan-Rademacher algorithm",
       "hexadecimal digits", "Hurwitz zeta function", "hypergeometric sums", 
      "ifact", "implode", "index function", "inequalities", 
      "infinite fraction", "integer digits", "integer domain", 
      "integer equations", "integer factoring", "integer lattice", 
      "integer partitions", "integer range", "integer representation", 
      "integer solutions", "integer variables", "integers", "integral basis", 
      "integral numbers", "inverses in finite fields", "isprime", 
      "Jacobi symbol", "Jacobi theta 1", "Jacobi theta 2", "Jacobi theta 3", 
      "Jacobi theta 4", "Lagarias-Miller-Odlyzko algorithm", "lattice reduce",
       "Legendre symbol", "Lenstra-Lenstra-Lovasz algorithm", 
      "Lerch function Phi", "Lerch phi", "Lerch transcendent", "li", 
      "linear equations", "linear inequalities", "LLL algorithm", 
      "log integral", "logarithmic integral", "L-series in number theory", 
      "Lucas test", "Miller-Rabin test", "minimal polynomial", "mobius", 
      "Mobius function", "modular equations", "modular forms", 
      "modular inverses", "modular powers", "modular root", "moebius", 
      "Moebius function", "Moebius mu", "mu", "multiplicative order", 
      "next prime", "number conversion", "number field", "number field basis",
       "number field discriminant", "number field integral basis", 
      "number reconstruction", "number representation", "octal digits", 
      "Order", "partial quotients", "partitions", "Pell equations", "phi", 
      "Pollard algorithm", "polynomial equations", "polynomial inequalities", 
      "population count", "power mod", "power series", 
      "powers in finite fields", "powers representations", 
      "primality testing", "prime", "prime counting function", "Prime domain",
       "prime factors", "Prime number", "prime pi", "primes", 
      "primitive element", "primitive root", "pseudoprime test", 
      "quadratic irrationals", "Raabe's test", "radix conversion", 
      "rational approximation", "rational numbers", "rational solutions", 
      "rational space", "rational variables", "real axis", "real digits", 
      "real domain", "real numbers", "real plane", "real range", 
      "real solutions", "real space", "real variables", "reals", 
      "reconstruction", "recurring decimals", "recursive fraction", 
      "reducing inequalities", "reducing radicals", "regions", 
      "representation", "Riemann hypothesis", "Riemann-Siegel", 
      "Riemann Siegel", "Riemann-Siegel formula", "Riemann zeta function", 
      "Roman numerals", "root approximant", "root reduce", "roots", 
      "roots of equations", "sample points", "semi-algebraic sets", 
      "sequences", "sigma", "simplifying radicals", "smallest field", 
      "solutions", "submultiples", "sum of powers", "sum of squares", "sums", 
      "sums of reciprocal powers", "surds", "symbolic sums", "ternary digits",
       "testing for primality of integers", "testing for prime", "theta1", 
      "theta2", "theta3", "theta4", "theta functions", "to number field", 
      "totient function", "whole numbers", "zeta function", 
      "zeta function root", "zeta zero"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Packing a large number of sophisticated algorithms--many recent and \
original--into a powerful collection of functions, Mathematica draws on \
almost every major result in number theory. A key tool for two decades in the \
advance of the field, Mathematica's symbolic architecture and web of highly \
efficient algorithms make it a unique platform for number-theoretical \
experiment, discovery and proof. ", "synonyms" -> {}, "title" -> 
    "Number Theory", "type" -> "Guide", "uri" -> "guide/NumberTheory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->7028],
Cell[672, 28, 567, 12, 70, "GuideAbstract",
 CellID->83522133],
Cell[1242, 42, 265, 9, 70, "GuideText",
 CellID->11503],
Cell[1510, 53, 253, 9, 70, "GuideText",
 CellID->26569],
Cell[1766, 64, 1585, 44, 70, "InlineGuideFunctionListing",
 CellID->6816],
Cell[3354, 110, 1592, 45, 70, "InlineGuideFunctionListing",
 CellID->1883],
Cell[4949, 157, 48, 1, 70, "GuideDelimiter",
 CellID->440412193],
Cell[5000, 160, 263, 9, 70, "GuideText",
 CellID->241422744],
Cell[5266, 171, 1166, 30, 70, "InlineGuideFunctionListing",
 CellID->322232042],
Cell[6435, 203, 44, 1, 70, "GuideDelimiter",
 CellID->25367],
Cell[6482, 206, 267, 9, 70, "GuideText",
 CellID->5385],
Cell[6752, 217, 289, 9, 70, "GuideText",
 CellID->28402],
Cell[7044, 228, 44, 1, 70, "GuideDelimiter",
 CellID->17157],
Cell[7091, 231, 253, 8, 70, "GuideText",
 CellID->28681],
Cell[7347, 241, 1012, 29, 70, "InlineGuideFunctionListing",
 CellID->15567],
Cell[8362, 272, 43, 1, 70, "GuideDelimiter",
 CellID->3477],
Cell[8408, 275, 245, 9, 70, "GuideText",
 CellID->1866],
Cell[8656, 286, 270, 9, 70, "GuideText",
 CellID->3687],
Cell[8929, 297, 283, 9, 70, "GuideText",
 CellID->13171],
Cell[9215, 308, 931, 23, 70, "InlineGuideFunctionListing",
 CellID->235774160],
Cell[10149, 333, 48, 1, 70, "GuideDelimiter",
 CellID->403220119],
Cell[10200, 336, 683, 18, 70, "InlineGuideFunctionListing",
 CellID->242909754],
Cell[10886, 356, 258, 9, 70, "GuideText",
 CellID->6238],
Cell[11147, 367, 271, 9, 70, "GuideText",
 CellID->27671],
Cell[11421, 378, 47, 1, 70, "GuideDelimiter",
 CellID->19635810],
Cell[11471, 381, 1038, 29, 70, "InlineGuideFunctionListing",
 CellID->2047],
Cell[12512, 412, 44, 1, 70, "GuideDelimiter",
 CellID->26115],
Cell[12559, 415, 442, 12, 70, "GuideText",
 CellID->4592],
Cell[13004, 429, 1124, 29, 70, "InlineGuideFunctionListing",
 CellID->27311],
Cell[14131, 460, 450, 12, 70, "GuideText",
 CellID->528246983],
Cell[14584, 474, 44, 1, 70, "GuideDelimiter",
 CellID->32657],
Cell[14631, 477, 831, 23, 70, "InlineGuideFunctionListing",
 CellID->1405],
Cell[CellGroupData[{
Cell[15487, 504, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->410160073],
Cell[15722, 511, 426, 12, 70, "GuideText",
 CellID->288084634],
Cell[16151, 525, 966, 23, 70, "InlineGuideFunctionListing",
 CellID->246133628]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17166, 554, 55, 1, 70, "GuideTutorialsSection",
 CellID->53],
Cell[17224, 557, 193, 4, 70, "GuideTutorial",
 CellID->7171]
}, Open  ]],
Cell[CellGroupData[{
Cell[17454, 566, 59, 1, 70, "GuideMoreAboutSection",
 CellID->22740],
Cell[17516, 569, 163, 3, 70, "GuideMoreAbout",
 CellID->22530],
Cell[17682, 574, 154, 3, 70, "GuideMoreAbout",
 CellID->13675],
Cell[17839, 579, 146, 3, 70, "GuideMoreAbout",
 CellID->24320],
Cell[17988, 584, 145, 3, 70, "GuideMoreAbout",
 CellID->25790],
Cell[18136, 589, 145, 3, 70, "GuideMoreAboutSub",
 CellID->395599860],
Cell[18284, 594, 168, 3, 70, "GuideMoreAboutSub",
 CellID->10998],
Cell[18455, 599, 153, 3, 70, "GuideMoreAboutSub",
 CellID->537961844],
Cell[18611, 604, 155, 3, 70, "GuideMoreAboutSub",
 CellID->930454250],
Cell[18769, 609, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[19009, 618, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->116692336],
Cell[19081, 621, 1249, 25, 70, "GuideRelatedLinks",
 CellID->1256734]
}, Open  ]],
Cell[20345, 649, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

