(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19180,        578]
NotebookOptionsPosition[     12429,        418]
NotebookOutlinePosition[     16611,        493]
CellTagsIndexPosition[     16568,        490]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Evaluation & Precision", "GuideTitle",
 CellID->18135],

Cell[TextData[{
 "In two decades of intense algorithmic development, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has established a new level of numerical computation. Particularly notable \
are its many original highly efficient algorithms, its methodology for \
automatic algorithm selection, and its systemwide support for automatic error \
tracking and arbitrary-precision arithmetic. "
}], "GuideAbstract",
 CellID->12258],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical evaluation to any precision"
}], "GuideText",
 CellID->22951],

Cell["\t", "GuideDelimiterSubsection",
 CellID->18140],

Cell[CellGroupData[{

Cell["Major Numerics Functions", "GuideFunctionsSubsection",
 CellID->11094],

Cell[TextData[{
 Cell[TextData[ButtonBox["NSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NSum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSum"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12937]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Complex Numbers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ComplexNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->5174],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Re",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Re"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Im",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Im"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Conjugate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Conjugate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ComplexNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Representation of Numbers \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RepresentationOfNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->6097],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RepresentationOfNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Display of Numbers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DisplayOfNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->2695],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberMarks",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberMarks"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DisplayOfNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21817]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Precision & Accuracy Control \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PrecisionAndAccuracyControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->23492],

Cell[TextData[{
 Cell[TextData[ButtonBox["Precision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Precision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Accuracy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Accuracy"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrecisionGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AccuracyGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21292]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithm Control & Analysis", "GuideFunctionsSubsection",
 CellID->20237],

Cell[TextData[{
 Cell[TextData[ButtonBox["Method",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Method"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StepMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StepMonitor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvaluationMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->27530]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->613],

Cell[TextData[ButtonBox["Exact and Approximate Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExactAndApproximateResults"]], "GuideTutorial",
 CellID->123761205],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ArbitraryPrecisionCalculations"]], "GuideTutorial",
 CellID->870075514],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "GuideTutorial",
 CellID->519125793],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "GuideTutorial",
 CellID->385165521],

Cell[TextData[ButtonBox["Monitoring and Selecting Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MonitoringAndSelectingAlgorithms"]], "GuideTutorial",
 CellID->115788988],

Cell[TextData[{
 ButtonBox["Advanced Numerical Integration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->11329537]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->32389],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "GuideMoreAbout",
 CellID->236504987],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "GuideMoreAbout",
 CellID->5628],

Cell[TextData[ButtonBox["Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->5809],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FiniteFields/guide/FiniteFieldsPackage"]], "GuideMoreAbout",
 CellID->992960892],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAboutSub",
 CellID->626949645],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/guide/QuaternionsPackage"]], "GuideMoreAbout",\

 CellID->202438413],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], \
"GuideMoreAbout",
 CellID->102209801]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->302733078],

Cell[TextData[{
 ButtonBox["Demonstrations related to Numerical Evaluation & Precision",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Accuracy+OR+AccuracyGoal+OR+CForm+OR+EvaluationMonitor+OR+FromDigits+OR+\
InputForm+OR+IntegerDigits+OR+IntegerQ+OR+Method+OR+NDSolve+OR+NIntegrate+OR+\
NMinimize+OR+Norm+OR+NSolve+OR+NSum+OR+NumberForm+OR+NumberMarks+OR+Precision+\
OR+PrecisionGoal+OR+RealDigits+OR+StepMonitor)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->133821583]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Evaluation & Precision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 26.5491056}", "context" -> "", 
    "keywords" -> {
     "1D format", "1-norm", "2-norm", "absolute error", "absolute value", 
      "accuracy goal", "accuracy of result", "Adams methods", 
      "adaptive Monte Carlo integration", "adaptive procedure", 
      "adaptive quasi-Monte Carlo integration", 
      "alternating series summation", "approximations", "ASCII input syntax", 
      "back-tick in numbers", "bases", "BDF methods", "binary digits", 
      "boundary conditions", "BVP", "Cartesian product cubature", 
      "chasing method", "Clenshaw-Curtis integration", "composite quadrature",
       "conformity", "constrained optimization", "cost function", "cubature", 
      "DAE", "decimal digits", "decimal places", 
      "differential-algebraic equations", "differential equations", "digits", 
      "digits of real numbers", "direct equation solving method", 
      "direct method for root finding", "double exponential integration", 
      "Euclidean norm", "Euler-Maclaurin summation", "evaluation monitor", 
      "explode", "extremization", "Gauss integration", "Gaussian quadrature", 
      "Gauss-Kronrod integration", "gear method", 
      "Gel'fand-Lokutsiyevskii method", "Gelfand-Lokutsiyevskii method", 
      "Genz-Malik algorithm", "Genz-Malik cubature", 
      "global adaptive integration", "global minimization", "goal functions", 
      "induced matrix norm", "infinity-norm", "initial conditions", 
      "inner product norm", "integer programming", "integration", 
      "intermediate results", "Jenkins-Traub algorithm", "Kronrod points", 
      "language conversion", "Las Vegas integration", "linear formatting", 
      "linear input", "linear programming", "Lobatto-Kronrod integration", 
      "local adaptive integration", "LSODA", "matrix norm", "metric", 
      "minimization", "Monte Carlo integration", "multi-panel quadrature", 
      "Newton-Cotes integration", "norm", "number of decimal places", 
      "number of digits", "number reconstruction", "numerical integration", 
      "numerical minimization", 
      "numerical solution of differential equations", 
      "numerical solution of polynomial equations", "numerical summation", 
      "objective functions", "ODE", "operations research", "optimization", 
      "ordinary differential equations", "output", 
      "partial differential equations", "pay-off functions", "PDE", 
      "polynomial equations", "polynomial root finding", "precision", 
      "precision goal", "quadrature", "quasi-Monte Carlo integration", "real",
       "real digits", "relative error", "roots of polynomials", 
      "Runge-Kutta methods", "sequence acceleration", "singularities", 
      "solution of polynomial equations", "solving differential equations", 
      "step monitor", "sums", "testing for integers", 
      "trapezoidal integration", "vector length", "vector norm", "veracity", 
      "Wynn epsilon "}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In two decades of intense algorithmic development, Mathematica has \
established a new level of numerical computation. Particularly notable are \
its many original highly efficient algorithms, its methodology for automatic \
algorithm selection, and its systemwide support for automatic error tracking \
and arbitrary-precision arithmetic. ", "synonyms" -> {}, "title" -> 
    "Numerical Evaluation & Precision", "type" -> "Guide", "uri" -> 
    "guide/NumericalEvaluationAndPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->18135],
Cell[692, 28, 437, 9, 70, "GuideAbstract",
 CellID->12258],
Cell[1132, 39, 248, 9, 70, "GuideText",
 CellID->22951],
Cell[1383, 50, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->18140],
Cell[CellGroupData[{
Cell[1462, 55, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->11094],
Cell[1541, 58, 1008, 29, 70, "InlineGuideFunctionListing",
 CellID->12937]
}, Open  ]],
Cell[CellGroupData[{
Cell[2586, 92, 212, 5, 70, "GuideFunctionsSubsection",
 CellID->5174],
Cell[2801, 99, 1292, 40, 70, "InlineGuideFunctionListing",
 CellID->2512]
}, Open  ]],
Cell[CellGroupData[{
Cell[4130, 144, 233, 6, 70, "GuideFunctionsSubsection",
 CellID->6097],
Cell[4366, 152, 1045, 29, 70, "InlineGuideFunctionListing",
 CellID->9551]
}, Open  ]],
Cell[CellGroupData[{
Cell[5448, 186, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->2695],
Cell[5668, 193, 1027, 29, 70, "InlineGuideFunctionListing",
 CellID->21817]
}, Open  ]],
Cell[CellGroupData[{
Cell[6732, 227, 241, 6, 70, "GuideFunctionsSubsection",
 CellID->23492],
Cell[6976, 235, 1055, 30, 70, "InlineGuideFunctionListing",
 CellID->21292]
}, Open  ]],
Cell[CellGroupData[{
Cell[8068, 270, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->20237],
Cell[8151, 273, 820, 23, 70, "InlineGuideFunctionListing",
 CellID->27530]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9020, 302, 56, 1, 70, "GuideTutorialsSection",
 CellID->613],
Cell[9079, 305, 174, 3, 70, "GuideTutorial",
 CellID->123761205],
Cell[9256, 310, 192, 4, 70, "GuideTutorial",
 CellID->870075514],
Cell[9451, 316, 156, 3, 70, "GuideTutorial",
 CellID->519125793],
Cell[9610, 321, 151, 3, 70, "GuideTutorial",
 CellID->385165521],
Cell[9764, 326, 189, 4, 70, "GuideTutorial",
 CellID->115788988],
Cell[9956, 332, 310, 9, 70, "GuideTutorial",
 CellID->11329537]
}, Open  ]],
Cell[CellGroupData[{
Cell[10303, 346, 59, 1, 70, "GuideMoreAboutSection",
 CellID->32389],
Cell[10365, 349, 154, 3, 70, "GuideMoreAbout",
 CellID->236504987],
Cell[10522, 354, 149, 3, 70, "GuideMoreAbout",
 CellID->5628],
Cell[10674, 359, 171, 4, 70, "GuideMoreAbout",
 CellID->5809],
Cell[10848, 365, 173, 4, 70, "GuideMoreAbout",
 CellID->992960892],
Cell[11024, 371, 153, 3, 70, "GuideMoreAboutSub",
 CellID->626949645],
Cell[11180, 376, 168, 4, 70, "GuideMoreAbout",
 CellID->202438413],
Cell[11351, 382, 193, 5, 70, "GuideMoreAbout",
 CellID->102209801]
}, Open  ]],
Cell[CellGroupData[{
Cell[11581, 392, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->302733078],
Cell[11653, 395, 734, 18, 70, "GuideRelatedLinks",
 CellID->133821583]
}, Open  ]],
Cell[12402, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

