(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19751,        666]
NotebookOptionsPosition[     13278,        501]
NotebookOutlinePosition[     16902,        567]
CellTagsIndexPosition[     16859,        564]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Operations on Vectors", "GuideTitle",
 CellID->8182],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents vectors as lists, and never needs to distinguish between row \
and column cases. Vectors in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "can always mix numbers and arbitrary symbolic or algebraic elements",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses state-of-the-art algorithms to bring platform-optimized performance \
to operations on extremely long dense and sparse vectors. "
}], "GuideAbstract",
 CellID->28569],

Cell[CellGroupData[{

Cell["Constructing Vectors", "GuideFunctionsSubsection",
 CellID->14962],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a vector from an expression"
}], "GuideText",
 CellID->14214],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a vector from a function"
}], "GuideText",
 CellID->12527],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a vector of constants"
}], "GuideText",
 CellID->412558891],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a sparse vector from positions and values"
}], "GuideText",
 CellID->26807]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elements of Vectors", "GuideFunctionsSubsection",
 CellID->13194],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of elements in a vector"
}], "GuideText",
 CellID->8705],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extract an element of a vector (",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->14713],

Cell[TextData[{
 Cell[TextData[ButtonBox["Set",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reset an element of a vector (",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["v", "TI"], "[", 
    RowBox[{"[", 
     StyleBox["i", "TI"], "]"}], "]"}], "=", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->7011],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/VectorQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is a vector"
}], "GuideText",
 CellID->18913]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Operations", "GuideFunctionsSubsection",
 CellID->6693],

Cell[TextData[{
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " automatically element-wise: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "+", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["c", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}], "\[LongRightArrow]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["b", "TI"]}], ",", 
      RowBox[{
       StyleBox["c", "TI"], "+", 
       StyleBox["d", "TI"]}]}], "}"}]}]}]], "InlineFormula"]
}], "GuideText",
 CellID->19664],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " scalar dot product"
}], "GuideText",
 CellID->26203],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cross",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cross"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cross"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " vector cross product (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]cross\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->28995],

Cell[TextData[{
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "norm of a vector"
}], "GuideText",
 CellID->17762],

Cell[TextData[{
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total of elements in a vector"
}], "GuideText",
 CellID->14381]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector Space Operations", "GuideFunctionsSubsection",
 CellID->15480997],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorAngle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VectorAngle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "angle between two vectors"
}], "GuideText",
 CellID->81147748],

Cell[TextData[{
 Cell[TextData[ButtonBox["UnitVector",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/UnitVector"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "unit vector along a coordinate direction"
}], "GuideText",
 CellID->360805441],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "normalize a vector to unit length"
}], "GuideText",
 CellID->59926300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Projection",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Projection"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the projection of one vector on another"
}], "GuideText",
 CellID->590175828],

Cell[TextData[{
 Cell[TextData[ButtonBox["Orthogonalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Orthogonalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a Gram-Schmidt orthonormal basis"
}], "GuideText",
 CellID->266765026],

Cell[TextData[{
 Cell[TextData[ButtonBox["KroneckerProduct",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Kronecker outer product"
}], "GuideText",
 CellID->538432378]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying Vectors", "GuideFunctionsSubsection",
 CellID->26946],

Cell[TextData[{
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display in row or column form"
}], "GuideText",
 CellID->29909],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent an arrow in a graphic"
}], "GuideText",
 CellID->1048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Vector Distance Measures \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DistanceAndDissimilarityMeasures"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->89646082],

Cell[TextData[{
 Cell[TextData[ButtonBox["EuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ManhattanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->76849091],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "derivatives of vectors of functions and functions of vectors"
}], "GuideText",
 CellID->26624],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "force any function to thread over lists"
}], "GuideText",
 CellID->22511]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->7954],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "GuideTutorial",
 CellID->4235],

Cell[TextData[ButtonBox["Building Lists from Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BuildingListsFromFunctions"]], "GuideTutorial",
 CellID->1127]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->14633],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAbout",
 CellID->28240],

Cell[TextData[ButtonBox["Operation on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "GuideMoreAbout",\

 CellID->297464918],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->1862],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operations on Vectors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 28.2053980}", "context" -> "", 
    "keywords" -> {
     "1-norm", "2-norm", "angles between vectors", "arrays", 
      "band-diagonal matrices", "city block distance", "column sum", 
      "columns", "compensated summation", "constant array", "cross product", 
      "derivative tensor", "derivatives", "diff", "differentiable", 
      "differentiation", "direction vector", "divergence", "dot product", 
      "elements", "Euclidean distance", "Euclidean norm", "exchange values", 
      "extrema", "Frobenius norm", "gradients", "Gram-Schmidt", 
      "graphics arrow", "grid distance", "hashing", "Hodge star", 
      "immediate assignment", "immediate definition", "immediate value", 
      "implementing listability", "induced matrix norm", "infinity-norm", 
      "inner product norm", "inner products", "interchange values", 
      "Kronecker product", "kross", "law of cosines", "length of list", 
      "length of vector", "lists", "lists as vectors", "Manhattan distance", 
      "Manhattan metric", "matrices", "matrix direct product", 
      "matrix multiplication", "matrix multiply", "matrix norm", 
      "matrix vector multiplication", "metric", "modified Gram-Schmidt", 
      "multiple parts", "multiplication", "multivariate derivative", "nops", 
      "norm", "normalize vector", "normalized vector", "number of elements", 
      "number of terms", "orthogonalization", "orthonormal basis", 
      "orthonormal matrix", "outer product", "parts", "permute values", 
      "perp", "perpendicular vector", "p-norm", "project vector onto vector", 
      "projection", "row sum", "rows", "scalar product", 
      "sequence of elements", "set", "setting values", "size of array", 
      "sparse array", "sparse matrix", "sparse representation", 
      "sparse vector", "sum of array elements", "sum of list", "tables", 
      "tabulation of values", "taxi cab distance", "taxicab distance", 
      "taxicab metric", "tensor derivative", "tensor product", "tensors", 
      "test if vector", "testing for numerical vectors", 
      "testing for vectors", "threading operations over equations", 
      "threading over lists", "total of list", "unitary matrix", 
      "unit vector", "vector", "vector angle", "vector derivative", 
      "vector length", "vector norm", "vector product", "vector projection", 
      "vector space projection", "vectors", "wedge"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica represents vectors as lists, and never needs to distinguish \
between row and column cases. Vectors in Mathematica can always mix numbers \
and arbitrary symbolic or algebraic elements. Mathematica uses \
state-of-the-art algorithms to bring platform-optimized performance to \
operations on extremely long dense and sparse vectors. ", "synonyms" -> {}, 
    "title" -> "Operations on Vectors", "type" -> "Guide", "uri" -> 
    "guide/OperationsOnVectors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->8182],
Cell[680, 28, 526, 14, 70, "GuideAbstract",
 CellID->28569],
Cell[CellGroupData[{
Cell[1231, 46, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->14962],
Cell[1306, 49, 256, 9, 70, "GuideText",
 CellID->14214],
Cell[1565, 60, 253, 9, 70, "GuideText",
 CellID->12527],
Cell[1821, 71, 415, 12, 70, "GuideText",
 CellID->412558891],
Cell[2239, 85, 282, 9, 70, "GuideText",
 CellID->26807]
}, Open  ]],
Cell[CellGroupData[{
Cell[2558, 99, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->13194],
Cell[2632, 102, 250, 9, 70, "GuideText",
 CellID->8705],
Cell[2885, 113, 381, 14, 70, "GuideText",
 CellID->14713],
Cell[3269, 129, 423, 16, 70, "GuideText",
 CellID->7011],
Cell[3695, 147, 261, 9, 70, "GuideText",
 CellID->18913]
}, Open  ]],
Cell[CellGroupData[{
Cell[3993, 161, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->6693],
Cell[4070, 164, 1016, 37, 70, "GuideText",
 CellID->19664],
Cell[5089, 203, 349, 13, 70, "GuideText",
 CellID->26203],
Cell[5441, 218, 501, 17, 70, "GuideText",
 CellID->28995],
Cell[5945, 237, 233, 9, 70, "GuideText",
 CellID->17762],
Cell[6181, 248, 248, 9, 70, "GuideText",
 CellID->14381]
}, Open  ]],
Cell[CellGroupData[{
Cell[6466, 262, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->15480997],
Cell[6547, 265, 404, 12, 70, "GuideText",
 CellID->81147748],
Cell[6954, 279, 418, 12, 70, "GuideText",
 CellID->360805441],
Cell[7375, 293, 408, 12, 70, "GuideText",
 CellID->59926300],
Cell[7786, 307, 422, 12, 70, "GuideText",
 CellID->590175828],
Cell[8211, 321, 421, 12, 70, "GuideText",
 CellID->266765026],
Cell[8635, 335, 413, 12, 70, "GuideText",
 CellID->538432378]
}, Open  ]],
Cell[CellGroupData[{
Cell[9085, 352, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->26946],
Cell[9158, 355, 657, 19, 70, "GuideText",
 CellID->29909],
Cell[9818, 376, 394, 12, 70, "GuideText",
 CellID->1048]
}, Open  ]],
Cell[CellGroupData[{
Cell[10249, 393, 245, 6, 70, "GuideFunctionsSubsection",
 CellID->89646082],
Cell[10497, 401, 953, 24, 70, "InlineGuideFunctionListing",
 CellID->76849091],
Cell[11453, 427, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[11504, 430, 271, 9, 70, "GuideText",
 CellID->26624],
Cell[11778, 441, 260, 9, 70, "GuideText",
 CellID->22511]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12087, 456, 57, 1, 70, "GuideTutorialsSection",
 CellID->7954],
Cell[12147, 459, 149, 3, 70, "GuideTutorial",
 CellID->4235],
Cell[12299, 464, 169, 3, 70, "GuideTutorial",
 CellID->1127]
}, Open  ]],
Cell[CellGroupData[{
Cell[12505, 472, 59, 1, 70, "GuideMoreAboutSection",
 CellID->14633],
Cell[12567, 475, 133, 3, 70, "GuideMoreAbout",
 CellID->28240],
Cell[12703, 480, 180, 5, 70, "GuideMoreAbout",
 CellID->297464918],
Cell[12886, 487, 145, 3, 70, "GuideMoreAbout",
 CellID->1862],
Cell[13034, 492, 202, 4, 70, "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],
Cell[13251, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

