(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8469,        290]
NotebookOptionsPosition[      5495,        205]
NotebookOutlinePosition[      7097,        243]
CellTagsIndexPosition[      7054,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Options Management", "GuideTitle",
 CellID->10555],

Cell[TextData[{
 "Directly integrated into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language is a convenient symbolic options mechanism that allows arbitrary \
sequences of named parameters to be given to both built-in and user-defined \
functions",
 ". "
}], "GuideAbstract",
 CellID->51067963],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["opt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"],
  ButtonBox["->",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"],
  StyleBox[ButtonBox["val",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " an option whose value is evaluated immediately"
}], "GuideText",
 CellID->102463476],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["opt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"], "TI"],
  ButtonBox[":>",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"],
  StyleBox[ButtonBox["val",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " an option whose value is evaluated when it is used"
}], "GuideText",
 CellID->409140639],

Cell["\t", "GuideDelimiterSubsection",
 CellID->114898815],

Cell[CellGroupData[{

Cell["Setting Up Options for Functions", "GuideFunctionsSubsection",
 CellID->1031312373],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetOptions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set up default option values for a function"
}], "GuideText",
 CellID->191903697],

Cell[TextData[{
 Cell[TextData[ButtonBox["OptionsPattern",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OptionsPattern"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a pattern representing an arbitrary sequence of options"
}], "GuideText",
 CellID->8934],

Cell[TextData[{
 Cell[TextData[ButtonBox["OptionValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OptionValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " retrieve values of options while executing a function"
}], "GuideText",
 CellID->18040],

Cell[TextData[{
 Cell[TextData[ButtonBox["FilterRules",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FilterRules"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " filter particular options from a longer list"
}], "GuideText",
 CellID->180149720],

Cell["\t", "GuideDelimiter",
 CellID->386313676],

Cell[TextData[{
 Cell[TextData[ButtonBox["Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Options"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get the options for a function or object with options"
}], "GuideText",
 CellID->173835198],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsoluteOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get explicit values for options that are given as ",
 Cell[TextData[ButtonBox["Automatic",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Automatic"]], "InlineFunctionSans"],
 ", etc."
}], "GuideText",
 CellID->876015290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->7986],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "GuideTutorial",
 CellID->516454528],

Cell[TextData[ButtonBox["Setting Up Functions with Optional Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]], "GuideTutorial",\

 CellID->88719401]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->1539],

Cell[TextData[ButtonBox["Rules and Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "GuideMoreAbout",
 CellID->28765],

Cell[TextData[ButtonBox["Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->12796],

Cell[TextData[ButtonBox["Notebook Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "GuideMoreAbout",
 CellID->401195483]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options Management - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 30.5648334}", "context" -> "", 
    "keywords" -> {
     "absolute options", "automatic options", "default option value", 
      "default options", "defining function", "filter rules", 
      "finding options for output", "finding options for streams", 
      "function options", "function with options", "option value", 
      "option values", "options for streams", "options for symbol", 
      "options pattern", "parsing option value", "pick matched rules", 
      "select rules", "set options"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Directly integrated into the Mathematica language is a convenient \
symbolic options mechanism that allows arbitrary sequences of named \
parameters to be given to both built-in and user-defined functions. ", 
    "synonyms" -> {}, "title" -> "Options Management", "type" -> "Guide", 
    "uri" -> "guide/OptionsManagement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->10555],
Cell[678, 28, 313, 9, 70, "GuideAbstract",
 CellID->51067963],
Cell[994, 39, 453, 16, 70, "GuideText",
 CellID->102463476],
Cell[1450, 57, 478, 16, 70, "GuideText",
 CellID->409140639],
Cell[1931, 75, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->114898815],
Cell[CellGroupData[{
Cell[2014, 80, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->1031312373],
Cell[2106, 83, 276, 9, 70, "GuideText",
 CellID->191903697],
Cell[2385, 94, 431, 11, 70, "GuideText",
 CellID->8934],
Cell[2819, 107, 424, 11, 70, "GuideText",
 CellID->18040],
Cell[3246, 120, 419, 11, 70, "GuideText",
 CellID->180149720],
Cell[3668, 133, 48, 1, 70, "GuideDelimiter",
 CellID->386313676],
Cell[3719, 136, 280, 9, 70, "GuideText",
 CellID->173835198],
Cell[4002, 147, 426, 13, 70, "GuideText",
 CellID->876015290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4477, 166, 57, 1, 70, "GuideTutorialsSection",
 CellID->7986],
Cell[4537, 169, 158, 3, 70, "GuideTutorial",
 CellID->516454528],
Cell[4698, 174, 206, 5, 70, "GuideTutorial",
 CellID->88719401]
}, Open  ]],
Cell[CellGroupData[{
Cell[4941, 184, 58, 1, 70, "GuideMoreAboutSection",
 CellID->1539],
Cell[5002, 187, 147, 3, 70, "GuideMoreAbout",
 CellID->28765],
Cell[5152, 192, 154, 3, 70, "GuideMoreAbout",
 CellID->12796],
Cell[5309, 197, 144, 3, 70, "GuideMoreAbout",
 CellID->401195483]
}, Open  ]],
Cell[5468, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

