(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11976,        404]
NotebookOptionsPosition[      7753,        289]
NotebookOutlinePosition[      9833,        333]
CellTagsIndexPosition[      9790,        330]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Package Bulletproofing", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes it easy to \"bulletproof\" packages, and prevent features of their \
environment from affecting their internal operation."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Localizing Variables \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScopingConstructs"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->732230177],

Cell[TextData[{
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize names of variables"
}], "GuideText",
 CellID->222125072]
}, Open  ]],

Cell[CellGroupData[{

Cell["Namespace Bulletproofing", "GuideFunctionsSubsection",
 CellID->479213560],

Cell[TextData[{
 Cell[TextData[ButtonBox["BeginPackage",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BeginPackage"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "isolate names by declaring a separate context for package functions"
}], "GuideText",
 CellID->327987553],

Cell[TextData[{
 Cell[TextData[ButtonBox["Begin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Begin"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "isolate names in the implementation of a package"
}], "GuideText",
 CellID->60241386],

Cell["\t", "GuideDelimiterSubsection",
 CellID->4923026]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol Protection", "GuideFunctionsSubsection",
 CellID->602908459],

Cell[TextData[{
 Cell[TextData[ButtonBox["Protect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Protect"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "protect a symbol against redefinition"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReadProtected",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadProtected"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "protect against definitions being read"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locked",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Locked"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attribute to prevent protection from being changed"
}], "GuideText",
 CellID->48008587],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation Bulletproofing", "GuideFunctionsSubsection",
 CellID->120832118],

Cell[TextData[{
 Cell[TextData[ButtonBox["Block",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Block"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "block out changes to system or other variables"
}], "GuideText",
 CellID->438110091],

Cell[TextData[{
 Cell[TextData[ButtonBox["BlockRandom",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BlockRandom"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "block out reseeding of pseudorandom generators"
}], "GuideText",
 CellID->214494929],

Cell[TextData[{
 Cell[TextData[ButtonBox["CheckAbort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CheckAbort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbortProtect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbortProtect"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->649120847],

Cell["\t", "GuideDelimiterSubsection",
 CellID->333180515]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version Compatibility", "GuideFunctionsSubsection",
 CellID->862357092],

Cell[TextData[{
 Cell[TextData[ButtonBox["$VersionNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$VersionNumber"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version number for comparisons"
}], "GuideText",
 CellID->207622405],

Cell[TextData[{
 Cell[TextData[ButtonBox["$SystemID",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$SystemID"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "short description of computer system"
}], "GuideText",
 CellID->240283712],

Cell["\t", "GuideDelimiterSubsection",
 CellID->533312660]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Interface Bulletproofing", "GuideFunctionsSubsection",
 CellID->853608546],

Cell[TextData[{
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deploy"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Selectable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Selectable"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Editable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Editable"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Visible",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Visible"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CellContext",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellContext"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->32570]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Stand Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "GuideMoreAbout",
 CellID->27577]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Package Bulletproofing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 30.9867192}", "context" -> "", 
    "keywords" -> {
     "abort protect", "begin package", "block aborts", "block random", 
      "blocks", "catching of aborts", "check abort", "compatibility", 
      "constrained memory", "critical section", "dynamic scoping", 
      "evaluation with limited memory", "evaluation with time constraints", 
      "finite memory", "fluid variables", "hidden", "intercept aborts", 
      "lexical scoping", "local values", "local symbols", 
      "localize random generator", "localize random state", "lock definition",
       "locking cells", "locking notebooks", "memory constrained", 
      "memory constraints", "overwrite protection", "prevent redefinition", 
      "procedure", "protection", "protection of definitions", 
      "read protected", "reset random state", "scoping", "security", 
      "static scoping", "system ID", "temporary values", "time constrained", 
      "time constraints", "uninterruptible code", "unwritable", 
      "version number", "write-protect", "write protection"}, "index" -> True,
     "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica makes it easy to \"bulletproof\" packages, and prevent \
features of their environment from affecting their internal operation.", 
    "synonyms" -> {}, "title" -> "Package Bulletproofing", "type" -> "Guide", 
    "uri" -> "guide/PackageBulletproofing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 238, 6, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[949, 38, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->732230177],
Cell[1177, 45, 252, 9, 70, "GuideText",
 CellID->222125072]
}, Open  ]],
Cell[CellGroupData[{
Cell[1466, 59, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->479213560],
Cell[1549, 62, 304, 9, 70, "GuideText",
 CellID->327987553],
Cell[1856, 73, 270, 9, 70, "GuideText",
 CellID->60241386],
Cell[2129, 84, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->4923026]
}, Open  ]],
Cell[CellGroupData[{
Cell[2222, 90, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->602908459],
Cell[2298, 93, 264, 9, 70, "GuideText",
 CellID->203374175],
Cell[2565, 104, 278, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2846, 115, 274, 9, 70, "GuideText",
 CellID->48008587],
Cell[3123, 126, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[3218, 132, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->120832118],
Cell[3302, 135, 269, 9, 70, "GuideText",
 CellID->438110091],
Cell[3574, 146, 426, 12, 70, "GuideText",
 CellID->214494929],
Cell[4003, 160, 856, 23, 70, "InlineGuideFunctionListing",
 CellID->649120847],
Cell[4862, 185, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->333180515]
}, Open  ]],
Cell[CellGroupData[{
Cell[4957, 191, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->862357092],
Cell[5037, 194, 321, 11, 70, "GuideText",
 CellID->207622405],
Cell[5361, 207, 267, 9, 70, "GuideText",
 CellID->240283712],
Cell[5631, 218, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->533312660]
}, Open  ]],
Cell[CellGroupData[{
Cell[5726, 224, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->853608546],
Cell[5818, 227, 1310, 35, 70, "InlineGuideFunctionListing",
 CellID->32570]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7177, 268, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7242, 271, 155, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7400, 276, 159, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7562, 281, 149, 3, 70, "GuideMoreAbout",
 CellID->27577]
}, Open  ]],
Cell[7726, 287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

