(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17861,        534]
NotebookOptionsPosition[     13408,        419]
NotebookOutlinePosition[     15842,        469]
CellTagsIndexPosition[     15799,        466]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Palettes", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", a palette is just a notebook with a collection of controls such as \
buttons. A uniquely powerful consequence of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " unified design is that a symbolic specification, easily built up by a \
program, can immediately be deployed as an active palette. "
}], "GuideAbstract",
 CellID->199917335],

Cell[TextData[{
 StyleBox[ButtonBox["Palettes \[FilledRightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " menu of built-in and custom-added palettes"
}], "GuideText",
 CellID->21445434],

Cell[TextData[{
 StyleBox[ButtonBox["Install Palette",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InstallPalette"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " add a palette to the ",
 StyleBox[ButtonBox["Palettes",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 " menu"
}], "GuideText",
 CellID->38062342],

Cell["\t", "GuideDelimiter",
 CellID->130084180],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreatePalette",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreatePalette"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a palette from an expression, and open it on screen"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiterSubsection",
 CellID->334717161],

Cell[CellGroupData[{

Cell["Palette Elements", "GuideFunctionsSubsection",
 CellID->61616993],

Cell[TextData[{
 Cell[TextData[ButtonBox["Button",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Button"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a button with any label and any action"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["PasteButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PasteButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a button which pastes its contents at the current selection"
}], "GuideText",
 CellID->409308369],

Cell[TextData[{
 Cell[TextData[ButtonBox["Appearance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Appearance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " option to specify button appearance (e.g. ",
 Cell[BoxData["\"\<Palette\>\""], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->14628295],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNameSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileNameSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorSlider",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorSlider"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->20401367],

Cell[TextData[{
 Cell[TextData[ButtonBox["PaletteNotebook",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic representation of a complete palette"
}], "GuideText",
 CellID->483073005]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout", "GuideFunctionsSubsection",
 CellID->662668620],

Cell[TextData[{
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Spacings",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Spacings"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenerView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OpenerView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MenuView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MenuView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->53682032]
}, Open  ]],

Cell[CellGroupData[{

Cell["Annotation & Styling", "GuideFunctionsSubsection",
 CellID->59395504],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Labeled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Labeled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Panel",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Panel"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->386004463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Window Options \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/WindowProperties"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->288204152],

Cell[TextData[{
 Cell[TextData[ButtonBox["WindowTitle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WindowTitle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WindowMargins",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WindowMargins"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WindowOpacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WindowOpacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClosingAutoSave",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClosingAutoSave"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WindowProperties"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Palette Actions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelNotebookProgramming"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->353238585],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetOptions"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookApply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookApply"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Print"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreateDocument",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateDocument"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NotebookFind",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotebookFind"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->204162454]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Custom Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAbout",
 CellID->237902403],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Palettes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 33.1273990}", "context" -> "", 
    "keywords" -> {
     "2D layout", "background panel", "balloon help", "button", 
      "choose color", "closing auto save", "color chooser", "color control", 
      "color dialog", "color palette", "color picker", "color picking tool", 
      "color selection dialog", "color selector", "color setter", 
      "color slider", "color swatch", "color wheel", "control palettes", 
      "create document", "create palette", "display", "display panel", 
      "display style", "file browser", "file chooser", "file dialog", 
      "file name input", "file name setter", "file picker", 
      "file-selection dialog", "file setter", "font size", "hyperlink", 
      "margins", "menu view", "mouse over", "notebook apply", "notebook find",
       "notebook search", "notebook seek", "notebooks", "opaque", 
      "open viewer", "opener view", "options for streams", "palette notebook",
       "paste button", "popup box", "popup menu", "positioning", 
      "reset medium", "screen tip", "set options", "status area", "styles", 
      "tab selector", "tab view", "tab view control", "table", 
      "tabular layout", "tabulation", "text color", "title", "tooltip", 
      "translucent", "transparent", "window margins", "window opacity", 
      "window title"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In Mathematica, a palette is just a notebook with a collection of \
controls such as buttons. A uniquely powerful consequence of Mathematica's \
unified design is that a symbolic specification, easily built up by a \
program, can immediately be deployed as an active palette. ", 
    "synonyms" -> {}, "title" -> "Palettes", "type" -> "Guide", "uri" -> 
    "guide/Palettes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[672, 28, 425, 12, 70, "GuideAbstract",
 CellID->199917335],
Cell[1100, 42, 278, 8, 70, "GuideText",
 CellID->21445434],
Cell[1381, 52, 370, 12, 70, "GuideText",
 CellID->38062342],
Cell[1754, 66, 48, 1, 70, "GuideDelimiter",
 CellID->130084180],
Cell[1805, 69, 437, 11, 70, "GuideText",
 CellID->203374175],
Cell[2245, 82, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->334717161],
Cell[CellGroupData[{
Cell[2328, 87, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->61616993],
Cell[2402, 90, 409, 12, 70, "GuideText",
 CellID->1463276848],
Cell[2814, 104, 439, 12, 70, "GuideText",
 CellID->409308369],
Cell[3256, 118, 472, 13, 70, "GuideText",
 CellID->14628295],
Cell[3731, 133, 913, 23, 70, "InlineGuideFunctionListing",
 CellID->20401367],
Cell[4647, 158, 433, 12, 70, "GuideText",
 CellID->483073005]
}, Open  ]],
Cell[CellGroupData[{
Cell[5117, 175, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->662668620],
Cell[5182, 178, 2087, 53, 70, "InlineGuideFunctionListing",
 CellID->53682032]
}, Open  ]],
Cell[CellGroupData[{
Cell[7306, 236, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->59395504],
Cell[7384, 239, 2088, 53, 70, "InlineGuideFunctionListing",
 CellID->386004463]
}, Open  ]],
Cell[CellGroupData[{
Cell[9509, 297, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->288204152],
Cell[9730, 304, 1209, 32, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[10976, 341, 230, 5, 70, "GuideFunctionsSubsection",
 CellID->353238585],
Cell[11209, 348, 1420, 39, 70, "InlineGuideFunctionListing",
 CellID->204162454]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12678, 393, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[12743, 396, 161, 3, 70, "GuideMoreAbout",
 CellID->237902403],
Cell[12907, 401, 155, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[13065, 406, 140, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[13208, 411, 158, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[13381, 417, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

