(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12029,        391]
NotebookOptionsPosition[      7983,        288]
NotebookOutlinePosition[     10455,        340]
CellTagsIndexPosition[     10412,        337]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Parts of Expressions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic architecture allows immediate generalization of \
part-oriented list operations to arbitrary expressions\[LongDash]supporting \
operations both on individual parts, and on collections of parts at specified \
levels in expression trees."
}], "GuideAbstract",
 CellID->18417588],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[{
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 ")",
 " ",
 " get any part of an expression (reset with ",
 Cell[BoxData["="], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["First",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/First"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Last",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Last"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Most",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Most"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Extract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extract"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25006117],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "replace numbered parts of an expression"
}], "GuideText",
 CellID->412649469],

Cell[TextData[{
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Prepend",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prepend"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Insert"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Delete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Delete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteCases"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28492312],

Cell["\t", "GuideDelimiter",
 CellID->30895805],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the positions of any pattern in an expression"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cases of any pattern in an expression"
}], "GuideText",
 CellID->10147626],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply a function at particular positions in an expression"
}], "GuideText",
 CellID->434099509],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ") \[LongDash] apply a function at specified levels in an expression"
}], "GuideText",
 CellID->410731046],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["//@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAll"]], "InlineFunctionSans"],
 ") \[LongDash] apply a function to all parts of an expression"
}], "GuideText",
 CellID->44038623],

Cell["\t", "GuideDelimiter",
 CellID->598679911],

Cell[TextData[{
 Cell[TextData[ButtonBox["Heads",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Heads"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for specifying whether to include heads"
}], "GuideText",
 CellID->219790311]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "GuideTutorial",
 CellID->97480921],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "GuideTutorial",\

 CellID->188144983],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingListsByTheirIndices"]], "GuideTutorial",
 CellID->361274822],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "GuideTutorial",
 CellID->492147115]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Parts of Lists & Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parts of Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 34.4711834}", "context" -> "", 
    "keywords" -> {
     "all but last", "appending", "apply function to all parts", 
      "apply to every part", "applying functions to elements of lists", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices", "beginning of list", 
      "block matrices", "cdr", "changing parts", "criteria", "delete cases", 
      "deleting elements", "discard elements", "drop first element", 
      "drop last", "elements", "extraction of sublists", 
      "include function names in levels", "include tags in levels", "indices",
       "insert element in list", "join lists", "length of list", "levels", 
      "map all", "map at", "multiple parts", "nops", "number of elements", 
      "number of terms", "parts", "patterns", 
      "picking out sequences of elements in lists", 
      "prepend elements to lists", "remove first element in list", 
      "removing elements from lists", 
      "removing elements that match a pattern", "replace part", 
      "replacements", "rows", "segments of lists", "sequence of elements", 
      "shortening lists", "size of array", "stride", "submatrices", 
      "tail of list", "truncate list"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's unified symbolic architecture allows immediate \
generalization of part-oriented list operations to arbitrary \
expressions--supporting operations both on individual parts, and on \
collections of parts at specified levels in expression trees.", 
    "synonyms" -> {}, "title" -> "Parts of Expressions", "type" -> "Guide", 
    "uri" -> "guide/PartsOfExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[684, 28, 363, 8, 70, "GuideAbstract",
 CellID->18417588],
Cell[1050, 38, 764, 31, 70, "GuideText",
 CellID->203374175],
Cell[1817, 71, 1591, 47, 70, "InlineGuideFunctionListing",
 CellID->25006117],
Cell[3411, 120, 274, 9, 70, "GuideText",
 CellID->412649469],
Cell[3688, 131, 1011, 29, 70, "InlineGuideFunctionListing",
 CellID->28492312],
Cell[4702, 162, 47, 1, 70, "GuideDelimiter",
 CellID->30895805],
Cell[4752, 165, 280, 9, 70, "GuideText",
 CellID->1463276848],
Cell[5035, 176, 264, 9, 70, "GuideText",
 CellID->10147626],
Cell[5302, 187, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[5353, 190, 280, 9, 70, "GuideText",
 CellID->434099509],
Cell[5636, 201, 349, 10, 70, "GuideText",
 CellID->410731046],
Cell[5988, 213, 351, 10, 70, "GuideText",
 CellID->44038623],
Cell[6342, 225, 48, 1, 70, "GuideDelimiter",
 CellID->598679911],
Cell[6393, 228, 269, 9, 70, "GuideText",
 CellID->219790311]
}, Open  ]],
Cell[CellGroupData[{
Cell[6699, 242, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6764, 245, 156, 3, 70, "GuideTutorial",
 CellID->97480921],
Cell[6923, 250, 206, 5, 70, "GuideTutorial",
 CellID->188144983],
Cell[7132, 257, 188, 4, 70, "GuideTutorial",
 CellID->361274822],
Cell[7323, 263, 201, 4, 70, "GuideTutorial",
 CellID->492147115]
}, Open  ]],
Cell[CellGroupData[{
Cell[7561, 272, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7626, 275, 156, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7785, 280, 156, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[7956, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

