(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9731,        323]
NotebookOptionsPosition[      5861,        224]
NotebookOutlinePosition[      8198,        272]
CellTagsIndexPosition[      8155,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Pattern Matching Functions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Pattern matching makes possible some of the most succinct and elegant \
programs in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language\[LongDash]immediately compressing large numbers of conditional \
cases into simple, readable and efficient pattern specifications."
}], "GuideAbstract",
 CellID->64604708],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a list of elements matching a pattern"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "positions of elements matching a pattern"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a count of occurrences of a pattern"
}], "GuideText",
 CellID->199708145],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " replace all occurrences of a pattern"
}], "GuideText",
 CellID->136231768],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeleteCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteCases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "delete all occurrences of a pattern"
}], "GuideText",
 CellID->40310056],

Cell["\t", "GuideDelimiter",
 CellID->89382726],

Cell[TextData[{
 Cell[TextData[ButtonBox["Set",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["SetDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[":=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 ") \[LongDash] define transformations for patterns"
}], "GuideText",
 CellID->336764952],

Cell["\t", "GuideDelimiter",
 CellID->868858619],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if any member of a list matches a pattern"
}], "GuideText",
 CellID->260725779],

Cell[TextData[{
 Cell[TextData[ButtonBox["FreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FreeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if an expression is free of a pattern"
}], "GuideText",
 CellID->344724193],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatchQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression matches a pattern"
}], "GuideText",
 CellID->331045643],

Cell[CellGroupData[{

Cell["Patterns for Part Specifications", "GuideFunctionsSubsection",
 CellID->382948744],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->28626007]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "GuideTutorial",
 CellID->423030827],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TestingAndSearchingListElements"]], "GuideTutorial",
 CellID->482403833]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Pattern Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pattern Matching Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 38.2525302}", "context" -> "", 
    "keywords" -> {
     "absent from expression", "absent from list", "assign value", 
      "changing parts", "contains", "controlled transformations", "criteria", 
      "defining values", "definitions", "delayed assignment", 
      "delayed definitions", "delete cases", "depends on", 
      "evaluation at a point", "exchange values", "immediate assignment", 
      "immediate definition", "immediate value", "indices", 
      "interchange values", "levels", "list member", "membership test", 
      "multiple parts", "number of occurrences", "parts", 
      "pattern applicability", "pattern test", "patterns", "permute values", 
      "position-value pairs", "present in list", 
      "removing elements that match a pattern", "replace all", "replace part",
       "replacement", "rules", "search", "set", "set delayed", "SetDelayed", 
      "setting values", "sparse array", "sparse matrix", 
      "sparse representation", "sparse vector", "substitution", 
      "temporary binding", "test for elements in lists", 
      "test for pattern match", "testing for matching of patterns", 
      "testing for presence", "unevaluated expressions", "where"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Pattern matching makes possible some of the most succinct and elegant \
programs in the Mathematica language--immediately compressing large numbers \
of conditional cases into simple, readable and efficient pattern \
specifications.", "synonyms" -> {}, "title" -> "Pattern Matching Functions", 
    "type" -> "Guide", "uri" -> "guide/PatternMatchingFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 341, 8, 70, "GuideAbstract",
 CellID->64604708],
Cell[1034, 38, 260, 9, 70, "GuideText",
 CellID->203374175],
Cell[1297, 49, 270, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1570, 60, 258, 9, 70, "GuideText",
 CellID->199708145],
Cell[1831, 71, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1882, 74, 393, 13, 70, "GuideText",
 CellID->136231768],
Cell[2278, 89, 269, 9, 70, "GuideText",
 CellID->40310056],
Cell[2550, 100, 47, 1, 70, "GuideDelimiter",
 CellID->89382726],
Cell[2600, 103, 585, 18, 70, "GuideText",
 CellID->336764952],
Cell[3188, 123, 48, 1, 70, "GuideDelimiter",
 CellID->868858619],
Cell[3239, 126, 273, 9, 70, "GuideText",
 CellID->260725779],
Cell[3515, 137, 265, 9, 70, "GuideText",
 CellID->344724193],
Cell[3783, 148, 269, 9, 70, "GuideText",
 CellID->331045643],
Cell[CellGroupData[{
Cell[4077, 161, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->382948744],
Cell[4168, 164, 752, 20, 70, "InlineGuideFunctionListing",
 CellID->28626007]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4969, 190, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5034, 193, 197, 4, 70, "GuideTutorial",
 CellID->423030827],
Cell[5234, 199, 188, 4, 70, "GuideTutorial",
 CellID->482403833]
}, Open  ]],
Cell[CellGroupData[{
Cell[5459, 208, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5524, 211, 145, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[5672, 216, 147, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[5834, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

