(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19570,        659]
NotebookOptionsPosition[     13738,        509]
NotebookOutlinePosition[     16804,        568]
CellTagsIndexPosition[     16761,        565]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Patterns", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "One of the unique strengths of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s core language is its powerful and succinct\[LongDash]yet highly readable\
\[LongDash]symbolic pattern language. Convenient both for immediate use in \
individual functions, and for systematic large-scale programming, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s pattern language generalizes concepts like regular expressions to \
describe general patterns for arbitrary symbolic structures."
}], "GuideAbstract",
 CellID->833271770],

Cell[CellGroupData[{

Cell["Basic Pattern Objects", "GuideFunctionsSubsection",
 CellID->340622827],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blank"], " "}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any expression (a \"blank\" to be filled in)"
}], "GuideText",
 CellID->551003990],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any expression, to be referred to as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->35711102],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["__",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"], " "}]], "InlineGuideFunction"],
 ", ",
 Cell[TextData[ButtonBox["___",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankNullSequence"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any sequence of expressions (one or more, zero or more)"
}], "GuideText",
 CellID->163946055]
}, Open  ]],

Cell[CellGroupData[{

Cell["Composite Patterns", "GuideFunctionsSubsection",
 CellID->142423009],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"],
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"],
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Alternatives",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Alternatives"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any of several alternatives"
}], "GuideText",
 CellID->383085636],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Repeated"], "TI"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Repeated"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Repeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 ")",
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RepeatedNull"], "TI"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RepeatedNull"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["RepeatedNull",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RepeatedNull"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a pattern to be repeated"
}], "GuideText",
 CellID->137123447],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Pattern",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pattern"]], "InlineFunctionSans"],
 ") \[LongDash] an arbitrary pattern, to be referred to as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->152969338],

Cell[TextData[{
 Cell[TextData[ButtonBox["Except",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Except"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "anything except a specified pattern"
}], "GuideText",
 CellID->643959581],

Cell[TextData[{
 Cell[TextData[ButtonBox["Longest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Longest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Shortest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Shortest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "longest, shortest possible matches"
}], "GuideText",
 CellID->54334204],

Cell[TextData[{
 Cell[TextData[ButtonBox["OptionsPattern",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OptionsPattern"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PatternSequence",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PatternSequence"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Verbatim",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Verbatim"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldPattern",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldPattern"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->35915091]
}, Open  ]],

Cell[CellGroupData[{

Cell["Restrictions on Patterns", "GuideFunctionsSubsection",
 CellID->145428350],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"],
  StyleBox[ButtonBox["h",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pattern with a specified head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " (e.g. ",
 Cell[BoxData[
  RowBox[{"_", 
   ButtonBox["Integer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integer"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->174954944],

Cell[TextData[{
 Cell[TextData[ButtonBox["Condition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " condition on a pattern (e.g. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x_", "TI"], "/;", 
   RowBox[{
    StyleBox["x", "TI"], ">", "7"}]}]], "InlineMath"],
 ")"
}], "GuideText",
 CellID->237909929],

Cell[TextData[{
 Cell[TextData[ButtonBox["PatternTest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PatternTest"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["?",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PatternTest"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pattern with a function test (e.g. ",
 Cell[BoxData[
  RowBox[{"_", "?", 
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->12569843]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern Defaults", "GuideFunctionsSubsection",
 CellID->17321060],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"],
  StyleBox[ButtonBox["e",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Optional",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Optional"]], "InlineFunctionSans"],
 ") \[LongDash] pattern that defaults to ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " if omitted"
}], "GuideText",
 CellID->130804172],

Cell[TextData[{
 Cell[TextData[ButtonBox["_.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Optional"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Optional",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Optional"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pattern with pre-defined default"
}], "GuideText",
 CellID->353370801],

Cell[TextData[{
 Cell[TextData[ButtonBox["Default",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Default"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pre-defined default arguments for a function"
}], "GuideText",
 CellID->285720229]
}, Open  ]],

Cell[CellGroupData[{

Cell["Attributes Affecting Patterns", "GuideFunctionsSubsection",
 CellID->688443581],

Cell[TextData[{
 Cell[TextData[ButtonBox["Orderless",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Orderless"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Flat",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flat"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OneIdentity",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OneIdentity"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15491400],

Cell["\t", "GuideDelimiterSubsection",
 CellID->362360289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["String Patterns \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->325137171],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic string pattern"
}], "GuideText",
 CellID->331466100],

Cell["\t", "GuideDelimiterSubsection",
 CellID->297321344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Pattern Matching Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PatternMatchingFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->523630836],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatchQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PatternMatchingFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->655251687]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Introduction to Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Introduction-Patterns"]], "GuideTutorial",
 CellID->225218102],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsAndTransformationRules"]], "GuideTutorial",
 CellID->231261676]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideMoreAbout",
 CellID->15169800]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 38.9556732}", "context" -> "", 
    "keywords" -> {
     "applicability of transformation rules", "avoiding matches", 
      "colon operator", "complementary patterns", "conditions", "constraints",
       "criteria", "default arguments", "default value", "default values", 
      "defining function", "disabling patterns", 
      "disambiguating pattern matches", "domain", "ellipsis", 
      "excluded patterns", "function with options", "greedy match", 
      "hold pattern", "idempotence", "idempotent", "indices", "integers", 
      "levels", "literal patterns", "longest pattern match", 
      "longest sequence", "match sequentially", "matching", "named pattern", 
      "non-greedy match", "number of occurrences", "one identity", 
      "one-identity", "one or more", "one-or-more", "optional argument", 
      "optional parameters", "optional value", "options pattern", "parts", 
      "pattern", "pattern condition", "pattern label", "pattern mark", 
      "pattern name", "pattern sequence", "pattern test", "patterns", 
      "patterns for string", "priorities on pattern matches", "provided that",
       "question mark", "reference to pattern", "regular expression", 
      "repeated expression", "repeated null", "RepeatedNull", 
      "repeated pattern", "restricted pattern", "restriction", 
      "restrictions on transformation rules", "rules", "search", 
      "sequence of patterns", "shortest pattern match", "slash-semi", 
      "string expression", "string pattern", "templates", 
      "test for pattern match", "testing for matching of patterns", 
      "testing for numbers", "testing for numerical expressions", 
      "transformation rules", "unevaluated expressions", 
      "unevaluated patterns", "vertical bar", "whenever", "where", 
      "zero or more", "zero or more patterns"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "One of the unique strengths of Mathematica's core language is its \
powerful and succinct--yet highly readable--symbolic pattern language. \
Convenient both for immediate use in individual functions, and for systematic \
large-scale programming, Mathematica's pattern language generalizes concepts \
like regular expressions to describe general patterns for arbitrary symbolic \
structures.", "synonyms" -> {}, "title" -> "Patterns", "type" -> "Guide", 
    "uri" -> "guide/Patterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[672, 28, 550, 12, 70, "GuideAbstract",
 CellID->833271770],
Cell[CellGroupData[{
Cell[1247, 44, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->340622827],
Cell[1327, 47, 284, 10, 70, "GuideText",
 CellID->551003990],
Cell[1614, 59, 407, 15, 70, "GuideText",
 CellID->35711102],
Cell[2024, 76, 435, 14, 70, "GuideText",
 CellID->163946055]
}, Open  ]],
Cell[CellGroupData[{
Cell[2496, 95, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->142423009],
Cell[2573, 98, 774, 27, 70, "GuideText",
 CellID->383085636],
Cell[3350, 127, 852, 32, 70, "GuideText",
 CellID->137123447],
Cell[4205, 161, 602, 20, 70, "GuideText",
 CellID->152969338],
Cell[4810, 183, 260, 9, 70, "GuideText",
 CellID->643959581],
Cell[5073, 194, 677, 19, 70, "GuideText",
 CellID->54334204],
Cell[5753, 215, 1133, 29, 70, "InlineGuideFunctionListing",
 CellID->35915091]
}, Open  ]],
Cell[CellGroupData[{
Cell[6923, 249, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->145428350],
Cell[7006, 252, 557, 22, 70, "GuideText",
 CellID->174954944],
Cell[7566, 276, 514, 19, 70, "GuideText",
 CellID->237909929],
Cell[8083, 297, 542, 19, 70, "GuideText",
 CellID->12569843]
}, Open  ]],
Cell[CellGroupData[{
Cell[8662, 321, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->17321060],
Cell[8736, 324, 589, 21, 70, "GuideText",
 CellID->130804172],
Cell[9328, 347, 383, 13, 70, "GuideText",
 CellID->353370801],
Cell[9714, 362, 271, 9, 70, "GuideText",
 CellID->285720229]
}, Open  ]],
Cell[CellGroupData[{
Cell[10022, 376, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->688443581],
Cell[10110, 379, 603, 17, 70, "InlineGuideFunctionListing",
 CellID->15491400],
Cell[10716, 398, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->362360289]
}, Open  ]],
Cell[CellGroupData[{
Cell[10811, 404, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->325137171],
Cell[11031, 411, 263, 8, 70, "GuideText",
 CellID->331466100],
Cell[11297, 421, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->297321344]
}, Open  ]],
Cell[CellGroupData[{
Cell[11392, 427, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->523630836],
Cell[11635, 435, 1020, 30, 70, "InlineGuideFunctionListing",
 CellID->655251687]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12704, 471, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[12769, 474, 164, 3, 70, "GuideTutorial",
 CellID->225218102],
Cell[12936, 479, 185, 4, 70, "GuideTutorial",
 CellID->231261676]
}, Open  ]],
Cell[CellGroupData[{
Cell[13158, 488, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[13223, 491, 149, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[13375, 496, 158, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[13536, 501, 160, 3, 70, "GuideMoreAbout",
 CellID->15169800]
}, Open  ]],
Cell[13711, 507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

