(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20292,        647]
NotebookOptionsPosition[     13951,        481]
NotebookOutlinePosition[     17318,        544]
CellTagsIndexPosition[     17275,        541]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Plotting Options", "GuideTitle",
 CellID->28942],

Cell[TextData[{
 "With its core symbolic paradigm and immediate access to sophisticated \
numerical, symbolic and geometric algorithms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to provide a uniquely flexible and unified framework for creating \
perceptually powerful graphics from functions and data\[LongDash]and for \
algorithmically highlighting features while maintaining aesthetic integrity."
}], "GuideAbstract",
 CellID->97280426],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotStyle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "styles for points, curves and surfaces"
}], "GuideText",
 CellID->24593],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotMarkers",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotMarkers"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "markers for discrete data points"
}], "GuideText",
 CellID->530],

Cell[CellGroupData[{

Cell["Joining", "GuideFunctionsSubsection",
 CellID->91099291],

Cell[TextData[{
 Cell[TextData[ButtonBox["Joined",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Joined"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to join points to make lines"
}], "GuideText",
 CellID->827559443]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filling", "GuideFunctionsSubsection",
 CellID->14161],

Cell[TextData[{
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "what filling to add under points, curves and surfaces"
}], "GuideText",
 CellID->23234],

Cell[TextData[{
 Cell[TextData[ButtonBox["FillingStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FillingStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClippingStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClippingStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BoundaryStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->10258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Coloring \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Colors"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21926],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a function for coloring curves or surfaces"
}], "GuideText",
 CellID->5906],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorRules"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorFunctionScaling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Colors"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5191]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mesh Display", "GuideFunctionsSubsection",
 CellID->14443],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mesh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mesh"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "what mesh lines, points, etc. to include"
}], "GuideText",
 CellID->6188],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeshStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MeshStyle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the style for mesh lines, points, etc."
}], "GuideText",
 CellID->30227],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeshShading",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeshShading"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "array of shadings for mesh patches"
}], "GuideText",
 CellID->32719],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeshFunctions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeshFunctions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "functions to define families of mesh lines, etc."
}], "GuideText",
 CellID->26484]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contour Plots", "GuideFunctionsSubsection",
 CellID->5224],

Cell[TextData[{
 Cell[TextData[ButtonBox["Contours",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Contours"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ContourStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourStyle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ContourShading",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourShading"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ContourLabels",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourLabels"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->19093]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Plotting Region \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PlottingAndImageRegions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->30435],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotRange"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "range of values to include in the plot"
}], "GuideText",
 CellID->333570732],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general function to define the plotting region"
}], "GuideText",
 CellID->13224]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Discontinuities", "GuideFunctionsSubsection",
 CellID->28139257],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exclusions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Exclusions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how and where to check for discontinuities and excluded regions"
}], "GuideText",
 CellID->517756460],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExclusionsStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExclusionsStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how to render asymptotes, excluded regions, etc."
}], "GuideText",
 CellID->113934943]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sampling & Adaptivity", "GuideFunctionsSubsection",
 CellID->3582],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotPoints",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotPoints"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of initial sample points for each variable"
}], "GuideText",
 CellID->8867],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaxRecursion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MaxRecursion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "maximum level of recursive subdivision"
}], "GuideText",
 CellID->8627],

Cell[TextData[{
 Cell[TextData[ButtonBox["PerformanceGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to try to optimize for speed or for quality"
}], "GuideText",
 CellID->49211883]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Rendering", "GuideFunctionsSubsection",
 CellID->154032506],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolationOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " how to join points in 2D and 3D (0 for steps, 1 for lines, etc.)"
}], "GuideText",
 CellID->306834592],

Cell[TextData[{
 Cell[TextData[ButtonBox["DataRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DataRange"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaxPlotPoints",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->159218501]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->22005],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "GuideTutorial",
 CellID->639205235]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->16589],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->20540],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "GuideMoreAbout",
 CellID->367325343]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1302916597],

Cell[TextData[{
 ButtonBox["Demonstrations related to Plotting Options",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Blend+\
OR+BoundaryStyle+OR+ClippingStyle+OR+ColorData+OR+ColorFunction+OR+\
ColorFunctionScaling+OR+ColorRules+OR+ContourLabels+OR+Contours+OR+\
ContourShading+OR+ContourStyle+OR+DataRange+OR+Exclusions+OR+ExclusionsStyle+\
OR+Filling+OR+FillingStyle+OR+InterpolationOrder+OR+Joined+OR+MaxPlotPoints+\
OR+MaxRecursion+OR+Mesh+OR+MeshFunctions+OR+MeshShading+OR+MeshStyle+OR+\
PerformanceGoal+OR+PlotMarkers+OR+PlotPoints+OR+PlotRange+OR+PlotStyle+OR+\
RegionFunction)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->279578689]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plotting Options - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 40.3307084}", "context" -> "", 
    "keywords" -> {
     "adaptive sampling", "autoscaling in plots", "blend", 
      "boundary of plots", "boundary style", "clipping style", "color blends",
       "color data", "color filling", "color function", 
      "color function scaling", "color gradients", "color interpolation", 
      "color lines", "color lookup table", "color map", "color of curves", 
      "color of lines", "color palette", "color region in graphics", 
      "color rules", "color space", "color spectrum", "color values", 
      "colormap", "contour areas", "contour filling", "contour labels", 
      "contour levels", "contour regions coloring", "contour shading", 
      "contour style", "contour thickness", "ContourLevels", "curve samples", 
      "darker", "dashed lines", "dashing", "data range", "exclusions style", 
      "fill area", "fill between contours", "filling style", 
      "function sampling", "graphics", "graphics range", "grid", 
      "interpolation order", "lighter", "limits of plots", "line color", 
      "max plot points", "max recursion", "maximal recursion", 
      "maximum plotting points", "maximum recursion", "mesh functions", 
      "mesh shading", "mesh style", "mixing colors", "objective goal", 
      "optimization for accuracy", "optimization for speed", 
      "optimization goal", "order of interpolation", "performance goal", 
      "plot markers", "plot points", "plot range", "plot style", 
      "plotting points", "points to sample", "points to sample in plots", 
      "points to sample on curves", "quality goal", "quality target", 
      "range for x axis", "range for y axis", "range of data", 
      "range of data values", "range of graphics", "ranges of coordinates", 
      "region function", "rescale values", "rulings on surfaces", 
      "sampling distance", "sampling in plots", "shading", "spectrum", 
      "speed accuracy objective", "speed accuracy trade-off", 
      "style of contour lines", "style of curves", "style of lines", 
      "styles of multiple curves", "truncate values", "volume slice", 
      "volumetric slice", "zoom in plot"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "With its core symbolic paradigm and immediate access to sophisticated \
numerical, symbolic and geometric algorithms, Mathematica is able to provide \
a uniquely flexible and unified framework for creating perceptually powerful \
graphics from functions and data--and for algorithmically highlighting \
features while maintaining aesthetic integrity.", "synonyms" -> {}, "title" -> 
    "Plotting Options", "type" -> "Guide", "uri" -> 
    "guide/PlottingOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->28942],
Cell[676, 28, 459, 9, 70, "GuideAbstract",
 CellID->97280426],
Cell[1138, 39, 265, 9, 70, "GuideText",
 CellID->24593],
Cell[1406, 50, 406, 12, 70, "GuideText",
 CellID->530],
Cell[CellGroupData[{
Cell[1837, 66, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->91099291],
Cell[1902, 69, 406, 12, 70, "GuideText",
 CellID->827559443]
}, Open  ]],
Cell[CellGroupData[{
Cell[2345, 86, 59, 1, 70, "GuideFunctionsSubsection",
 CellID->14161],
Cell[2407, 89, 421, 12, 70, "GuideText",
 CellID->23234],
Cell[2831, 103, 1063, 26, 70, "InlineGuideFunctionListing",
 CellID->10258]
}, Open  ]],
Cell[CellGroupData[{
Cell[3931, 134, 198, 5, 70, "GuideFunctionsSubsection",
 CellID->21926],
Cell[4132, 141, 276, 9, 70, "GuideText",
 CellID->5906],
Cell[4411, 152, 1324, 35, 70, "InlineGuideFunctionListing",
 CellID->5191]
}, Open  ]],
Cell[CellGroupData[{
Cell[5772, 192, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->14443],
Cell[5839, 195, 256, 9, 70, "GuideText",
 CellID->6188],
Cell[6098, 206, 265, 9, 70, "GuideText",
 CellID->30227],
Cell[6366, 217, 410, 12, 70, "GuideText",
 CellID->32719],
Cell[6779, 231, 428, 12, 70, "GuideText",
 CellID->26484]
}, Open  ]],
Cell[CellGroupData[{
Cell[7244, 248, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->5224],
Cell[7311, 251, 1111, 30, 70, "InlineGuideFunctionListing",
 CellID->19093]
}, Open  ]],
Cell[CellGroupData[{
Cell[8459, 286, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->30435],
Cell[8684, 293, 269, 9, 70, "GuideText",
 CellID->333570732],
Cell[8956, 304, 428, 12, 70, "GuideText",
 CellID->13224]
}, Open  ]],
Cell[CellGroupData[{
Cell[9421, 321, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->28139257],
Cell[9503, 324, 441, 12, 70, "GuideText",
 CellID->517756460],
Cell[9947, 338, 436, 12, 70, "GuideText",
 CellID->113934943]
}, Open  ]],
Cell[CellGroupData[{
Cell[10420, 355, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->3582],
Cell[10495, 358, 277, 9, 70, "GuideText",
 CellID->8867],
Cell[10775, 369, 270, 9, 70, "GuideText",
 CellID->8627],
Cell[11048, 380, 293, 9, 70, "GuideText",
 CellID->49211883]
}, Open  ]],
Cell[CellGroupData[{
Cell[11378, 394, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->154032506],
Cell[11451, 397, 308, 8, 70, "GuideText",
 CellID->306834592],
Cell[11762, 407, 408, 11, 70, "InlineGuideFunctionListing",
 CellID->159218501]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12219, 424, 58, 1, 70, "GuideTutorialsSection",
 CellID->22005],
Cell[12280, 427, 146, 3, 70, "GuideTutorial",
 CellID->639205235]
}, Open  ]],
Cell[CellGroupData[{
Cell[12463, 435, 59, 1, 70, "GuideMoreAboutSection",
 CellID->16589],
Cell[12525, 438, 164, 3, 70, "GuideMoreAbout",
 CellID->20540],
Cell[12692, 443, 202, 4, 70, "GuideMoreAbout",
 CellID->367325343]
}, Open  ]],
Cell[CellGroupData[{
Cell[12931, 452, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1302916597],
Cell[13004, 455, 905, 21, 70, "GuideRelatedLinks",
 CellID->279578689]
}, Open  ]],
Cell[13924, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

