(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22822,        681]
NotebookOptionsPosition[     14569,        490]
NotebookOutlinePosition[     19818,        580]
CellTagsIndexPosition[     19775,        577]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polynomial Algebra", "GuideTitle",
 CellID->28956],

Cell[TextData[{
 "Polynomial algorithms are at the core of classical \"computer algebra\". \
Incorporating methods that span from antiquity to the latest cutting-edge \
research at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has the world's broadest and deepest integrated web of polynomial \
algorithms",
 ". ",
 "Carefully tuned strategies automatically select optimal algorithms, \
allowing large-scale polynomial algebra to become a routine part of many \
types of computations."
}], "GuideAbstract",
 CellID->32677],

Cell[CellGroupData[{

Cell["Polynomial Elements", "GuideFunctionsSubsection",
 CellID->15811],

Cell[TextData[{
 Cell[TextData[ButtonBox["Coefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Coefficient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoefficientList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Variables",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variables"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5225]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Structural Operations", "GuideFunctionsSubsection",
 CellID->21143],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Collect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Collect"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21595]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Polynomial Factoring & Decomposition \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PolynomialFactoring"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21016],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FactorList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Decompose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Decompose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SymmetricReduction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SymmetricReduction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PolynomialFactoring"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Polynomial Division \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PolynomialDivision"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->28804],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialQuotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialGCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PolynomialDivision"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Polynomial Systems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PolynomialSystems"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22318168],

Cell[TextData[{
 Cell[TextData[ButtonBox["Solve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Solve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find generic solutions for variables"
}], "GuideText",
 CellID->31641],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eliminate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eliminate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate variables between equations"
}], "GuideText",
 CellID->30335],

Cell[TextData[{
 Cell[TextData[ButtonBox["Resolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate general quantifiers"
}], "GuideText",
 CellID->698],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce systems of equations and inequalities to canonical form"
}], "GuideText",
 CellID->1325],

Cell[TextData[{
 Cell[TextData[ButtonBox["Discriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Discriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Resultant",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resultant"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GroebnerBasis",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CylindricalDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PolynomialSystems"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28313]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finite Fields", "GuideFunctionsSubsection",
 CellID->28023],

Cell[TextData[{
 Cell[TextData[ButtonBox["Modulus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Modulus"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify a modulus"
}], "GuideText",
 CellID->22312],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialMod"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce coefficients in a polynomial"
}], "GuideText",
 CellID->24618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Number Fields \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicNumberTheory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->34143520],

Cell[TextData[{
 Cell[TextData[ButtonBox["GaussianIntegers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "do operations over Gaussian integers"
}], "GuideText",
 CellID->18396],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extension",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extension"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify a general algebraic extension field"
}], "GuideText",
 CellID->8339],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general representation of a polynomial root"
}], "GuideText",
 CellID->21086],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimalPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "minimal polynomial for a general algebraic number"
}], "GuideText",
 CellID->102084309],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootSum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootSum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cyclotomic",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cyclotomic"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SymmetricPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SymmetricPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->32094]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->7846],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->161175268],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "GuideTutorial",
 CellID->174693145],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "GuideTutorial",
 CellID->414928313],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "GuideTutorial",
 CellID->99979351],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "GuideTutorial",
 CellID->30585418]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12911],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "GuideMoreAbout",
 CellID->16280],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "GuideMoreAbout",
 CellID->108407693],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAbout",
 CellID->23455],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FiniteFields/guide/FiniteFieldsPackage"]], "GuideMoreAboutSub",
 CellID->26847],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->653696404],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polynomial Algebra",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22polynomials%22+content%3ACoefficient+OR+CoefficientList+OR+Collect+OR+\
Cyclotomic+OR+CylindricalDecomposition+OR+Decompose+OR+Discriminant+OR+\
Eliminate+OR+Expand+OR+Exponent+OR+Extension+OR+Factor+OR+FactorList+OR+\
GaussianIntegers+OR+GroebnerBasis+OR+MinimalPolynomial+OR+Modulus+OR+\
PolynomialGCD+OR+PolynomialMod+OR+PolynomialQuotient+OR+PolynomialReduce+OR+\
Reduce+OR+Resolve+OR+Resultant+OR+Root+OR+RootReduce+OR+RootSum+OR+Solve+OR+\
SymmetricPolynomial+OR+SymmetricReduction+OR+ToRadicals+OR+Variables"], None},
  
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->38455349]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomial Algebra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 41.5963658}", "context" -> "", 
    "keywords" -> {
     "algebraic algorithms", "algebraic equations", "algebraic geometry", 
      "algebraic inequalities", "algebraic inequations", "algebraic number", 
      "algebraic varieties", "algebraically constructive sets", 
      "AlgebraicNumber", "Buchberger algorithm", "CAD", 
      "Cantor-Zassenhaus algorithm", "catastrophe theory", 
      "characteristic polynomial", "Chinese remainder theorem", "coef", 
      "coefficient list", "coefficient of a polynomial", "collecting terms", 
      "Collins-Hong algorithm", "Collins-Krandick algorithm", 
      "combining radicals", "common roots", "common roots in polynomials", 
      "commutative algebra", "complex variables", "computer algebra", 
      "cyclotomic polynomial", "cylindrical algebraic decomposition", 
      "cylindrical decomposition", "cylindrical parts", "decision problem", 
      "decompose polynomial", "decomposition of polynomials", 
      "Descartes rule of signs", "Diophantine equations", "discriminant", 
      "division", "division of polynomials", "divisor", 
      "domain of coefficients", "domains", "eliminating variables", 
      "elimination basis", "equations", "existential quantifier", "expansion",
       "factoring", "factoring over extension fields", "factor list", 
      "factors list", "Gaussian integers", "GCD of polynomials", 
      "generalized division", "generalized polynomial remainder", 
      "geometric theorem proving", "greatest common divisor of polynomials", 
      "Gro\"bner basis", "Groebner basis", "Groebner-Walk algorithm", 
      "grouping terms", "Hardy-Muskat-Williams methods", "HCF", 
      "Hensel lifting", "highest common factor", "ideal basis", 
      "ideal operations", "ideals", "inequalities", "inequations", 
      "integer equations", "irreducibility", "irreducible factors", 
      "leading coefficient", "leading term", "linear equations", 
      "linear inequalities", "list of factors in polynomials", 
      "minimal polynomial", "modular computation", "modular equations", 
      "modular factorization", "modular reduction of polynomials", 
      "modular ring", "monomial coefficient", "monomial coefficients", 
      "multiple roots", "nested polynomials", "normal form", "patterns", 
      "Pell equations", "poly", "polynom", "polynomial coefficient", 
      "polynomial coefficients", "polynomial degree", "polynomial division", 
      "polynomial equations", "polynomial factorization", "polynomial GCD", 
      "polynomial greatest common divisor", "polynomial inequalities", 
      "polynomial interreduction", "polynomial mod", "polynomial moduli", 
      "Polynomial quotient", "polynomial reduce", "powers", 
      "primary decomposition", "prime elements", "prime factors", 
      "prime fields", "projection of algebraic set", "quantifier elimination",
       "quasi-algebraic sets", "quot", "quotient", "quotient of polynomials", 
      "quotient rings", "radical expression", "rearranging polynomials", 
      "reducing inequalities", "reducing radicals", "regions", 
      "remove quantifiers", "reordering terms", "resultant", 
      "resultants of polynomials", "root", "root reduce", "RootOf", "roots", 
      "roots of equations", "root sum", "SAT problem", 
      "satisfiability problem", "semi-algebraic sets", "simplifying radicals",
       "simultaneous equations", "singularities", "solution of equations", 
      "solutions", "solving equations", "standard basis", "sums", 
      "symmetric polynomial", "symmetric reduction", "syzygies", 
      "theorem proving", "Thue equations", "to radicals", 
      "Trager's algorithm", "transcendental equations", 
      "transcendental inequalities", "UFD", "unique factorization domain", 
      "universal quantifier", "variables for polynomials", "varieties", 
      "Vieta formulas", "Wang's algorithm", "Zariski closure", 
      "Zippel's algorithm"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Polynomial algorithms are at the core of classical \"computer algebra\". \
Incorporating methods that span from antiquity to the latest cutting-edge \
research at Wolfram Research, Mathematica has the world's broadest and \
deepest integrated web of polynomial algorithms. Carefully tuned strategies \
automatically select optimal algorithms, allowing large-scale polynomial \
algebra to become a routine part of many types of computations.", 
    "synonyms" -> {}, "title" -> "Polynomial Algebra", "type" -> "Guide", 
    "uri" -> "guide/PolynomialAlgebra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->28956],
Cell[678, 28, 549, 13, 70, "GuideAbstract",
 CellID->32677],
Cell[CellGroupData[{
Cell[1252, 45, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->15811],
Cell[1326, 48, 829, 23, 70, "InlineGuideFunctionListing",
 CellID->5225]
}, Open  ]],
Cell[CellGroupData[{
Cell[2192, 76, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->21143],
Cell[2274, 79, 386, 11, 70, "InlineGuideFunctionListing",
 CellID->21595]
}, Open  ]],
Cell[CellGroupData[{
Cell[2697, 95, 241, 6, 70, "GuideFunctionsSubsection",
 CellID->21016],
Cell[2941, 103, 1191, 32, 70, "InlineGuideFunctionListing",
 CellID->26615]
}, Open  ]],
Cell[CellGroupData[{
Cell[4169, 140, 221, 5, 70, "GuideFunctionsSubsection",
 CellID->28804],
Cell[4393, 147, 861, 23, 70, "InlineGuideFunctionListing",
 CellID->21006]
}, Open  ]],
Cell[CellGroupData[{
Cell[5291, 175, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->22318168],
Cell[5516, 182, 255, 9, 70, "GuideText",
 CellID->31641],
Cell[5774, 193, 264, 9, 70, "GuideText",
 CellID->30335],
Cell[6041, 204, 250, 9, 70, "GuideText",
 CellID->698],
Cell[6294, 215, 282, 9, 70, "GuideText",
 CellID->1325],
Cell[6579, 226, 1219, 32, 70, "InlineGuideFunctionListing",
 CellID->28313]
}, Open  ]],
Cell[CellGroupData[{
Cell[7835, 263, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->28023],
Cell[7903, 266, 240, 9, 70, "GuideText",
 CellID->22312],
Cell[8146, 277, 270, 9, 70, "GuideText",
 CellID->24618]
}, Open  ]],
Cell[CellGroupData[{
Cell[8453, 291, 231, 5, 70, "GuideFunctionsSubsection",
 CellID->34143520],
Cell[8687, 298, 277, 9, 70, "GuideText",
 CellID->18396],
Cell[8967, 309, 269, 9, 70, "GuideText",
 CellID->8339],
Cell[9239, 320, 260, 9, 70, "GuideText",
 CellID->21086],
Cell[9502, 331, 441, 12, 70, "GuideText",
 CellID->102084309],
Cell[9946, 345, 1411, 38, 70, "InlineGuideFunctionListing",
 CellID->32094]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11406, 389, 57, 1, 70, "GuideTutorialsSection",
 CellID->7846],
Cell[11466, 392, 189, 4, 70, "GuideTutorial",
 CellID->161175268],
Cell[11658, 398, 191, 4, 70, "GuideTutorial",
 CellID->174693145],
Cell[11852, 404, 167, 3, 70, "GuideTutorial",
 CellID->414928313],
Cell[12022, 409, 197, 4, 70, "GuideTutorial",
 CellID->99979351],
Cell[12222, 415, 168, 3, 70, "GuideTutorial",
 CellID->30585418]
}, Open  ]],
Cell[CellGroupData[{
Cell[12427, 423, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12911],
Cell[12489, 426, 148, 3, 70, "GuideMoreAbout",
 CellID->16280],
Cell[12640, 431, 156, 3, 70, "GuideMoreAbout",
 CellID->108407693],
Cell[12799, 436, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[12955, 441, 154, 3, 70, "GuideMoreAbout",
 CellID->23455],
Cell[13112, 446, 172, 4, 70, "GuideMoreAboutSub",
 CellID->26847],
Cell[13287, 452, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[CellGroupData[{
Cell[13497, 460, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->653696404],
Cell[13569, 463, 958, 22, 70, "GuideRelatedLinks",
 CellID->38455349]
}, Open  ]],
Cell[14542, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

