(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13083,        403]
NotebookOptionsPosition[      7863,        276]
NotebookOutlinePosition[     11107,        338]
CellTagsIndexPosition[     11064,        335]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polynomial Equations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Packed into functions like ",
 Cell[TextData[ButtonBox["Solve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Solve"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " are a wealth of sophisticated algorithms, many created specifically for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Routinely handling both dense and sparse polynomials with thousands of \
terms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can represent results in terms of numerical approximations, exact radicals \
or its unique symbolic ",
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " object constructs."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Solve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Solve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find generic solutions"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Roots",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Roots"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "roots of a univariate polynomial"
}], "GuideText",
 CellID->208409415],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce a general polynomial system"
}], "GuideText",
 CellID->1463276848],

Cell[CellGroupData[{

Cell["Solutions in Radicals", "GuideFunctionsSubsection",
 CellID->86278767],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cubics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cubics"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quartics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quartics"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->255285308]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root Isolation", "GuideFunctionsSubsection",
 CellID->28363608],

Cell[TextData[{
 Cell[TextData[ButtonBox["CountRoots",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CountRoots"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count roots in an interval"
}], "GuideText",
 CellID->126017714],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootIntervals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootIntervals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IsolatingInterval",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->60252327]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Approximations", "GuideFunctionsSubsection",
 CellID->8497601],

Cell[TextData[{
 Cell[TextData[ButtonBox["NSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NRoots",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NRoots"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindRoot"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->339382402]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "GuideTutorial",
 CellID->17817220],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->161175268],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "GuideTutorial",
 CellID->174693145],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "GuideTutorial",
 CellID->414928313],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "GuideTutorial",
 CellID->99979351],

Cell[TextData[ButtonBox["Root Isolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RootIsolation"]], "GuideTutorial",
 CellID->255454534],

Cell[TextData[ButtonBox["Numerical Solution of Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalSolutionOfPolynomialEquations"]], "GuideTutorial",\

 CellID->60259992]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAboutSub",
 CellID->132954056],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->213248583],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polynomial Equations",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22polynomials%22+content%3ACountRoots+OR+Cubics+OR+FindRoot+OR+\
IsolatingInterval+OR+NRoots+OR+NSolve+OR+Quartics+OR+Reduce+OR+Root+OR+\
RootIntervals+OR+Roots+OR+Solve+OR+ToRadicals"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->24484087]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomial Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 43.6432932}", "context" -> "", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", "algebraic inequations",
       "algebraic number", "algebraic number isolating interval", 
      "algebraically constructive sets", "AlgebraicNumber", "Brent method", 
      "Chinese remainder theorem", "Collins-Krandick algorithm", 
      "common roots of equations", "complex root counts", "complex variables",
       "count roots", "cylindrical decomposition", "Descartes rule of signs", 
      "Diophantine equations", "direct equation solving method", 
      "direct method for root finding", "domains", "equations", 
      "exact root counts", "find root", "Gro\"bner basis", "Groebner basis", 
      "Hardy-Muskat-Williams methods", "inequalities", "inequations", 
      "integer equations", "isolating interval", "isolating intervals", 
      "iterative root finding", "Jenkins-Traub algorithm", "linear equations",
       "linear inequalities", "modular equations", "Newton-Raphson method", 
      "Newton's method", "numerical root finding", 
      "numerical solution of polynomial equations", "Pell equations", 
      "polynomial equations", "polynomial inequalities", 
      "polynomial root finding", "polynomial root isolation", 
      "polynomial roots", "quasi-algebraic sets", "radical expression", 
      "real root counts", "reducing inequalities", "regions", "root", 
      "root counts in region", "root intervals", "root isolation", "RootOf", 
      "roots of equations", "roots of polynomials", "secant method", 
      "semi-algebraic sets", "solution of equations", 
      "solution of polynomial equations", "solutions", 
      "solve algebraic equations", "solving equations", 
      "solving systems of equations", "symbolic representation of roots", 
      "Thue equations", "to radicals", "transcendental equations", 
      "transcendental equations numerical solving", 
      "transcendental inequalities", 
      "transcendental roots numerical solving"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Packed into functions like Solve and Reduce are a wealth of \
sophisticated algorithms, many created specifically for Mathematica. \
Routinely handling both dense and sparse polynomials with thousands of terms, \
Mathematica can represent results in terms of numerical approximations, exact \
radicals or its unique symbolic Root object constructs.", "synonyms" -> {}, 
    "title" -> "Polynomial Equations", "type" -> "Guide", "uri" -> 
    "guide/PolynomialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[684, 28, 833, 23, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1520, 53, 245, 9, 70, "GuideText",
 CellID->203374175],
Cell[1768, 64, 255, 9, 70, "GuideText",
 CellID->208409415],
Cell[2026, 75, 260, 9, 70, "GuideText",
 CellID->1463276848],
Cell[CellGroupData[{
Cell[2311, 88, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->86278767],
Cell[2390, 91, 804, 23, 70, "InlineGuideFunctionListing",
 CellID->255285308]
}, Open  ]],
Cell[CellGroupData[{
Cell[3231, 119, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->28363608],
Cell[3303, 122, 404, 12, 70, "GuideText",
 CellID->126017714],
Cell[3710, 136, 713, 17, 70, "InlineGuideFunctionListing",
 CellID->60252327]
}, Open  ]],
Cell[CellGroupData[{
Cell[4460, 158, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->8497601],
Cell[4541, 161, 596, 17, 70, "InlineGuideFunctionListing",
 CellID->339382402]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5186, 184, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5251, 187, 151, 3, 70, "GuideTutorial",
 CellID->17817220],
Cell[5405, 192, 189, 4, 70, "GuideTutorial",
 CellID->161175268],
Cell[5597, 198, 191, 4, 70, "GuideTutorial",
 CellID->174693145],
Cell[5791, 204, 167, 3, 70, "GuideTutorial",
 CellID->414928313],
Cell[5961, 209, 197, 4, 70, "GuideTutorial",
 CellID->99979351],
Cell[6161, 215, 146, 3, 70, "GuideTutorial",
 CellID->255454534],
Cell[6310, 220, 203, 5, 70, "GuideTutorial",
 CellID->60259992]
}, Open  ]],
Cell[CellGroupData[{
Cell[6550, 230, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6615, 233, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6771, 238, 153, 3, 70, "GuideMoreAboutSub",
 CellID->132954056],
Cell[6927, 243, 161, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[CellGroupData[{
Cell[7125, 251, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->213248583],
Cell[7197, 254, 624, 17, 70, "GuideRelatedLinks",
 CellID->24484087]
}, Open  ]],
Cell[7836, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

