(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13362,        437]
NotebookOptionsPosition[      8554,        311]
NotebookOutlinePosition[     11271,        366]
CellTagsIndexPosition[     11228,        363]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polynomial Factoring & Decomposition", "GuideTitle",
 CellID->18125],

Cell[TextData[{
 "Factoring a quadratic polynomial in one variable is straightforward. But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " routinely factors degree-100 polynomials in 3 variables\[LongDash]by \
making use of a tower of sophisticated algorithms, carefully tuned at Wolfram \
Research over the course of two decades."
}], "GuideAbstract",
 CellID->12534],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "fully factor any polynomial"
}], "GuideText",
 CellID->32621],

Cell[TextData[{
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a polynomial is free of multiple factors"
}], "GuideText",
 CellID->8036468],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorSquareFree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pull out only factors that occur as squares or higher powers"
}], "GuideText",
 CellID->27692],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorTerms",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorTerms"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pull out only overall numerical factors"
}], "GuideText",
 CellID->25293],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorList"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FactorSquareFreeList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorSquareFreeList"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FactorTermsList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorTermsList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give lists of factors"
}], "GuideText",
 CellID->5117],

Cell["\t", "GuideDelimiter",
 CellID->7717],

Cell[TextData[{
 Cell[TextData[ButtonBox["Modulus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Modulus"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify a modulus for a finite field"
}], "GuideText",
 CellID->20403],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extension",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extension"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify a general algebraic extension field"
}], "GuideText",
 CellID->3943],

Cell[TextData[{
 Cell[TextData[ButtonBox["GaussianIntegers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "factor over Gaussian integers"
}], "GuideText",
 CellID->17893],

Cell["\t", "GuideDelimiter",
 CellID->10639],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out polynomials"
}], "GuideText",
 CellID->29011],

Cell["\t", "GuideDelimiter",
 CellID->26925],

Cell[TextData[{
 Cell[TextData[ButtonBox["Decompose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Decompose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "decompose into a composition of polynomials "
}], "GuideText",
 CellID->24028],

Cell[TextData[{
 Cell[TextData[ButtonBox["HornerForm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HornerForm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rearrange a polynomial into Horner form"
}], "GuideText",
 CellID->692571638],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymmetricReduction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SymmetricReduction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce a polynomial into a symmetric and non-symmetric part"
}], "GuideText",
 CellID->102178765],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolatingPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a polynomial that goes through a list of points"
}], "GuideText",
 CellID->19978],

Cell["\t", "GuideDelimiterSubsection",
 CellID->437333993],

Cell[CellGroupData[{

Cell["Rational Functions", "GuideFunctionsSubsection",
 CellID->643476093],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Together",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Together"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ApartSquareFree",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ApartSquareFree"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->146481389]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->10748],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "GuideTutorial",
 CellID->181254355],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->418448587],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "GuideTutorial",
 CellID->50838945]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->26444],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "GuideMoreAbout",
 CellID->10654],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->23623],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2066211285],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polynomial Factoring & Decomposition",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Decompose+OR+Expand+OR+Extension+OR+Factor+OR+FactorList+OR+FactorSquareFree+\
OR+FactorSquareFreeList+OR+FactorTerms+OR+FactorTermsList+OR+GaussianIntegers+\
OR+HornerForm+OR+Modulus+OR+SquareFreeQ+OR+SymmetricReduction)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->1051361327]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomial Factoring & Decomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 44.2995600}", "context" -> "", 
    "keywords" -> {
     "Birkhoff interpolation", "Cantor-Zassenhaus algorithm", 
      "common factors", "content", "content of a polynomial", 
      "decompose polynomial", "decomposition of polynomials", 
      "domain of coefficients", "efficient polynomial evaluation", 
      "expansion", "factor list", "factor square free", 
      "factor square free list", "factor terms", "factor terms list", 
      "factoring", "factoring over extension fields", "factors list", 
      "Gaussian integers", "Hensel lifting", "Hermite interpolation", 
      "Horner form", "interpolating polynomial", "irreducibility", 
      "irreducible factors", "list of factors in polynomials", 
      "modular computation", "modular factorization", "modular ring", 
      "multiple factors", "nested polynomials", "Newton interpolation", 
      "numerical factors", "overall factors", "polynomial", 
      "polynomial factorization", "polynomial factors", 
      "polynomial interpolation", "polynomial representation", 
      "prime elements", "prime factors", "prime fields", "quotient rings", 
      "rational function representation", 
      "recursive polynomial representation", "square free", 
      "square-free factoring", "square-free factorization", 
      "square-free factors", "square-free integers", 
      "square-free polynomials", "stable polynomial evaluation", 
      "symmetric reduction", "Trager's algorithm", "UFD", 
      "unique factorization domain", "Wang's algorithm"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Factoring a quadratic polynomial in one variable is straightforward. But \
Mathematica routinely factors degree-100 polynomials in 3 variables--by \
making use of a tower of sophisticated algorithms, carefully tuned at Wolfram \
Research over the course of two decades.", "synonyms" -> {}, "title" -> 
    "Polynomial Factoring & Decomposition", "type" -> "Guide", "uri" -> 
    "guide/PolynomialFactoring"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 74, 1, 70, "GuideTitle",
 CellID->18125],
Cell[696, 28, 375, 8, 70, "GuideAbstract",
 CellID->12534],
Cell[1074, 38, 248, 9, 70, "GuideText",
 CellID->32621],
Cell[1325, 49, 426, 12, 70, "GuideText",
 CellID->8036468],
Cell[1754, 63, 301, 9, 70, "GuideText",
 CellID->27692],
Cell[2058, 74, 270, 9, 70, "GuideText",
 CellID->25293],
Cell[2331, 85, 541, 17, 70, "GuideText",
 CellID->5117],
Cell[2875, 104, 43, 1, 70, "GuideDelimiter",
 CellID->7717],
Cell[2921, 107, 259, 9, 70, "GuideText",
 CellID->20403],
Cell[3183, 118, 269, 9, 70, "GuideText",
 CellID->3943],
Cell[3455, 129, 270, 9, 70, "GuideText",
 CellID->17893],
Cell[3728, 140, 44, 1, 70, "GuideDelimiter",
 CellID->10639],
Cell[3775, 143, 243, 9, 70, "GuideText",
 CellID->29011],
Cell[4021, 154, 44, 1, 70, "GuideDelimiter",
 CellID->26925],
Cell[4068, 157, 271, 9, 70, "GuideText",
 CellID->24028],
Cell[4342, 168, 417, 12, 70, "GuideText",
 CellID->692571638],
Cell[4762, 182, 453, 12, 70, "GuideText",
 CellID->102178765],
Cell[5218, 196, 312, 9, 70, "GuideText",
 CellID->19978],
Cell[5533, 207, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->437333993],
Cell[CellGroupData[{
Cell[5616, 212, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->643476093],
Cell[5693, 215, 757, 20, 70, "InlineGuideFunctionListing",
 CellID->146481389]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6499, 241, 58, 1, 70, "GuideTutorialsSection",
 CellID->10748],
Cell[6560, 244, 191, 4, 70, "GuideTutorial",
 CellID->181254355],
Cell[6754, 250, 189, 4, 70, "GuideTutorial",
 CellID->418448587],
Cell[6946, 256, 197, 4, 70, "GuideTutorial",
 CellID->50838945]
}, Open  ]],
Cell[CellGroupData[{
Cell[7180, 265, 59, 1, 70, "GuideMoreAboutSection",
 CellID->26444],
Cell[7242, 268, 152, 3, 70, "GuideMoreAbout",
 CellID->10654],
Cell[7397, 273, 148, 3, 70, "GuideMoreAbout",
 CellID->23623],
Cell[7548, 278, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[CellGroupData[{
Cell[7758, 286, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2066211285],
Cell[7831, 289, 681, 17, 70, "GuideRelatedLinks",
 CellID->1051361327]
}, Open  ]],
Cell[8527, 309, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

