(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21785,        664]
NotebookOptionsPosition[     13552,        472]
NotebookOutlinePosition[     18710,        561]
CellTagsIndexPosition[     18667,        558]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polynomial Systems", "GuideTitle",
 CellID->21346],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s handling of polynomial systems is a ",
 StyleBox["tour de force",
  FontSlant->"Italic"],
 " of algebraic computation",
 ". ",
 "Building on mathematical results spanning more than a century, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for the first time implements complete efficient reduction of polynomial \
equation and inequality systems\[LongDash]making possible industrial-strength \
generalized algebraic geometry for many new applications."
}], "GuideAbstract",
 CellID->394711827],

Cell[CellGroupData[{

Cell["Solving & Reducing", "GuideFunctionsSubsection",
 CellID->37532605],

Cell[TextData[{
 Cell[TextData[ButtonBox["Solve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Solve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find generic solutions for variables"
}], "GuideText",
 CellID->31641],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce systems of equations and inequalities to canonical form"
}], "GuideText",
 CellID->1325],

Cell[TextData[{
 Cell[TextData[ButtonBox["Complexes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complexes"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reals"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "domains for variables"
}], "GuideText",
 CellID->33679730]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eliminating Variables", "GuideFunctionsSubsection",
 CellID->231123716],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eliminate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eliminate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate variables between equations"
}], "GuideText",
 CellID->30335],

Cell[TextData[{
 Cell[TextData[ButtonBox["SolveAlways",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SolveAlways"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve for parameter values that make equations always hold"
}], "GuideText",
 CellID->26886],

Cell[TextData[{
 Cell[TextData[ButtonBox["GroebnerBasis",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Resultant",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resultant"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Discriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Discriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Subresultants",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subresultants"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16405]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantifier Elimination", "GuideFunctionsSubsection",
 CellID->947488095],

Cell[TextData[{
 Cell[TextData[ButtonBox["ForAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ForAll]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exists",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Exists]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->545145473],

Cell[TextData[{
 Cell[TextData[ButtonBox["Resolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate general quantifiers"
}], "GuideText",
 CellID->698],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "eliminate quantifiers and reduce the results"
}], "GuideText",
 CellID->31818630]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structure of Solution Sets", "GuideFunctionsSubsection",
 CellID->25059158],

Cell[TextData[{
 Cell[TextData[ButtonBox["SemialgebraicComponentInstances",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CylindricalDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GenericCylindricalDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GenericCylindricalDecomposition"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12034223]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Solutions", "GuideFunctionsSubsection",
 CellID->233413127],

Cell[TextData[{
 Cell[TextData[ButtonBox["NSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve systems of polynomial equations"
}], "GuideText",
 CellID->197929756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Optimization \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Optimization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->158914629],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Maximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Maximize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NMaximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMaximize"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26060101]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization", "GuideFunctionsSubsection",
 CellID->714790864],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " curve or curves defined by equation in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->96813428],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " surface defined by equation in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->5794625],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "regions defined by inequalities"
}], "GuideText",
 CellID->85212303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation Structure", "GuideFunctionsSubsection",
 CellID->8211936],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->280320367]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18166],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "GuideTutorial",
 CellID->181254355],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->418448587],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "GuideTutorial",
 CellID->50838945],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "GuideTutorial",
 CellID->132031343],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "GuideTutorial",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->17093],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "GuideMoreAbout",
 CellID->30055989],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAbout",
 CellID->3187],

Cell[TextData[ButtonBox["Linear Algebra & Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "GuideMoreAbout",
 CellID->1421],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "GuideMoreAboutSub",
 CellID->28299],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2002495005],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polynomial Systems",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
CoefficientArrays+OR+CoefficientList+OR+Complexes+OR+ContourPlot+OR+\
ContourPlot3D+OR+CylindricalDecomposition+OR+Discriminant+OR+Eliminate+OR+\
Exists+OR+FindInstance+OR+ForAll+OR+GenericCylindricalDecomposition+OR+\
GroebnerBasis+OR+Integers+OR+LogicalExpand+OR+Maximize+OR+Minimize+OR+\
NMaximize+OR+NMinimize+OR+NSolve+OR+Reals+OR+Reduce+OR+RegionPlot+OR+\
RegionPlot3D+OR+Resolve+OR+Resultant+OR+SemialgebraicComponentInstances+OR+\
Solve+OR+SolveAlways+OR+Subresultants)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->64053500]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomial Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 44.9714522}", "context" -> "", 
    "keywords" -> {
     "algebraic algorithms", "algebraic equations", "algebraic geometry", 
      "algebraic inequalities", "algebraic inequations", 
      "algebraic varieties", "algebraically constructive sets", 
      "Boolean algebra", "Boolean expansion", "Boolean expressions", 
      "Boolean satisfiability", "Buchberger algorithm", "CAD", 
      "CAD sample points", "catastrophe theory", "cell sample points", 
      "Chinese remainder theorem", "coefficient arrays", "coefficient list", 
      "coefficient of a polynomial", "Collins-Hong algorithm", "common roots",
       "common roots in polynomials", "commutative algebra", "complex domain",
       "complex number", "complex range", "complex solution", "complex space",
       "complex variable", "complex variables", "constrained optimization", 
      "cost function", "cylindrical algebraic decomposition", 
      "cylindrical decomposition", "cylindrical parts", 
      "Diophantine equations", "direct equation solving method", 
      "direct method for root finding", "discriminant", "domains", 
      "eliminating variables", "elimination basis", "equations", 
      "equations that are always satisfied", "exact optimization", 
      "expansion", "extremization", 
      "full\\[Hyphen]dimensional inequality solutions", 
      "generic cylindrical decomposition", "generic inequality solutions", 
      "geometric theorem proving", "global maximization", 
      "global minimization", "goal functions", "Grobner basis", 
      "Groebner basis", "Groebner Walk algorithm", 
      "Hardy-Muskat-Williams methods", "homogeneous forms", "ideal basis", 
      "ideal operations", "ideals", "inequalities", "inequations", 
      "infeasible constraints", "integer domain", "integer equations", 
      "integer lattice", "integer linear programming", "integer programming", 
      "integer range", "integer solutions", "integer variables", "integers", 
      "integral numbers", "Jenkins-Traub algorithm", "linear equations", 
      "linear fractional programming", "linear inequalities", 
      "linear programming", "logic quantifier", "logical expand", "LP", 
      "matrices", "maximization", "method of undetermined coefficients", 
      "minimization", "modular equations", "monomial coefficients", 
      "multiple roots", "nary forms", "normal form", "numerical maximization",
       "numerical minimization", "numerical solution of polynomial equations",
       "objective functions", "operations research", "optimization", 
      "parametric optimization", "pay-off functions", "Pell equations", 
      "plot region", "plot volume", "polynomial coefficients", 
      "polynomial equations", "polynomial inequalities", 
      "polynomial programming", "polynomial root finding", 
      "primary decomposition", "principal subresultant coefficients", 
      "projection of algebraic set", "propositional logic", "psc", 
      "quadratic forms", "quadratic programming", "quasi-algebraic sets", 
      "real axis", "real domain", "real numbers", "real plane", "real range", 
      "real solutions", "real space", "real variables", "reals", 
      "reducing inequalities", "regions", "regular sets", "resultant", 
      "resultants of polynomials", "root multiplicities", 
      "roots of equations", "roots of polynomials", "sample points", 
      "satisfiability", "satisfiability problem", "SAT problem", 
      "semi-algebraic sets", "semialgebraic component instances", 
      "semialgebraic components", "semialgebraic sets", "simplex algorithm", 
      "simplification", "simultaneous equations", "singularities", 
      "solution of equations", "solution of polynomial equations", 
      "solutions", "solve always", "solving equations", 
      "solving inequalities", "standard basis", "subresultants", "syzygies", 
      "symbolic optimization", "undetermined coefficients"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's handling of polynomial systems is a tour de force of \
algebraic computation. Building on mathematical results spanning more than a \
century, Mathematica for the first time implements complete efficient \
reduction of polynomial equation and inequality systems--making possible \
industrial-strength generalized algebraic geometry for many new \
applications.", "synonyms" -> {}, "title" -> "Polynomial Systems", "type" -> 
    "Guide", "uri" -> "guide/PolynomialSystems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->21346],
Cell[678, 28, 571, 15, 70, "GuideAbstract",
 CellID->394711827],
Cell[CellGroupData[{
Cell[1274, 47, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->37532605],
Cell[1350, 50, 255, 9, 70, "GuideText",
 CellID->31641],
Cell[1608, 61, 282, 9, 70, "GuideText",
 CellID->1325],
Cell[1893, 72, 499, 17, 70, "GuideText",
 CellID->33679730]
}, Open  ]],
Cell[CellGroupData[{
Cell[2429, 94, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->231123716],
Cell[2509, 97, 264, 9, 70, "GuideText",
 CellID->30335],
Cell[2776, 108, 289, 9, 70, "GuideText",
 CellID->26886],
Cell[3068, 119, 983, 26, 70, "InlineGuideFunctionListing",
 CellID->16405]
}, Open  ]],
Cell[CellGroupData[{
Cell[4088, 150, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->947488095],
Cell[4169, 153, 634, 21, 70, "InlineGuideFunctionListing",
 CellID->545145473],
Cell[4806, 176, 250, 9, 70, "GuideText",
 CellID->698],
Cell[5059, 187, 268, 9, 70, "GuideText",
 CellID->31818630]
}, Open  ]],
Cell[CellGroupData[{
Cell[5364, 201, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->25059158],
Cell[5448, 204, 1094, 28, 70, "InlineGuideFunctionListing",
 CellID->12034223]
}, Open  ]],
Cell[CellGroupData[{
Cell[6579, 237, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->233413127],
Cell[6657, 240, 262, 9, 70, "GuideText",
 CellID->197929756]
}, Open  ]],
Cell[CellGroupData[{
Cell[6956, 254, 212, 5, 70, "GuideFunctionsSubsection",
 CellID->158914629],
Cell[7171, 261, 815, 23, 70, "InlineGuideFunctionListing",
 CellID->26060101]
}, Open  ]],
Cell[CellGroupData[{
Cell[8023, 289, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->714790864],
Cell[8095, 292, 392, 13, 70, "GuideText",
 CellID->96813428],
Cell[8490, 307, 596, 19, 70, "GuideText",
 CellID->5794625],
Cell[9089, 328, 688, 19, 70, "GuideText",
 CellID->85212303]
}, Open  ]],
Cell[CellGroupData[{
Cell[9814, 352, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->8211936],
Cell[9889, 355, 646, 17, 70, "InlineGuideFunctionListing",
 CellID->280320367]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10584, 378, 58, 1, 70, "GuideTutorialsSection",
 CellID->18166],
Cell[10645, 381, 191, 4, 70, "GuideTutorial",
 CellID->181254355],
Cell[10839, 387, 189, 4, 70, "GuideTutorial",
 CellID->418448587],
Cell[11031, 393, 197, 4, 70, "GuideTutorial",
 CellID->50838945],
Cell[11231, 399, 167, 3, 70, "GuideTutorial",
 CellID->132031343],
Cell[11401, 404, 169, 3, 70, "GuideTutorial",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[11607, 412, 59, 1, 70, "GuideMoreAboutSection",
 CellID->17093],
Cell[11669, 415, 155, 3, 70, "GuideMoreAbout",
 CellID->30055989],
Cell[11827, 420, 153, 3, 70, "GuideMoreAbout",
 CellID->3187],
Cell[11983, 425, 161, 3, 70, "GuideMoreAbout",
 CellID->1421],
Cell[12147, 430, 160, 3, 70, "GuideMoreAboutSub",
 CellID->28299],
Cell[12310, 435, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[CellGroupData[{
Cell[12520, 443, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2002495005],
Cell[12593, 446, 917, 21, 70, "GuideRelatedLinks",
 CellID->64053500]
}, Open  ]],
Cell[13525, 470, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

