(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10855,        372]
NotebookOptionsPosition[      7156,        268]
NotebookOutlinePosition[      9031,        309]
CellTagsIndexPosition[      8988,        306]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Precision & Accuracy Control", "GuideTitle",
 CellID->10382],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has sophisticated built-in automatic numerical precision and accuracy \
control. But for special-purpose optimization of numerical computations, or \
for studying numerical analysis, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows detailed control over precision and accuracy."
}], "GuideAbstract",
 CellID->29271],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical evaluation to specified precision and accuracy"
}], "GuideText",
 CellID->1014],

Cell["\t", "GuideDelimiter",
 CellID->19104],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrecisionGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["AccuracyGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "precision and accuracy goals for computations"
}], "GuideText",
 CellID->484],

Cell[TextData[{
 Cell[TextData[ButtonBox["WorkingPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "precision to use inside algorithms"
}], "GuideText",
 CellID->2943],

Cell["\t", "GuideDelimiter",
 CellID->11495],

Cell[TextData[{
 Cell[TextData[ButtonBox["Precision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Precision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the precision of a number"
}], "GuideText",
 CellID->26811],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accuracy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Accuracy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the accuracy of a number"
}], "GuideText",
 CellID->1293],

Cell["\t", "GuideDelimiter",
 CellID->28892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Chop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Chop"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set sufficiently small numbers or imaginary parts to zero"
}], "GuideText",
 CellID->6798],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetPrecision"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SetAccuracy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetAccuracy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reset precision or accuracy of a number"
}], "GuideText",
 CellID->1990],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MinPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MinPrecision"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["$MaxPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "settable global precision bounds"
}], "GuideText",
 CellID->11299],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MaxExtraPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "maximum extra precision to use inside exact algorithms"
}], "GuideText",
 CellID->14890],

Cell["\t", "GuideDelimiterSubsection",
 CellID->8493],

Cell[CellGroupData[{

Cell["Machine Numbers", "GuideFunctionsSubsection",
 CellID->29074],

Cell[TextData[{
 Cell[TextData[ButtonBox["MachinePrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MachinePrecision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbol representing machine precision"
}], "GuideText",
 CellID->1549],

Cell[TextData[{
 Cell[TextData[ButtonBox["MachineNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MachineNumberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a number is a machine number"
}], "GuideText",
 CellID->13774],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MachinePrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MachineEpsilon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MinMachineNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MaxMachineNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9314]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->20173],

Cell[TextData[ButtonBox["Exact and Approximate Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExactAndApproximateResults"]], "GuideTutorial",
 CellID->733113756],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "GuideTutorial",
 CellID->499191687],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ArbitraryPrecisionCalculations"]], "GuideTutorial",
 CellID->24069],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "GuideTutorial",
 CellID->29218],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "GuideTutorial",
 CellID->86948921]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->26865],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAbout",
 CellID->16833],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "GuideMoreAbout",\

 CellID->264974235]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Precision & Accuracy Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 46.2839858}", "context" -> "", 
    "keywords" -> {
     "absolute error", "accuracy goal", "accuracy of result", 
      "approximations", "conformity", "decimal places", "errors", 
      "granularity of machine numbers", "increasing precision", "length", 
      "machine epsilon", "machine number", "machine precision", 
      "max extra precision", "max machine number", "max precision", 
      "min machine number", "min precision", "number of decimal places", 
      "number of digits", "numbers", "precision", "precision goal", 
      "relative error", "roundoff errors", "set accuracy", "set precision", 
      "truncation of numbers", "veracity", "working precision", "zero"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has sophisticated built-in automatic numerical precision and \
accuracy control. But for special-purpose optimization of numerical \
computations, or for studying numerical analysis, Mathematica also allows \
detailed control over precision and accuracy.", "synonyms" -> {}, "title" -> 
    "Precision & Accuracy Control", "type" -> "Guide", "uri" -> 
    "guide/PrecisionAndAccuracyControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 66, 1, 70, "GuideTitle",
 CellID->10382],
Cell[688, 28, 401, 10, 70, "GuideAbstract",
 CellID->29271],
Cell[1092, 40, 266, 9, 70, "GuideText",
 CellID->1014],
Cell[1361, 51, 44, 1, 70, "GuideDelimiter",
 CellID->19104],
Cell[1408, 54, 413, 13, 70, "GuideText",
 CellID->484],
Cell[1824, 69, 274, 9, 70, "GuideText",
 CellID->2943],
Cell[2101, 80, 44, 1, 70, "GuideDelimiter",
 CellID->11495],
Cell[2148, 83, 257, 9, 70, "GuideText",
 CellID->26811],
Cell[2408, 94, 253, 9, 70, "GuideText",
 CellID->1293],
Cell[2664, 105, 44, 1, 70, "GuideDelimiter",
 CellID->28892],
Cell[2711, 108, 273, 9, 70, "GuideText",
 CellID->6798],
Cell[2987, 119, 404, 13, 70, "GuideText",
 CellID->1990],
Cell[3394, 134, 404, 13, 70, "GuideText",
 CellID->11299],
Cell[3801, 149, 299, 9, 70, "GuideText",
 CellID->14890],
Cell[4103, 160, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->8493],
Cell[CellGroupData[{
Cell[4181, 165, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->29074],
Cell[4251, 168, 277, 9, 70, "GuideText",
 CellID->1549],
Cell[4531, 179, 273, 9, 70, "GuideText",
 CellID->13774],
Cell[4807, 190, 875, 23, 70, "InlineGuideFunctionListing",
 CellID->9314]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5731, 219, 58, 1, 70, "GuideTutorialsSection",
 CellID->20173],
Cell[5792, 222, 174, 3, 70, "GuideTutorial",
 CellID->733113756],
Cell[5969, 227, 179, 3, 70, "GuideTutorial",
 CellID->499191687],
Cell[6151, 232, 188, 4, 70, "GuideTutorial",
 CellID->24069],
Cell[6342, 238, 171, 3, 70, "GuideTutorial",
 CellID->29218],
Cell[6516, 243, 155, 3, 70, "GuideTutorial",
 CellID->86948921]
}, Open  ]],
Cell[CellGroupData[{
Cell[6708, 251, 59, 1, 70, "GuideMoreAboutSection",
 CellID->26865],
Cell[6770, 254, 161, 3, 70, "GuideMoreAbout",
 CellID->16833],
Cell[6934, 259, 180, 4, 70, "GuideMoreAbout",
 CellID->264974235]
}, Open  ]],
Cell[7129, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

