(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14075,        475]
NotebookOptionsPosition[      9370,        345]
NotebookOutlinePosition[     11652,        394]
CellTagsIndexPosition[     11609,        391]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Prime Numbers", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The primes have been a focal point for investigations of numbers for more \
than two millennia. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implements state-of-the-art algorithms for handling both primes and the \
advanced mathematics that has grown up around their study. Use ",
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 " to quickly find the billionth prime, or ",
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 " to get empirical evidence related to the Riemann hypothesis."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Generating Primes", "GuideFunctionsSubsection",
 CellID->74614452],

Cell[TextData[{
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime number"
}], "GuideText",
 CellID->178956489],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NextPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "next, previous, etc. prime"
}], "GuideText",
 CellID->247386826],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pick a random prime"
}], "GuideText",
 CellID->228670262]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sequence of Primes", "GuideFunctionsSubsection",
 CellID->197456017],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimePi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimePi"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the number of primes up to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->373601277],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Riemann zeta function"
}], "GuideText",
 CellID->313338934],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " zeros of the zeta function"
}], "GuideText",
 CellID->810550574],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->307782836]
}, Open  ]],

Cell[CellGroupData[{

Cell["Primality Testing", "GuideFunctionsSubsection",
 CellID->83842898],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a number is prime"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if numbers are coprime"
}], "GuideText",
 CellID->263632644]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theorems & Equations", "GuideFunctionsSubsection",
 CellID->301285478],

Cell[TextData[{
 Cell[TextData[ButtonBox["Primes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Primes"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the domain of primes"
}], "GuideText",
 CellID->27073636],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce equations over the primes"
}], "GuideText",
 CellID->502226479],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find Diophantine solutions over the primes"
}], "GuideText",
 CellID->352716060],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "simplify assuming numbers are prime"
}], "GuideText",
 CellID->222902602]
}, Open  ]],

Cell[CellGroupData[{

Cell["Factoring", "GuideFunctionsSubsection",
 CellID->421193284],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the factors of an integer"
}], "GuideText",
 CellID->228381222],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->218183023]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->179410169],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Primality Proving Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PrimalityProving/guide/PrimalityProvingPackage"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1600987693],

Cell[TextData[{
 ButtonBox["Demonstrations related to Prime Numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22prime+numbers%22+content%3ACoprimeQ+OR+FactorInteger+OR+FindInstance+OR+\
FullSimplify+OR+IntegerExponent+OR+LogIntegral+OR+NextPrime+OR+Prime+OR+\
PrimePi+OR+PrimeQ+OR+Primes+OR+RandomPrime+OR+Reduce+OR+RiemannSiegelTheta+OR+\
RiemannSiegelZ+OR+SquareFreeQ+OR+Zeta+OR+ZetaZero"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->56367300]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Prime Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 47.9871544}", "context" -> "", 
    "keywords" -> {
     "Chinese remainder theorem", "decomposition into primes", 
      "density of primes", "distribution of primes", "factor integer", 
      "factoring", "factors", "Gaussian integers", 
      "generalized zeta function", "greatest dividing exponent", 
      "Hurwitz zeta function", "ifact", "integer equations", 
      "integer exponent", "integer factoring", "isprime", "next prime", 
      "number theory", "primality testing", "prime", 
      "prime counting function", "prime domain", "prime factors", 
      "prime number", "prime pi", "primes", "pseudoprime test", 
      "random prime", "Riemann hypothesis", "Riemann Siegel", 
      "Riemann Siegel theta", "Riemann zeta function", "Riemann-Siegel", 
      "Riemann-Siegel formula", "Riemann-Siegel theta", "square free", 
      "square-free integers", "submultiples", 
      "testing for primality of integers", "testing for prime", 
      "theorem proving", "zeros", "zeta function", "zeta function root", 
      "zeta zero"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The primes have been a focal point for investigations of numbers for \
more than two millennia. Mathematica implements state-of-the-art algorithms \
for handling both primes and the advanced mathematics that has grown up \
around their study. Use Prime to quickly find the billionth prime, or Zeta to \
get empirical evidence related to the Riemann hypothesis.", "synonyms" -> {}, 
    "title" -> "Prime Numbers", "type" -> "Guide", "uri" -> 
    "guide/PrimeNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[677, 28, 687, 16, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1389, 48, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->74614452],
Cell[1464, 51, 379, 14, 70, "GuideText",
 CellID->178956489],
Cell[1846, 67, 402, 12, 70, "GuideText",
 CellID->247386826],
Cell[2251, 81, 399, 12, 70, "GuideText",
 CellID->228670262]
}, Open  ]],
Cell[CellGroupData[{
Cell[2687, 98, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->197456017],
Cell[2764, 101, 306, 10, 70, "GuideText",
 CellID->373601277],
Cell[3073, 113, 242, 9, 70, "GuideText",
 CellID->313338934],
Cell[3318, 124, 395, 11, 70, "GuideText",
 CellID->810550574],
Cell[3716, 137, 642, 17, 70, "InlineGuideFunctionListing",
 CellID->307782836]
}, Open  ]],
Cell[CellGroupData[{
Cell[4395, 159, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->83842898],
Cell[4470, 162, 250, 9, 70, "GuideText",
 CellID->203374175],
Cell[4723, 173, 401, 12, 70, "GuideText",
 CellID->263632644]
}, Open  ]],
Cell[CellGroupData[{
Cell[5161, 190, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->301285478],
Cell[5240, 193, 244, 9, 70, "GuideText",
 CellID->27073636],
Cell[5487, 204, 257, 9, 70, "GuideText",
 CellID->502226479],
Cell[5747, 215, 279, 9, 70, "GuideText",
 CellID->352716060],
Cell[6029, 226, 272, 9, 70, "GuideText",
 CellID->222902602]
}, Open  ]],
Cell[CellGroupData[{
Cell[6338, 240, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->421193284],
Cell[6406, 243, 269, 9, 70, "GuideText",
 CellID->228381222],
Cell[6678, 254, 561, 14, 70, "InlineGuideFunctionListing",
 CellID->218183023]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7288, 274, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7353, 277, 206, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[7562, 283, 152, 3, 70, "GuideTutorial",
 CellID->179410169],
Cell[7717, 288, 168, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[7922, 296, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7987, 299, 188, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8178, 306, 171, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[8352, 311, 153, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[8542, 319, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1600987693],
Cell[8615, 322, 713, 18, 70, "GuideRelatedLinks",
 CellID->56367300]
}, Open  ]],
Cell[9343, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

