(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11391,        361]
NotebookOptionsPosition[      7636,        261]
NotebookOutlinePosition[      9771,        306]
CellTagsIndexPosition[      9728,        303]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Random Number Generation", "GuideTitle",
 CellID->8979],

Cell[TextData[{
 "Based on original algorithms developed at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " core randomness generation is both highly efficient and of exceptional \
quality. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "can produce both discrete and continuous randomness, with a wide range of \
distributions conveniently specified in symbolic form."
}], "GuideAbstract",
 CellID->72719645],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " random integer or array of integers"
}], "GuideText",
 CellID->30775],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " random real or array of reals"
}], "GuideText",
 CellID->28410],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "random complex numbers"
}], "GuideText",
 CellID->359172528],

Cell["\t", "GuideDelimiter",
 CellID->40939946],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " random choices from a list"
}], "GuideText",
 CellID->17132],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " random samples or permutation of a list"
}], "GuideText",
 CellID->27089],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "random prime number"
}], "GuideText",
 CellID->119532912],

Cell["\t", "GuideDelimiterSubsection",
 CellID->11854985],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Distributions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StatisticalDistributions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->141147494],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StudentTDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->665361255],

Cell["\t", "GuideDelimiter",
 CellID->27296],

Cell[TextData[{
 Cell[TextData[ButtonBox["SeedRandom",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SeedRandom"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " seed and pick method"
}], "GuideText",
 CellID->11950],

Cell[TextData[{
 Cell[TextData[ButtonBox["BlockRandom",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BlockRandom"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make random number generation localized"
}], "GuideText",
 CellID->23112]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->20122],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "GuideTutorial",
 CellID->328131355],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "GuideTutorial",
 CellID->226520497]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->25836],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAbout",
 CellID->18277],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MathematicsAndAlgorithms"]], "GuideMoreAbout",
 CellID->270774093]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->709726360],

Cell[TextData[{
 ButtonBox["Demonstrations related to Random Number Generation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BlockRandom+OR+NormalDistribution+OR+PoissonDistribution+OR+RandomChoice+OR+\
RandomComplex+OR+RandomInteger+OR+RandomPrime+OR+RandomReal+OR+RandomSample+\
OR+SeedRandom+OR+StudentTDistribution)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->640110410]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Random Number Generation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 50.0809580}", "context" -> "", 
    "keywords" -> {
     "block random", "Gauss integral", "Gaussian distribution", 
      "Gaussian integral", "infrequent events", "localize random generator", 
      "localize random state", "non-frequent events", "normal distribution", 
      "Poisson distribution", "Poisson process", "rand", "random choice", 
      "random complex", "random complex number", "random integer", 
      "random number", "random number generator", "random permutation", 
      "random prime", "random real", "random sample", "random seed", 
      "random selection", "random state", "random subset", "randomint", 
      "rare events", "reset random state", "rnd", "sampling with replacement",
       "sampling without replacement", "seed random", 
      "seeding of random generator", "select randomly", 
      "standard normal distribution", "student distribution", 
      "t distribution", "urn problem"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Based on original algorithms developed at Wolfram Research, \
Mathematica's core randomness generation is both highly efficient and of \
exceptional quality. Mathematica can produce both discrete and continuous \
randomness, with a wide range of distributions conveniently specified in \
symbolic form.", "synonyms" -> {}, "title" -> "Random Number Generation", 
    "type" -> "Guide", "uri" -> "guide/RandomNumberGeneration"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->8979],
Cell[683, 28, 448, 12, 70, "GuideAbstract",
 CellID->72719645],
Cell[1134, 42, 410, 11, 70, "GuideText",
 CellID->30775],
Cell[1547, 55, 398, 11, 70, "GuideText",
 CellID->28410],
Cell[1948, 68, 406, 12, 70, "GuideText",
 CellID->359172528],
Cell[2357, 82, 47, 1, 70, "GuideDelimiter",
 CellID->40939946],
Cell[2407, 85, 399, 11, 70, "GuideText",
 CellID->17132],
Cell[2809, 98, 412, 11, 70, "GuideText",
 CellID->27089],
Cell[3224, 111, 399, 12, 70, "GuideText",
 CellID->119532912],
Cell[3626, 125, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->11854985],
Cell[CellGroupData[{
Cell[3708, 130, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->141147494],
Cell[3950, 138, 1329, 33, 70, "InlineGuideFunctionListing",
 CellID->665361255],
Cell[5282, 173, 44, 1, 70, "GuideDelimiter",
 CellID->27296],
Cell[5329, 176, 244, 8, 70, "GuideText",
 CellID->11950],
Cell[5576, 186, 410, 11, 70, "GuideText",
 CellID->23112]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6035, 203, 58, 1, 70, "GuideTutorialsSection",
 CellID->20122],
Cell[6096, 206, 158, 3, 70, "GuideTutorial",
 CellID->328131355],
Cell[6257, 211, 165, 3, 70, "GuideTutorial",
 CellID->226520497]
}, Open  ]],
Cell[CellGroupData[{
Cell[6459, 219, 59, 1, 70, "GuideMoreAboutSection",
 CellID->25836],
Cell[6521, 222, 133, 3, 70, "GuideMoreAbout",
 CellID->18277],
Cell[6657, 227, 187, 4, 70, "GuideMoreAbout",
 CellID->270774093]
}, Open  ]],
Cell[CellGroupData[{
Cell[6881, 236, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->709726360],
Cell[6953, 239, 641, 17, 70, "GuideRelatedLinks",
 CellID->640110410]
}, Open  ]],
Cell[7609, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

