(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17451,        641]
NotebookOptionsPosition[     12194,        482]
NotebookOutlinePosition[     13894,        520]
CellTagsIndexPosition[     13851,        517]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Raster Image Formats", "GuideTitle",
 CellID->21962],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export anything it displays\[LongDash]graphics, text, formulas, \
notebooks\[LongDash]to any standard raster image format",
 ". ",
 "It can also import from such formats to give ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic graphics, arrays of values, or metadata in various forms. "
}], "GuideAbstract",
 CellID->86969157],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "GIF and animated GIF (.gif)"
}], "GuideText",
 CellID->10508],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "JPEG  (.jpeg, .jpg)"
}], "GuideText",
 CellID->10080],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TIFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " TIFF including fax, etc. (.tiff, .tif)"
}], "GuideText",
 CellID->5340],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PNG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNG"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "PNG format (.png)"
}], "GuideText",
 CellID->12076],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JPEG2000\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG2000"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "JPEG 2000 / JP2 format (.jp2, .j2k)"
}], "GuideText",
 CellID->3207138],

Cell[CellGroupData[{

Cell["System-Specific General Formats", "GuideFunctionsSubsection",
 CellID->138676337],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BMP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BMP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Microsoft bitmap format (.bmp)"
}], "GuideText",
 CellID->9058],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PICT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PICT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Macintosh PICT format (.pict)"
}], "GuideText",
 CellID->31493],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WMF"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"EMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EMF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows metafile and enhanced metafile formats"
}], "GuideText",
 CellID->337420354]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Support Formats", "GuideFunctionsSubsection",
 CellID->238747551],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ACO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ACO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Adobe color palette format (.aco)"
}], "GuideText",
 CellID->344345165],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XBM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XBM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "X bitmap format (suitable for C source code) (.xbm)"
}], "GuideText",
 CellID->142455145],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CUR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CUR"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"ICO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ICO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cursor, icon Windows resource formats"
}], "GuideText",
 CellID->402351867],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PCX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PCX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Windows paintbrush format (.pcx)"
}], "GuideText",
 CellID->62128936]
}, Open  ]],

Cell[CellGroupData[{

Cell["Image & Rendering Formats", "GuideFunctionsSubsection",
 CellID->22506197],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PBM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PBM"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"PGM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PGM"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"PPM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PPM"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"PNM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "ASCII portable bitmap formats"
}], "GuideText",
 CellID->345051190],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PXR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PXR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Pixar raster format (.pxr)"
}], "GuideText",
 CellID->393242375],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TGA\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TGA"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "TrueVision Targa format (.tga)"
}], "GuideText",
 CellID->561721303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Printing-Related Formats", "GuideFunctionsSubsection",
 CellID->189911164],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SCT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SCT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Scitex CT prepress format (.sct)"
}], "GuideText",
 CellID->386245592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Scientific & Medical Image Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScientificAndMedicalDataFormats"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->204328214],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FITS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FITS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "FITS astronomical image format (.fit, .fits)"
}], "GuideText",
 CellID->380943316],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DICOM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DICOM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "DICOM medical image format (.dcm, .dic)"
}], "GuideText",
 CellID->278838044],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"HDF5\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF5"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"CDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDF"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"NetCDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NetCDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scientific data & image formats"
}], "GuideText",
 CellID->1000717898]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raw Formats", "GuideFunctionsSubsection",
 CellID->319633407],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RawBitmap\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RawBitmap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pure binary bitmap data, with type and dimensions specified separately"
}], "GuideText",
 CellID->95130016],

Cell["\t", "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Data Elements", "GuideFunctionsSubsection",
 CellID->20474],

Cell["\<\
\"Graphics\" \[LongDash] graphics object that displays as the image\
\>", "GuideText",
 CellID->24773],

Cell["\<\
\"Data\" \[LongDash] array of numbers or lists giving numerical color values\
\>", "GuideText",
 CellID->19097],

Cell[TextData[{
 "\"RGBData\"",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "array of ",
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 " objects"
}], "GuideText",
 CellID->382775788],

Cell["\<\
\"Rules\" \[LongDash] rules for all elements\
\>", "GuideText",
 CellID->8880],

Cell["\<\
\"Elements\" \[LongDash] all available elements\
\>", "GuideText",
 CellID->11500518],

Cell["\t", "GuideDelimiterSubsection",
 CellID->23335]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "GuideFunctionsSubsection",
 CellID->11072],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImageResolution",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageResolution"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Background",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Background"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23400],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate graphics from an array of color or grayscale levels"
}], "GuideText",
 CellID->65214407],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output to a raster representation"
}], "GuideText",
 CellID->10554794]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->707],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->76300026],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->310182235]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->4141],

Cell[TextData[ButtonBox["Vector Graphics Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VectorGraphicsFormats"]], "GuideMoreAbout",
 CellID->23588],

Cell[TextData[ButtonBox["Multimedia Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MultimediaFormats"]], "GuideMoreAboutSub",
 CellID->28315],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Raster Image Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 50.5184692}", "context" -> "", 
    "keywords" -> {
     "additive color", "array plot", "background color", "bitmap formats", 
      "bitmaps", "CMY", "CMYK", "color model", "color space", 
      "density of lines", "device color", "diffuse color", "dot density", 
      "dots per inch", "graphics size", "image formats", "image resolution", 
      "image size", "matrix structure plot", "picture formats", 
      "picture size", "pigment", "printer resolution", "raster formats", 
      "resolution", "RGB", "RGB color model", "RGBA", "screen density"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica can export anything it displays--graphics, text, formulas, \
notebooks--to any standard raster image format. It can also import from such \
formats to give Mathematica symbolic graphics, arrays of values, or metadata \
in various forms. ", "synonyms" -> {}, "title" -> "Raster Image Formats", 
    "type" -> "Guide", "uri" -> "guide/RasterImageFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->21962],
Cell[680, 28, 413, 11, 70, "GuideAbstract",
 CellID->86969157],
Cell[1096, 41, 253, 9, 70, "GuideText",
 CellID->10508],
Cell[1352, 52, 247, 9, 70, "GuideText",
 CellID->10080],
Cell[1602, 63, 260, 8, 70, "GuideText",
 CellID->5340],
Cell[1865, 73, 243, 9, 70, "GuideText",
 CellID->12076],
Cell[2111, 84, 273, 9, 70, "GuideText",
 CellID->3207138],
Cell[CellGroupData[{
Cell[2409, 97, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->138676337],
Cell[2499, 100, 255, 9, 70, "GuideText",
 CellID->9058],
Cell[2757, 111, 257, 9, 70, "GuideText",
 CellID->31493],
Cell[3017, 122, 399, 12, 70, "GuideText",
 CellID->337420354]
}, Open  ]],
Cell[CellGroupData[{
Cell[3453, 139, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->238747551],
Cell[3534, 142, 258, 8, 70, "GuideText",
 CellID->344345165],
Cell[3795, 152, 281, 9, 70, "GuideText",
 CellID->142455145],
Cell[4079, 163, 395, 13, 70, "GuideText",
 CellID->402351867],
Cell[4477, 178, 261, 9, 70, "GuideText",
 CellID->62128936]
}, Open  ]],
Cell[CellGroupData[{
Cell[4775, 192, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->22506197],
Cell[4858, 195, 643, 21, 70, "GuideText",
 CellID->345051190],
Cell[5504, 218, 256, 9, 70, "GuideText",
 CellID->393242375],
Cell[5763, 229, 260, 9, 70, "GuideText",
 CellID->561721303]
}, Open  ]],
Cell[CellGroupData[{
Cell[6060, 243, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->189911164],
Cell[6143, 246, 262, 9, 70, "GuideText",
 CellID->386245592]
}, Open  ]],
Cell[CellGroupData[{
Cell[6442, 260, 255, 6, 70, "GuideFunctionsSubsection",
 CellID->204328214],
Cell[6700, 268, 276, 9, 70, "GuideText",
 CellID->380943316],
Cell[6979, 279, 273, 9, 70, "GuideText",
 CellID->278838044],
Cell[7255, 290, 654, 21, 70, "GuideText",
 CellID->1000717898]
}, Open  ]],
Cell[CellGroupData[{
Cell[7946, 316, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->319633407],
Cell[8016, 319, 311, 9, 70, "GuideText",
 CellID->95130016],
Cell[8330, 330, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],
Cell[CellGroupData[{
Cell[8420, 336, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->20474],
Cell[8495, 339, 112, 3, 70, "GuideText",
 CellID->24773],
Cell[8610, 344, 121, 3, 70, "GuideText",
 CellID->19097],
Cell[8734, 349, 267, 11, 70, "GuideText",
 CellID->382775788],
Cell[9004, 362, 88, 3, 70, "GuideText",
 CellID->8880],
Cell[9095, 367, 95, 3, 70, "GuideText",
 CellID->11500518],
Cell[9193, 372, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->23335]
}, Open  ]],
Cell[CellGroupData[{
Cell[9284, 378, 59, 1, 70, "GuideFunctionsSubsection",
 CellID->11072],
Cell[9346, 381, 620, 17, 70, "InlineGuideFunctionListing",
 CellID->23400],
Cell[9969, 400, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[10020, 403, 290, 9, 70, "GuideText",
 CellID->65214407],
Cell[10313, 414, 475, 15, 70, "GuideText",
 CellID->10554794]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10837, 435, 56, 1, 70, "GuideTutorialsSection",
 CellID->707],
Cell[10896, 438, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[11071, 443, 173, 3, 70, "GuideTutorial",
 CellID->76300026],
Cell[11247, 448, 174, 3, 70, "GuideTutorial",
 CellID->310182235]
}, Open  ]],
Cell[CellGroupData[{
Cell[11458, 456, 58, 1, 70, "GuideMoreAboutSection",
 CellID->4141],
Cell[11519, 459, 157, 3, 70, "GuideMoreAbout",
 CellID->23588],
Cell[11679, 464, 151, 3, 70, "GuideMoreAboutSub",
 CellID->28315],
Cell[11833, 469, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[11994, 474, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],
Cell[12167, 480, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

