(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17028,        532]
NotebookOptionsPosition[     10772,        383]
NotebookOutlinePosition[     14397,        449]
CellTagsIndexPosition[     14354,        446]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Rearranging & Restructuring Lists", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encapsulates in a small number of functions vast flexibility in \
rearranging lists with any structure and any number of elements. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten out any sequence of levels in a nested list"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Partition"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "partition lists or nested lists into sublists"
}], "GuideText",
 CellID->76412982],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "join lists together at any level"
}], "GuideText",
 CellID->700982941],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FlattenAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FlattenAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sequence",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sequence"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1202112],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sort lexicographically, or with any comparison function"
}], "GuideText",
 CellID->159838845],

Cell[TextData[{
 Cell[TextData[ButtonBox["SortBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SortBy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sort by the values of a function applied to elements"
}], "GuideText",
 CellID->57610078],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reverse a list, at any level"
}], "GuideText",
 CellID->157439807],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotateLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RotateLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["RotateRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RotateRight"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cyclically rotate lists at any depth"
}], "GuideText",
 CellID->203530281],

Cell["\t", "GuideDelimiter",
 CellID->713336516],

Cell[TextData[{
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transpose any collection of levels"
}], "GuideText",
 CellID->789397626],

Cell["\t", "GuideDelimiter",
 CellID->9809035],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["PadRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadRight"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pad lists at any depth"
}], "GuideText",
 CellID->534529592],

Cell[TextData[{
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "intersperse additional elements"
}], "GuideText",
 CellID->121529587],

Cell["\t", "GuideDelimiter",
 CellID->80263276],

Cell[TextData[{
 Cell[TextData[ButtonBox["Split",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Split"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "split into runs of identical elements"
}], "GuideText",
 CellID->9075676],

Cell[TextData[{
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " enumerate, tally all distinct elements in a list"
}], "GuideText",
 CellID->32443230],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tuples",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tuples"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Subsets",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subsets"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->35346027],

Cell["\t", "GuideDelimiter",
 CellID->96609445],

Cell[TextData[{
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Intersection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Intersection"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complement"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->83064890],

Cell["\t", "GuideDelimiterSubsection",
 CellID->206845712],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Element-Oriented Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ElementsOfLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->260482165],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppendTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppendTo"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->535492398]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Lists as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "GuideTutorial",
 CellID->229083662],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "GuideTutorial",
 CellID->236532344],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "GuideTutorial",
 CellID->76745283],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "GuideTutorial",\

 CellID->65721767],

Cell[TextData[ButtonBox["Grouping and Combining Elements of Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GroupingAndCombiningElementsOfLists"]], "GuideTutorial",
 CellID->599187409],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "GuideTutorial",
 CellID->562672927],

Cell[TextData[ButtonBox["Combining Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombiningLists"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "GuideMoreAbout",
 CellID->1026288246],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rearranging & Restructuring Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 54.9092066}", "context" -> "", 
    "keywords" -> {
     "absent from list", "alphabetic", "alphabetizing of lists", "append to", 
      "appending", "arrange", "array flatten", "ascending order", 
      "Beck parameters", "block matrices", "blocking lists", "blocks", 
      "canonical order", "catenating lists", "census", "changing parts", 
      "circular partitioning", "collapse", "collating of strings", 
      "collation", "combinations", "combining lists", "concatenating lists", 
      "contraction", "cycle", "cyclic partitioning", "decreasing order", 
      "deleting elements", "descending order", "difference of sets", 
      "discard elements", "disjointness", "distinct elements in lists", 
      "dithering", "encoding", "equivalence class counting", 
      "extraction of sublists", "flat list", "flatten at", "flatten matrix", 
      "frequencies", "gather", "gathering elements in lists", 
      "generating tuples", "grade in APL", "handles", "hot spots", 
      "increasing order", "interleave", "join block matrices", "join lists", 
      "knobs", "k-subsets", "left shift", "levels", "list append", 
      "list complement", "lists", "lists ordering", "matrix transpose", 
      "merging lists", "multiple parts", "multiplicities", "neighborhoods", 
      "one-dimensional list", "ordered pairs", "overhangs", 
      "overlap between lists", "padding", "pad left", "pad right", "pairs", 
      "partitioning lists", "parts", "perm", "permutation of indices", 
      "permutations of lists", "permute", 
      "picking out sequences of elements in lists", "powerset", 
      "random permutation", "random sample", "random subset", "ravel in APL", 
      "rearrangements", "remove duplicates", "removing elements from lists", 
      "removing sublists", "reordering of lists", "reorderings", 
      "replace part", "replacements", "reshape in APL", "right shift", 
      "rotate left", "rotate right", "run-length encoding", 
      "run length encoding", "runs of arguments", 
      "sampling without replacement", "segments of lists", 
      "selecting objects with ordering", "sequence of elements", 
      "set exponential", "sets", "sorting of lists", "splicing", 
      "splitting lists", "squash", "stride", "subexpressions", "sublists", 
      "submatrices", "subset permutations", "subtraction of sets", "tally", 
      "transpose of matrices", "transposition of lists", "triples", 
      "unflatten", "union of sets", "uniq", "unique elements in lists", 
      "unravel", "vectors", "wraparound partitioning"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica encapsulates in a small number of functions vast flexibility \
in rearranging lists with any structure and any number of elements. ", 
    "synonyms" -> {}, "title" -> "Rearranging & Restructuring Lists", "type" -> 
    "Guide", "uri" -> "guide/RearrangingAndRestructuringLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 75, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[697, 28, 242, 6, 70, "GuideAbstract",
 CellID->2001916300],
Cell[942, 36, 278, 9, 70, "GuideText",
 CellID->203374175],
Cell[1223, 47, 275, 9, 70, "GuideText",
 CellID->76412982],
Cell[1501, 58, 253, 9, 70, "GuideText",
 CellID->700982941],
Cell[1757, 69, 757, 20, 70, "InlineGuideFunctionListing",
 CellID->1202112],
Cell[2517, 91, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2568, 94, 271, 8, 70, "GuideText",
 CellID->159838845],
Cell[2842, 104, 271, 8, 70, "GuideText",
 CellID->57610078],
Cell[3116, 114, 250, 8, 70, "GuideText",
 CellID->157439807],
Cell[3369, 124, 402, 13, 70, "GuideText",
 CellID->203530281],
Cell[3774, 139, 48, 1, 70, "GuideDelimiter",
 CellID->713336516],
Cell[3825, 142, 265, 9, 70, "GuideText",
 CellID->789397626],
Cell[4093, 153, 46, 1, 70, "GuideDelimiter",
 CellID->9809035],
Cell[4142, 156, 376, 13, 70, "GuideText",
 CellID->534529592],
Cell[4521, 171, 401, 12, 70, "GuideText",
 CellID->121529587],
Cell[4925, 185, 47, 1, 70, "GuideDelimiter",
 CellID->80263276],
Cell[4975, 188, 258, 9, 70, "GuideText",
 CellID->9075676],
Cell[5236, 199, 531, 15, 70, "GuideText",
 CellID->32443230],
Cell[5770, 216, 966, 26, 70, "InlineGuideFunctionListing",
 CellID->35346027],
Cell[6739, 244, 47, 1, 70, "GuideDelimiter",
 CellID->96609445],
Cell[6789, 247, 609, 17, 70, "InlineGuideFunctionListing",
 CellID->83064890],
Cell[7401, 266, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->206845712],
Cell[CellGroupData[{
Cell[7484, 271, 232, 6, 70, "GuideFunctionsSubsection",
 CellID->260482165],
Cell[7719, 279, 1006, 29, 70, "InlineGuideFunctionListing",
 CellID->535492398]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8774, 314, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8839, 317, 143, 3, 70, "GuideTutorial",
 CellID->229083662],
Cell[8985, 322, 152, 3, 70, "GuideTutorial",
 CellID->236532344],
Cell[9140, 327, 164, 3, 70, "GuideTutorial",
 CellID->76745283],
Cell[9307, 332, 177, 4, 70, "GuideTutorial",
 CellID->65721767],
Cell[9487, 338, 197, 4, 70, "GuideTutorial",
 CellID->599187409],
Cell[9687, 344, 151, 3, 70, "GuideTutorial",
 CellID->562672927],
Cell[9841, 349, 149, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[10027, 357, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10092, 360, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10246, 365, 150, 3, 70, "GuideMoreAbout",
 CellID->1026288246],
Cell[10399, 370, 168, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[10570, 375, 160, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[10745, 381, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

