(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13985,        430]
NotebookOptionsPosition[      8331,        301]
NotebookOutlinePosition[     12242,        373]
CellTagsIndexPosition[     12199,        370]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Recurrence and Sum Functions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a wide coverage of named functions defined by sums and recurrence \
relations. Often using original algorithms developed at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports highly efficient exact evaluation even for results involving \
millions of digits. "
}], "GuideAbstract",
 CellID->463116994],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fibonacci",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fibonacci"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LucasL",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LucasL"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Fibonacci and Lucas numbers and polynomials"
}], "GuideText",
 CellID->65923607],

Cell[TextData[{
 Cell[TextData[ButtonBox["BernoulliB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BernoulliB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Bernoulli numbers and polynomials"
}], "GuideText",
 CellID->90267064],

Cell[TextData[{
 Cell[TextData[ButtonBox["NorlundB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NorlundB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "N\[ODoubleDot]rlund polynomials and generalized Bernoulli polynomials"
}], "GuideText",
 CellID->29902029],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerE"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Euler numbers and polynomials"
}], "GuideText",
 CellID->223577656],

Cell[TextData[{
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["StirlingS2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS2"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Stirling numbers"
}], "GuideText",
 CellID->72893588],

Cell["\t", "GuideDelimiter",
 CellID->463389729],

Cell[TextData[{
 Cell[TextData[ButtonBox["HarmonicNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "harmonic numbers"
}], "GuideText",
 CellID->740227173],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyGamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "polygamma functions"
}], "GuideText",
 CellID->15014709],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LerchPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LerchPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolyLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyLog"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24278278],

Cell["\t", "GuideDelimiter",
 CellID->968637371],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Factorial2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial2"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial2"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CatalanNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CatalanNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BellB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BellB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->26150303],

Cell["\t", "GuideDelimiter",
 CellID->192546077],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve general recurrence relations"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute general finite and infinite sums"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general matrix exponential"
}], "GuideText",
 CellID->26401733]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->182450445],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "GuideTutorial",
 CellID->747475449]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1382011944],

Cell[TextData[{
 ButtonBox["Demonstrations related to Recurrence and Sum Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(BellB+\
OR+BernoulliB+OR+Binomial+OR+CatalanNumber+OR+EulerE+OR+Factorial+OR+\
Factorial2+OR+Fibonacci+OR+HarmonicNumber+OR+LerchPhi+OR+LucasL+OR+MatrixExp+\
OR+NorlundB+OR+PolyGamma+OR+PolyLog+OR+RSolve+OR+StirlingS1+OR+StirlingS2+OR+\
Sum+OR+Zeta)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->301454282]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Recurrence and Sum Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 55.7998544}", "context" -> "", 
    "keywords" -> {
     "Abramov algorithm", "Adamchik techniques", 
      "arithmetic difference equations", "bang", "Bernoulli B", 
      "Bernoulli numbers", "Bernoulli polynomials", "binom", "binomials", 
      "Bronstein algorithm", "Catalan beta function", "Catalan number", 
      "choose", "Clausen function", "comb", "combinations", "d'Alembert test",
       "difference-algebraic equations", "difference equations", 
      "digamma function", "dilog", "dilogarithm function", 
      "Dirichlet L series", "Dirichlet series", "discrete equations", 
      "divide-and-conquer equations", "double factorial", 
      "enumeration of permutations", "Euler-Maclaurin summation", 
      "Euler numbers", "Euler polynomials", "exclamation point", 
      "exponentials of matrices", "fact", "factorial", 
      "Fermi-Dirac integrals", "fib", "Fibonacci equations", 
      "Fibonacci recurrence", "Fibonacci sequence", 
      "finite difference equations", "gamma function", 
      "generalized Bernoulli numbers", "generalized Bernoulli polynomials", 
      "generalized zeta function", "geometric difference equations", 
      "Germundsson methods", "Goktas methods", "Gradshteyn-Ryzhik", 
      "harmonic number", "harmonic numbers", "harmonic series", 
      "Hurwitz zeta function", "hypergeometric sums", "hyperlogarithm", 
      "integer sequence equations", "Jonquiere's function", 
      "Jordan decomposition", "Lerch function Phi", "Lerch phi", 
      "Lerch transcendent", "L-series in number theory", "Lucas number", 
      "Lucas numbers", "Lucas sequence", "matrix exp", "matrix exponential", 
      "n-choose-k", "nchoosek", "nCk", "Nielsen functions", 
      "Norlund polynomials", "No\"rlund polynomials", "number of partitions", 
      "partial difference equations", "partial recurrence equations", 
      "partitions", "phi", "poly-gamma", "poly gamma", "poly log", 
      "polylogarithm", "power series", "psi", "psi function", 
      "Putzer's method", "Raabe test", "recurrence equations", 
      "recursion equations", "Riemann hypothesis", "Riemann-Siegel formula", 
      "Riemann zeta function", "secant numbers", "sequence equations", 
      "sequences", "series", "shriek", "Spence's integral", "Stirling1", 
      "Stirling2", "Stirling number of the 1st kind", 
      "Stirling number of the 2nd kind", "Stirling number of the first kind", 
      "Stirling number of the second kind", "Stirling numbers", 
      "Stirling numbers S1", "Stirling numbers S2", "Stirling s1", 
      "Stirling s2", "sums", "sums of reciprocal powers", "symbolic sums", 
      "symmetry reduction", "trilogarithm", "van Hoeij algorithms", 
      "zeta function", "zig numbers"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has a wide coverage of named functions defined by sums and \
recurrence relations. Often using original algorithms developed at Wolfram \
Research, Mathematica supports highly efficient exact evaluation even for \
results involving millions of digits. ", "synonyms" -> {}, "title" -> 
    "Recurrence and Sum Functions", "type" -> "Guide", "uri" -> 
    "guide/RecurrenceAndSumFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[692, 28, 403, 10, 70, "GuideAbstract",
 CellID->463116994],
Cell[1098, 40, 541, 16, 70, "GuideText",
 CellID->65923607],
Cell[1642, 58, 265, 9, 70, "GuideText",
 CellID->90267064],
Cell[1910, 69, 442, 12, 70, "GuideText",
 CellID->29902029],
Cell[2355, 83, 254, 9, 70, "GuideText",
 CellID->223577656],
Cell[2612, 94, 379, 13, 70, "GuideText",
 CellID->72893588],
Cell[2994, 109, 48, 1, 70, "GuideDelimiter",
 CellID->463389729],
Cell[3045, 112, 257, 9, 70, "GuideText",
 CellID->740227173],
Cell[3305, 123, 249, 9, 70, "GuideText",
 CellID->15014709],
Cell[3557, 134, 593, 17, 70, "InlineGuideFunctionListing",
 CellID->24278278],
Cell[4153, 153, 48, 1, 70, "GuideDelimiter",
 CellID->968637371],
Cell[4204, 156, 1537, 45, 70, "InlineGuideFunctionListing",
 CellID->26150303],
Cell[5744, 203, 48, 1, 70, "GuideDelimiter",
 CellID->192546077],
Cell[5795, 206, 259, 9, 70, "GuideText",
 CellID->203374175],
Cell[6057, 217, 260, 9, 70, "GuideText",
 CellID->1463276848],
Cell[6320, 228, 256, 9, 70, "GuideText",
 CellID->26401733]
}, Open  ]],
Cell[CellGroupData[{
Cell[6613, 242, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6678, 245, 206, 4, 70, "GuideTutorial",
 CellID->182450445],
Cell[6887, 251, 171, 3, 70, "GuideTutorial",
 CellID->747475449]
}, Open  ]],
Cell[CellGroupData[{
Cell[7095, 259, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7160, 262, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7314, 267, 167, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[CellGroupData[{
Cell[7518, 275, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1382011944],
Cell[7591, 278, 698, 18, 70, "GuideRelatedLinks",
 CellID->301454282]
}, Open  ]],
Cell[8304, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

